/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.tds.simple;

import com.ibm.cognos.tds.TDS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleTDS
implements TDS {
    private Map<String, Map<String, String>> maps = new ConcurrentHashMap<String, Map<String, String>>();
    private Map<String, Map<String, Map<String, String>>> mappedMaps = new ConcurrentHashMap<String, Map<String, Map<String, String>>>();

    @Override
    public String getValue(String mapID, String sessionID) {
        Map<String, String> map = this.getMap(mapID);
        return map.get(sessionID);
    }

    private Map<String, String> getMap(String mapID) {
        if (null == mapID) {
            throw new NullPointerException();
        }
        Map<String, String> map = this.maps.get(mapID);
        if (null == map) {
            map = this.createMap(mapID);
        }
        return map;
    }

    private Map<String, String> getMappedMap(String mapID, String sessionID) {
        if (null == mapID || sessionID == null) {
            throw new NullPointerException();
        }
        Map<String, Map<String, String>> mappedMap = this.mappedMaps.get(mapID);
        if (null == mappedMap) {
            mappedMap = this.createMappedMap(mapID, sessionID);
        }
        if (!mappedMap.containsKey(sessionID)) {
            ConcurrentHashMap map = new ConcurrentHashMap();
            mappedMap.put(sessionID, map);
        }
        return mappedMap.get(sessionID);
    }

    private Map<String, String> createMap(String mapID) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        this.maps.put(mapID, map);
        return map;
    }

    private Map<String, Map<String, String>> createMappedMap(String mapID, String sessionID) {
        ConcurrentHashMap<String, Map<String, String>> map = new ConcurrentHashMap<String, Map<String, String>>();
        ConcurrentHashMap sessionMap = new ConcurrentHashMap();
        map.put(sessionID, sessionMap);
        this.mappedMaps.put(mapID, map);
        return map;
    }

    @Override
    public String putValue(String mapID, String sessionID, String value) {
        Map<String, String> map = this.getMap(mapID);
        return map.put(sessionID, value);
    }

    @Override
    public void removeValue(String mapID, String sessionID) {
        Map<String, String> map = this.getMap(mapID);
        map.remove(sessionID);
    }

    public void clear() {
        for (Map<String, String> map : this.maps.values()) {
            map.clear();
        }
        this.maps.clear();
        for (Map<String, Object> map : this.mappedMaps.values()) {
            for (Map map2 : map.values()) {
                map2.clear();
            }
            map.clear();
        }
    }

    @Override
    public String getMappedValue(String mapID, String sessionID, String key) {
        Map<String, String> sessionMap = this.getMappedMap(mapID, sessionID);
        return sessionMap.get(key);
    }

    @Override
    public String putMappedValue(String mapID, String sessionID, String key, String value) {
        Map<String, String> sessionMap = this.getMappedMap(mapID, sessionID);
        return sessionMap.put(key, value);
    }

    @Override
    public void removeMappedValue(String mapID, String sessionID, String key) {
        Map<String, String> sessionMap = this.getMappedMap(mapID, sessionID);
        sessionMap.remove(key);
    }

    @Override
    public List<String> getMappedValuesForSession(String mapID, String sessionID) {
        Map<String, String> sessionMap = this.getMappedMap(mapID, sessionID);
        return new ArrayList<String>(sessionMap.keySet());
    }
}

