/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.org.apache.commons.lang.builder.ToStringBuilder;
import com.ibm.cognos.jdbc.twc.org.apache.commons.lang.builder.ToStringStyle;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;

class QueryStatus {
    private final String requestId;
    private final AtomicReference<State> state;
    private volatile Throwable error;
    private volatile Instant startTime;
    private volatile Instant stopTime;

    QueryStatus(String theRequestId) {
        this.requestId = theRequestId;
        this.state = new AtomicReference<State>(State.PENDING);
    }

    String getRequestId() {
        return this.requestId;
    }

    State getState() {
        return this.state.get();
    }

    Instant getStartTime() {
        return this.startTime;
    }

    Instant getStopTime() {
        return this.stopTime;
    }

    Duration elapsedTime() {
        if (null == this.startTime) {
            return Duration.ZERO;
        }
        if (null == this.stopTime) {
            return Duration.between(this.startTime, Instant.now());
        }
        return Duration.between(this.startTime, this.stopTime);
    }

    Throwable getError() {
        return this.error;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("requestId", this.requestId).append("state", (Object)this.state.get()).append("startTime", this.startTime).append("stopTime", this.stopTime).append("error", this.error).toString();
    }

    boolean start() {
        if (this.state.compareAndSet(State.PENDING, State.RUNNING)) {
            this.startTime = Instant.now();
            return true;
        }
        return false;
    }

    boolean complete() {
        if (this.state.compareAndSet(State.RUNNING, State.COMPLETED)) {
            this.stopTime = Instant.now();
            return true;
        }
        return false;
    }

    boolean fail(Throwable reason) {
        if (this.state.compareAndSet(State.RUNNING, State.FAILED)) {
            this.stopTime = Instant.now();
            this.error = reason;
            return true;
        }
        return false;
    }

    boolean isPendingOrRunning() {
        return State.PENDING.equals((Object)this.state.get()) || State.RUNNING.equals((Object)this.state.get());
    }

    boolean isSuccessful() {
        return State.COMPLETED.equals((Object)this.state.get());
    }

    boolean isNotRunning() {
        return !State.RUNNING.equals((Object)this.state.get());
    }

    boolean hasFailed() {
        return State.FAILED.equals((Object)this.state.get());
    }

    public static enum State {
        PENDING,
        RUNNING,
        COMPLETED,
        FAILED;

    }
}

