/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.CacheManager;
import com.ibm.cognos.jdbc.twc.QueryExecutor;
import com.ibm.cognos.jdbc.twc.QueryResult;
import com.ibm.cognos.jdbc.twc.TWCConnectionString;
import com.ibm.cognos.jdbc.twc.TWCDatabaseMetaData;
import com.ibm.cognos.jdbc.twc.TWCDriver;
import com.ibm.cognos.jdbc.twc.TWCPreparedStatement;
import com.ibm.cognos.jdbc.twc.TWCStatement;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLErrorCode;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLState;
import com.ibm.cognos.jdbc.twc.metadata.generated.Catalog;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.metadata.generated.Schema;
import com.ibm.cognos.jdbc.twc.metadata.generated.Server;
import com.ibm.cognos.jdbc.twc.metadata.generated.Table;
import com.ibm.cognos.jdbc.twc.org.slf4j.Logger;
import com.ibm.cognos.jdbc.twc.org.slf4j.LoggerFactory;
import java.net.URI;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TWCConnection
implements Connection,
TWCMessageKeys {
    private static final Logger LOGGER = LoggerFactory.getLogger(TWCConnection.class);
    private static final String[] ALL_PRODUCTS_ARR = new String[]{"Dewpoint", "FeelsLike", "Gust", "MSLP", "PrecipAmount", "RelativeHumidity", "SnowAmount", "Temperature", "UVIndex", "Visibility", "WindSpeed"};
    private static final String PREPARE_CALL = "prepareCall";
    private static final String PREPARED_STATEMENT = "preparedStatement";
    private static final String PASSWORD = "password";
    private static final String SLASH_STR = "/";
    private Properties connectionProperties = new Properties();
    private final AtomicBoolean closed;
    private final String connectionUUID;
    private final Server mdView;
    private final TWCConnectionString connectionStr;
    private final QueryExecutor executor;
    private final CacheManager cacheMgr;

    TWCConnection(TWCConnectionString twcConnStr, QueryExecutor queryExecutor, CacheManager cacheManager) throws SQLException {
        Objects.requireNonNull(twcConnStr, TWCMessageUtil.getMessage("0007", "twcConnStr"));
        Objects.requireNonNull(queryExecutor, TWCMessageUtil.getMessage("0007", "queryExecutor"));
        Objects.requireNonNull(cacheManager, TWCMessageUtil.getMessage("0007", "cacheMgr"));
        this.closed = new AtomicBoolean(false);
        this.mdView = TWCConnection.extractFilteredTWCMetadata(twcConnStr, queryExecutor);
        this.connectionStr = twcConnStr;
        this.executor = queryExecutor;
        this.cacheMgr = cacheManager;
        this.connectionUUID = UUID.randomUUID().toString();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(TWCMessageUtil.getMessage("0009", iface), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.INVALID_UNWRAP.getErrorCode());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return new TWCStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return new TWCPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw TWCConnection.notSupported(PREPARE_CALL);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        throw TWCConnection.notSupported("setAutoCommit");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        throw TWCConnection.notSupported("commit");
    }

    @Override
    public void rollback() throws SQLException {
        throw TWCConnection.notSupported("rollback");
    }

    @Override
    public void close() throws SQLException {
        if (this.closed.compareAndSet(false, true)) {
            this.executor.close();
            this.cacheMgr.deregisterConnection(this.connectionUUID);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new TWCDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw TWCConnection.notSupported("setReadOnly");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw TWCConnection.notSupported("setCatalog");
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.connectionStr.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw TWCConnection.notSupported("setTransactionIsolation");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        return new TWCStatement(this);
    }

    private void checkResultSetConcurrency(int resultSetConcurrency) throws SQLException {
        if (1007 != resultSetConcurrency) {
            throw new SQLException(TWCMessageUtil.getMessage("0006", 1007, resultSetConcurrency), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.INVALID_CONCURRENCY.getErrorCode());
        }
    }

    private void checkResultSetType(int resultSetType) throws SQLException {
        if (1003 != resultSetType) {
            throw new SQLException(TWCMessageUtil.getMessage("0005", 1003, resultSetType), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.INVALID_RESULTSET_TYPE.getErrorCode());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        return new TWCPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw TWCConnection.notSupported(PREPARE_CALL);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw TWCConnection.notSupported("getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw TWCConnection.notSupported("setTypeMap");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw TWCConnection.notSupported("setHoldability");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw TWCConnection.notSupported("getHoldability");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw TWCConnection.notSupported("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw TWCConnection.notSupported("setSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw TWCConnection.notSupported("rollback Savepoint");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw TWCConnection.notSupported("releaseSavePoint");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        if (2 != resultSetHoldability) {
            throw new SQLException(TWCMessageUtil.getMessage("0004", 2, resultSetHoldability), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.UNSUPPORTED_CURSOR_COMMIT.getErrorCode());
        }
        return new TWCStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        if (2 != resultSetHoldability) {
            throw new SQLException(TWCMessageUtil.getMessage("0004", 2, resultSetHoldability), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.UNSUPPORTED_CURSOR_COMMIT.getErrorCode());
        }
        return new TWCPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw TWCConnection.notSupported(PREPARE_CALL);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw TWCConnection.notSupported(PREPARED_STATEMENT);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw TWCConnection.notSupported(PREPARED_STATEMENT);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw TWCConnection.notSupported(PREPARED_STATEMENT);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw TWCConnection.notSupported("createClob");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw TWCConnection.notSupported("createBlob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw TWCConnection.notSupported("createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw TWCConnection.notSupported("createSQLXML");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException(TWCMessageUtil.getMessage("0002"), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.NEGATIVE_VALUE_NOT_ALLOWED.getErrorCode());
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connectionProperties.put(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (null == properties) {
            return;
        }
        this.connectionProperties.putAll((Map<?, ?>)properties);
    }

    private Properties getPropertiesFromDatabaseMetadata() throws SQLException {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.connectionProperties);
        p.remove(PASSWORD.toUpperCase());
        return p;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        Properties p = this.getPropertiesFromDatabaseMetadata();
        return p.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.getPropertiesFromDatabaseMetadata();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw TWCConnection.notSupported("createArrayOf");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw TWCConnection.notSupported("createStruct");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw TWCConnection.notSupported("setSchema");
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connectionStr.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkOpen();
        if (milliseconds < 0) {
            throw new SQLException(TWCMessageUtil.getMessage("0002"), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.NEGATIVE_VALUE_NOT_ALLOWED.getErrorCode());
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkOpen();
        return QueryExecutor.TIMEOUT_IN_MILLIS;
    }

    URI getTWCURI() {
        return this.connectionStr.getURI();
    }

    Server getMetadataView() {
        return this.mdView;
    }

    String getConnectionUUID() {
        return this.connectionUUID;
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TWCMessageUtil.getMessage("0001"), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.STATEMENT_CLOSED.getErrorCode());
        }
    }

    QueryResult executeQuery(String queryId, String sql, TWCStatement statement) {
        return this.executor.executeQuery(queryId, this.connectionUUID, this.mdView, sql, statement, this.connectionStr, this.cacheMgr);
    }

    void cancelQuery(String queryId) throws SQLException {
        this.executor.cancelQuery(queryId);
    }

    private static SQLFeatureNotSupportedException notSupported(String s) {
        return new SQLFeatureNotSupportedException(TWCMessageUtil.getMessage("0003", s), TWCSQLState.FEATURE_NOT_SUPPORTED.getState(), TWCSQLErrorCode.JDBC_FEATURE_NOT_SUPPORTED.getErrorCode());
    }

    static Server extractFilteredTWCMetadata(TWCConnectionString twcConnStr, QueryExecutor executor) throws SQLException {
        try {
            boolean hasChanged = false;
            Server filteredTWCMD = TWCDriver.TWC_METADATA;
            if (twcConnStr.isFilterMode()) {
                String twcMetaAsString = TWCDriver.jacksonObjectMapper.writeValueAsString(filteredTWCMD);
                filteredTWCMD = TWCDriver.jacksonObjectMapper.readValue(twcMetaAsString, Server.class);
                for (int catalogCounter = 0; catalogCounter < filteredTWCMD.getCatalogs().size(); ++catalogCounter) {
                    Catalog catalog = filteredTWCMD.getCatalogs().get(catalogCounter);
                    Catalog originalCatalog = TWCDriver.TWC_METADATA.getCatalogs().get(catalogCounter);
                    for (int schemaCounter = 0; schemaCounter < catalog.getSchemas().size(); ++schemaCounter) {
                        Schema schema = catalog.getSchemas().get(schemaCounter);
                        Schema originalSchema = originalCatalog.getSchemas().get(schemaCounter);
                        if (null != schema.getFilterPath()) {
                            List<Object> theProducts;
                            block10: {
                                String productsURIStr = new StringJoiner(SLASH_STR).add(twcConnStr.getURI().toString()).add(catalog.getRelativePath().value()).add(schema.getRelativePath().value()).add(schema.getFilterPath()).toString();
                                theProducts = new LinkedList();
                                try {
                                    String response = executor.executePlainRequest(productsURIStr, twcConnStr);
                                    theProducts = Arrays.asList((Object[])TWCDriver.jacksonObjectMapper.readValue(response, String[].class));
                                }
                                catch (Exception requestEx) {
                                    String message = requestEx.getMessage();
                                    if (null != message && message.contains("401")) break block10;
                                    LOGGER.error("Error when trying to access products API - Falling back to listing all the products", requestEx);
                                    theProducts = Arrays.asList(ALL_PRODUCTS_ARR);
                                }
                            }
                            List<Object> products = theProducts;
                            List<Table> filteredTables = originalSchema.getTables().stream().filter(t -> {
                                String key = null == t.getProductId() ? t.getName() : t.getProductId();
                                return products.contains(key);
                            }).collect(Collectors.toList());
                            Optional<Table> allTable = schema.getTables().stream().filter(t -> {
                                String key = null == t.getProductId() ? t.getName() : t.getProductId();
                                return "all".equalsIgnoreCase(key);
                            }).findAny();
                            Optional<Table> originalAllTable = originalSchema.getTables().stream().filter(t -> {
                                String key = null == t.getProductId() ? t.getName() : t.getProductId();
                                return "all".equalsIgnoreCase(key);
                            }).findAny();
                            if (allTable.isPresent() && originalAllTable.isPresent()) {
                                List<Column> filteredColumns = ((Stream)originalAllTable.get().getColumns().stream().sequential()).filter(c -> schema.getResultColumns().contains(c.getName()) || products.stream().filter(p -> c.getName().startsWith((String)p)).count() == 1L).collect(Collectors.toList());
                                allTable.get().setColumns(filteredColumns);
                                if (!products.isEmpty()) {
                                    filteredTables.add(allTable.get());
                                }
                            }
                            schema.setTables(filteredTables);
                            if (hasChanged) continue;
                            hasChanged = originalSchema.getTables().size() != schema.getTables().size();
                            continue;
                        }
                        catalog.getSchemas().remove(schema);
                        catalog.getSchemas().add(schemaCounter, originalSchema);
                    }
                }
            }
            return hasChanged ? filteredTWCMD : TWCDriver.TWC_METADATA;
        }
        catch (Exception e) {
            throw new SQLException(TWCMessageUtil.getMessage("0030", "filter"), TWCSQLState.CONNECTION_ERROR.getState(), TWCSQLErrorCode.METADATA_FILTER_ERROR.getErrorCode(), e);
        }
    }
}

