/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.avro;

import com.ibm.cognos.jdbc.twc.csv.CSVSchema;
import com.ibm.cognos.jdbc.twc.csv.CSVSchemaField;
import com.ibm.cognos.jdbc.twc.org.apache.avro.Schema;
import com.ibm.cognos.jdbc.twc.org.apache.avro.SchemaBuilder;
import com.ibm.cognos.jdbc.twc.org.apache.avro.generic.GenericData;
import com.ibm.cognos.jdbc.twc.org.apache.avro.generic.GenericRecord;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Arrays;

public class AvroHelper {
    private static final String DATE_RECORD = "date";
    private static final String DATE_YEAR_FIELD = "year";
    private static final String DATE_MONTH_FIELD = "month";
    private static final String DATE_DAY_FIELD = "day";
    private static final Schema NULL_SCHEMA = Schema.create(Schema.Type.NULL);
    static final Schema DATE_SCHEMA = (Schema)SchemaBuilder.builder().record("date").fields().requiredInt("year").requiredInt("month").requiredInt("day").endRecord();

    private AvroHelper() {
    }

    public static Schema toAvroSchema(CSVSchema csvSchema) {
        SchemaBuilder.FieldAssembler<Schema> assembler = SchemaBuilder.record("row").fields();
        for (CSVSchemaField field : csvSchema.getFields()) {
            AvroHelper.assembleField(field, assembler);
        }
        return assembler.endRecord();
    }

    public static GenericRecord createDateRecord() {
        return new GenericData.Record(DATE_SCHEMA);
    }

    public static GenericRecord encodeDate(Date value) {
        GenericRecord record = AvroHelper.createDateRecord();
        LocalDate localDate = value.toLocalDate();
        record.put(DATE_YEAR_FIELD, (Object)localDate.getYear());
        record.put(DATE_MONTH_FIELD, (Object)localDate.getMonthValue());
        record.put(DATE_DAY_FIELD, (Object)localDate.getDayOfMonth());
        return record;
    }

    public static Date decodeDate(GenericRecord record) {
        int year = (Integer)record.get(DATE_YEAR_FIELD);
        int month = (Integer)record.get(DATE_MONTH_FIELD);
        int day = (Integer)record.get(DATE_DAY_FIELD);
        return Date.valueOf(LocalDate.of(year, month, day));
    }

    private static void assembleField(CSVSchemaField field, SchemaBuilder.FieldAssembler<Schema> assembler) {
        Schema type;
        SchemaBuilder.FieldBuilder<Schema> fieldBuilder = assembler.name(field.getName());
        switch (field.getDataType()) {
            case VARCHAR: {
                type = Schema.create(Schema.Type.STRING);
                break;
            }
            case INTEGER: {
                type = Schema.create(Schema.Type.INT);
                break;
            }
            case FLOAT: {
                type = Schema.create(Schema.Type.DOUBLE);
                break;
            }
            case DATE: {
                type = DATE_SCHEMA;
                break;
            }
            default: {
                type = NULL_SCHEMA;
            }
        }
        if (field.isNullable() && type != NULL_SCHEMA) {
            type = Schema.createUnion(Arrays.asList(type, NULL_SCHEMA));
        }
        fieldBuilder.type(type).noDefault();
    }
}

