/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.avro;

import com.ibm.cognos.jdbc.twc.avro.AvroHelper;
import com.ibm.cognos.jdbc.twc.csv.CSVSchema;
import com.ibm.cognos.jdbc.twc.csv.CSVSchemaField;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.apache.avro.Schema;
import com.ibm.cognos.jdbc.twc.org.apache.avro.file.DataFileStream;
import com.ibm.cognos.jdbc.twc.org.apache.avro.generic.GenericData;
import com.ibm.cognos.jdbc.twc.org.apache.avro.generic.GenericRecord;
import com.ibm.cognos.jdbc.twc.util.RowReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class AvroRowReader
implements RowReader {
    private final DataFileStream<GenericRecord> reader;
    private final List<CSVSchemaField> csvSchemaFields;
    private GenericRecord record;
    private boolean closed = false;

    public AvroRowReader(CSVSchema schema, InputStream in) throws IOException {
        if (null == schema) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0007", "schema"));
        }
        this.csvSchemaFields = schema.getFields();
        Schema avroSchema = AvroHelper.toAvroSchema(schema);
        this.reader = new DataFileStream(in, GenericData.get().createDatumReader(avroSchema));
        this.record = new GenericData.Record(avroSchema);
    }

    @Override
    public boolean hasMore() throws IOException {
        this.expectNotClosed();
        return this.reader.hasNext();
    }

    @Override
    public Object[] readArray(Object[] reuse) throws IOException {
        int numFields = this.csvSchemaFields.size();
        Object[] row = null != reuse && reuse.length >= numFields ? reuse : new Object[numFields];
        this.expectNotClosed();
        this.reader.next(this.record);
        int index = 0;
        for (CSVSchemaField field : this.csvSchemaFields) {
            Object recordValue = this.record.get(field.getName());
            if (recordValue == null) {
                row[index] = null;
            } else {
                switch (field.getDataType()) {
                    case FLOAT: 
                    case INTEGER: {
                        row[index] = recordValue;
                        break;
                    }
                    case DATE: {
                        row[index] = AvroHelper.decodeDate((GenericRecord)recordValue);
                        break;
                    }
                    default: {
                        row[index] = recordValue.toString();
                    }
                }
            }
            ++index;
        }
        return row;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.reader.close();
        }
    }

    private void expectNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(TWCMessageUtil.getMessage("0068"));
        }
    }
}

