/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.avro;

import com.ibm.cognos.jdbc.twc.TWCDriver;
import com.ibm.cognos.jdbc.twc.avro.AvroRowReader;
import com.ibm.cognos.jdbc.twc.csv.CSVSchema;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Scheme;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class AvroRowWalker
implements AutoCloseable,
Iterable<List<Object>> {
    private final List<String> filePaths;
    private final CSVSchema schema;
    private int currentFilePathIndex;
    private AvroRowReader currentReader;
    private final Object[] currentRow;

    public AvroRowWalker(List<String> filePaths, CSVSchema schema) throws IOException {
        this.filePaths = Objects.requireNonNull(filePaths, TWCMessageUtil.getMessage("0007", "filePaths"));
        this.schema = Objects.requireNonNull(schema, TWCMessageUtil.getMessage("0007", "schema"));
        this.currentRow = new Object[schema.getFieldsSize()];
        this.currentFilePathIndex = 0;
        this.setCurrentReader(this.currentFilePathIndex);
    }

    private boolean setCurrentReader(int index) throws IOException {
        if (index < this.filePaths.size()) {
            String currentFilePath = this.filePaths.get(index);
            if (currentFilePath.startsWith(Scheme.CLASSPATH.value())) {
                currentFilePath = currentFilePath.replaceAll(Scheme.CLASSPATH.value(), "");
                InputStream in = TWCDriver.class.getResourceAsStream(currentFilePath);
                if (this.currentReader != null) {
                    this.currentReader.close();
                }
                this.currentReader = new AvroRowReader(this.schema, in);
                this.currentFilePathIndex = index;
                return true;
            }
            File avroFile = new File(currentFilePath);
            if (avroFile.exists()) {
                if (this.currentReader != null) {
                    this.currentReader.close();
                }
                this.currentReader = new AvroRowReader(this.schema, new FileInputStream(avroFile));
                this.currentFilePathIndex = index;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<List<Object>> iterator() {
        return new AvroRowIterator();
    }

    @Override
    public void close() throws Exception {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
    }

    private class AvroRowIterator
    implements Iterator<List<Object>> {
        private AvroRowIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                if (AvroRowWalker.this.currentReader != null && AvroRowWalker.this.currentReader.hasMore()) {
                    return true;
                }
                return this.hasNextReader();
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public List<Object> next() {
            try {
                if (AvroRowWalker.this.currentReader != null && AvroRowWalker.this.currentReader.hasMore()) {
                    return Arrays.asList(AvroRowWalker.this.currentReader.readArray(AvroRowWalker.this.currentRow));
                }
                if (AvroRowWalker.this.setCurrentReader(AvroRowWalker.this.currentFilePathIndex + 1)) {
                    return Arrays.asList(AvroRowWalker.this.currentReader.readArray(AvroRowWalker.this.currentRow));
                }
                throw new NoSuchElementException();
            }
            catch (IOException e) {
                throw new NoSuchElementException();
            }
        }

        private boolean hasNextReader() throws IOException {
            String filePath;
            File avroFile;
            boolean hasNext = false;
            int index = AvroRowWalker.this.currentFilePathIndex + 1;
            if (index < AvroRowWalker.this.filePaths.size() && (avroFile = new File(filePath = (String)AvroRowWalker.this.filePaths.get(index))).exists()) {
                try (AvroRowReader reader = new AvroRowReader(AvroRowWalker.this.schema, new FileInputStream(avroFile));){
                    hasNext = reader.hasMore();
                }
            }
            return hasNext;
        }
    }
}

