/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.csv;

import com.ibm.cognos.jdbc.twc.avro.AvroRowWriter;
import com.ibm.cognos.jdbc.twc.csv.CSVSchema;
import com.ibm.cognos.jdbc.twc.csv.CSVSchemaField;
import com.ibm.cognos.jdbc.twc.csv.TWCObjectRowProcessor;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.metadata.generated.Table;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedTable;
import com.ibm.cognos.jdbc.twc.univocity.parsers.common.ParsingContext;
import com.ibm.cognos.jdbc.twc.univocity.parsers.common.processor.ObjectRowListProcessor;
import com.ibm.cognos.jdbc.twc.univocity.parsers.common.processor.core.AbstractObjectProcessor;
import com.ibm.cognos.jdbc.twc.univocity.parsers.csv.CsvParser;
import com.ibm.cognos.jdbc.twc.univocity.parsers.csv.CsvParserSettings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CSVParser {
    private final CsvParserSettings parserSettings;
    private final CsvParser parser;
    private final AbstractObjectProcessor<ParsingContext> processor;

    CSVParser() {
        this.processor = new ObjectRowListProcessor();
        this.parserSettings = new CsvParserSettings();
        this.parserSettings.setLineSeparatorDetectionEnabled(true);
        this.parserSettings.setHeaderExtractionEnabled(true);
        this.parserSettings.setProcessor(this.processor);
        this.parser = new CsvParser(this.parserSettings);
    }

    CSVParser(String[] selectFields) {
        CSVSchema schema = new CSVSchema();
        for (String fieldName : selectFields) {
            schema.addField(new CSVSchemaField(fieldName));
        }
        this.processor = new ObjectRowListProcessor();
        this.parserSettings = new CsvParserSettings();
        this.parserSettings.setLineSeparatorDetectionEnabled(true);
        this.parserSettings.setHeaderExtractionEnabled(true);
        this.parserSettings.setProcessor(this.processor);
        this.parserSettings.selectFields(selectFields);
        this.parserSettings.setColumnReorderingEnabled(true);
        this.parser = new CsvParser(this.parserSettings);
    }

    public CSVParser(CSVSchema csvSchema, Map<String, String> treatColumnAs, AvroRowWriter rowWriter, boolean strictMode) {
        this.processor = new TWCObjectRowProcessor(rowWriter, csvSchema, treatColumnAs, strictMode);
        this.parserSettings = new CsvParserSettings();
        this.parserSettings.setLineSeparatorDetectionEnabled(true);
        this.parserSettings.setHeaderExtractionEnabled(true);
        this.parserSettings.setProcessor(this.processor);
        this.parser = new CsvParser(this.parserSettings);
    }

    public void parse(InputStream input, String encoding) {
        this.parser.parse(input, encoding);
    }

    public List<Object[]> getRows() {
        if (this.processor instanceof ObjectRowListProcessor) {
            return ((ObjectRowListProcessor)this.processor).getRows();
        }
        return ((TWCObjectRowProcessor)this.processor).getRows();
    }

    public long getRowCount() {
        if (this.processor instanceof TWCObjectRowProcessor) {
            return ((TWCObjectRowProcessor)this.processor).getNumberOfProcessedLines();
        }
        return ((ObjectRowListProcessor)this.processor).getRows().size();
    }

    public static CSVSchema toCSVSchema(List<Column> columns) {
        ArrayList<CSVSchemaField> schemaFields = new ArrayList<CSVSchemaField>();
        for (Column column : columns) {
            schemaFields.add(new CSVSchemaField(column.getName(), column.getDatatype(), column.getNullable()));
        }
        return new CSVSchema(schemaFields);
    }

    public static CSVSchema toCSVSchema(List<String> commonColumns, Map<String, BoundedTable> boundedTables) {
        TreeMap<Integer, List<Column>> orderedTables = new TreeMap<Integer, List<Column>>();
        for (BoundedTable boundedTable : boundedTables.values()) {
            Table table = boundedTable.getTable();
            orderedTables.put(table.getOrdinal(), table.getColumns());
        }
        LinkedHashMap<String, CSVSchemaField> fieldToSchemaMap = new LinkedHashMap<String, CSVSchemaField>();
        for (String commonColumnName : commonColumns) {
            fieldToSchemaMap.put(commonColumnName, new CSVSchemaField(commonColumnName));
        }
        for (List columns : orderedTables.values()) {
            for (Column column : columns) {
                String columnName = column.getName();
                Column.Datatype columnDatatype = column.getDatatype();
                fieldToSchemaMap.put(columnName, new CSVSchemaField(columnName, columnDatatype, column.getNullable()));
            }
        }
        ArrayList<CSVSchemaField> arrayList = new ArrayList<CSVSchemaField>(fieldToSchemaMap.values());
        return new CSVSchema(arrayList);
    }

    public String[] getHeaders() {
        if (this.processor instanceof ObjectRowListProcessor) {
            return ((ObjectRowListProcessor)this.processor).getHeaders();
        }
        return ((TWCObjectRowProcessor)this.processor).getHeaders();
    }

    public String[] getSelectFields() {
        if (this.processor instanceof TWCObjectRowProcessor) {
            CSVSchema selectedFields = ((TWCObjectRowProcessor)this.processor).getCSVSchema();
            return (String[])selectedFields.getFields().stream().map(CSVSchemaField::getName).toArray(String[]::new);
        }
        return this.parser.getContext().selectedHeaders();
    }

    public CSVSchema getCSVSchema() {
        String[] selectedFields;
        if (this.processor instanceof TWCObjectRowProcessor) {
            return ((TWCObjectRowProcessor)this.processor).getCSVSchema();
        }
        CSVSchema newSchema = new CSVSchema();
        for (String selectedFieldName : selectedFields = this.parser.getContext().selectedHeaders()) {
            newSchema.addField(new CSVSchemaField(selectedFieldName));
        }
        return newSchema;
    }
}

