/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.csv;

import com.ibm.cognos.jdbc.twc.csv.CSVSchemaField;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CSVSchema {
    private final List<CSVSchemaField> fields;

    public CSVSchema() {
        this.fields = new ArrayList<CSVSchemaField>();
    }

    public CSVSchema(List<CSVSchemaField> fields) {
        this.fields = Objects.requireNonNull(fields, TWCMessageUtil.getMessage("0007", "fields"));
    }

    public int getFieldsSize() {
        return this.fields.size();
    }

    public void addField(CSVSchemaField field) {
        this.fields.add(Objects.requireNonNull(field, TWCMessageUtil.getMessage("0007", "field")));
    }

    public List<CSVSchemaField> getFields() {
        return this.fields;
    }

    public int[] boundedColumnsMapping(List<BoundedColumn> boundedColumns) {
        Objects.requireNonNull(boundedColumns, TWCMessageUtil.getMessage("0007", "boundedColumns"));
        int[] mapping = new int[boundedColumns.size()];
        Arrays.fill(mapping, -1);
        int boundedColumnIdx = 0;
        for (BoundedColumn boundedColumn : boundedColumns) {
            String columnName = boundedColumn.getColumn().getName();
            int i = 0;
            for (CSVSchemaField field : this.fields) {
                if (columnName.compareTo(field.getName()) == 0) {
                    mapping[boundedColumnIdx] = i;
                    break;
                }
                ++i;
            }
            ++boundedColumnIdx;
        }
        return mapping;
    }

    public Map<String, Integer> csvColumnNames2RowIdxs() {
        return IntStream.range(0, this.fields.size()).boxed().collect(Collectors.toMap(i -> this.fields.get((int)i).getName(), Function.identity()));
    }
}

