/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.csv;

import com.ibm.cognos.jdbc.twc.avro.AvroRowWriter;
import com.ibm.cognos.jdbc.twc.csv.CSVSchema;
import com.ibm.cognos.jdbc.twc.csv.CSVSchemaField;
import com.ibm.cognos.jdbc.twc.csv.conversions.TWCDateConversion;
import com.ibm.cognos.jdbc.twc.csv.conversions.TWCDoubleConversion;
import com.ibm.cognos.jdbc.twc.csv.conversions.TWCIntegerConversion;
import com.ibm.cognos.jdbc.twc.univocity.parsers.common.DataProcessingException;
import com.ibm.cognos.jdbc.twc.univocity.parsers.common.ParsingContext;
import com.ibm.cognos.jdbc.twc.univocity.parsers.common.processor.ObjectRowProcessor;
import com.ibm.cognos.jdbc.twc.univocity.parsers.conversions.Conversions;
import com.ibm.cognos.jdbc.twc.univocity.parsers.conversions.NullStringConversion;
import com.ibm.cognos.jdbc.twc.univocity.parsers.conversions.ToStringConversion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TWCObjectRowProcessor
extends ObjectRowProcessor {
    private static final NullStringConversion NULL_STRING_CONVERSION = Conversions.toNull("NaN", "N/A");
    private static final TWCDateConversion TWC_DATE_CONVERSION = new TWCDateConversion();
    private static final TWCDoubleConversion TWC_DOUBLE_CONVERSION = new TWCDoubleConversion();
    private static final TWCIntegerConversion TWC_INTEGER_CONVERSION = new TWCIntegerConversion();
    private static final ToStringConversion STRING_CONVERSION = Conversions.string();
    private final AvroRowWriter writer;
    private final CSVSchema schema;
    private final Map<String, String> treatAs;
    private final boolean strictMode;
    private long lines;
    private final Object[] intermediateRow;
    private boolean headersMappingOccured = false;
    private final int[] schema2headersIdxs;
    private final List<Object[]> rows;
    private String[] headers = new String[0];

    TWCObjectRowProcessor(AvroRowWriter theWriter, CSVSchema csvSchema, Map<String, String> treatColumnAs, boolean isStrictMode) {
        this.writer = theWriter;
        this.schema = csvSchema;
        this.treatAs = null != treatColumnAs ? treatColumnAs : Collections.emptyMap();
        this.strictMode = isStrictMode;
        this.intermediateRow = new Object[csvSchema.getFieldsSize()];
        this.schema2headersIdxs = new int[csvSchema.getFieldsSize()];
        Arrays.fill(this.schema2headersIdxs, -1);
        this.lines = 0L;
        this.rows = null == theWriter ? new ArrayList(100) : Collections.emptyList();
    }

    @Override
    public void processEnded(ParsingContext context) {
        super.processEnded(context);
        if (this.strictMode && 5 == context.parsedHeaders().length) {
            throw new IllegalStateException("The request is invalid.");
        }
    }

    @Override
    public void rowProcessed(Object[] row, ParsingContext context) {
        if (!this.headersMappingOccured) {
            int counter = 0;
            this.headers = context.parsedHeaders();
            List<String> responseHeaders = Arrays.asList(this.headers);
            for (CSVSchemaField schemaField : this.schema.getFields()) {
                String header = this.treatAs.get(schemaField.getName());
                if (null == header) {
                    header = schemaField.getName();
                }
                this.schema2headersIdxs[counter] = responseHeaders.indexOf(header);
                ++counter;
            }
            this.headersMappingOccured = true;
        }
        try {
            int schemaIdx = 0;
            for (CSVSchemaField schemaField : this.schema.getFields()) {
                int headerIdx = this.schema2headersIdxs[schemaIdx];
                if (-1 == headerIdx) {
                    this.intermediateRow[schemaIdx] = null;
                } else {
                    Object value = row[headerIdx];
                    value = NULL_STRING_CONVERSION.execute(value);
                    switch (schemaField.getDataType()) {
                        case DATE: {
                            this.intermediateRow[schemaIdx] = null != value ? TWC_DATE_CONVERSION.execute(value.toString()) : null;
                            break;
                        }
                        case FLOAT: {
                            this.intermediateRow[schemaIdx] = null != value ? TWC_DOUBLE_CONVERSION.execute(value.toString()) : null;
                            break;
                        }
                        case INTEGER: {
                            this.intermediateRow[schemaIdx] = null != value ? TWC_INTEGER_CONVERSION.execute(value.toString()) : null;
                            break;
                        }
                        default: {
                            this.intermediateRow[schemaIdx] = null != value ? STRING_CONVERSION.execute(value) : null;
                        }
                    }
                }
                ++schemaIdx;
            }
            if (null == this.writer) {
                this.rows.add(Arrays.copyOf(this.intermediateRow, this.intermediateRow.length));
            } else {
                this.writer.writeArray(this.intermediateRow);
            }
            ++this.lines;
        }
        catch (Exception e) {
            DataProcessingException exception = new DataProcessingException("Cannot process row [record=" + context.currentRecord() + ", row={value}]. Reasons: " + e.getMessage());
            exception.setValue(row);
            throw exception;
        }
    }

    long getNumberOfProcessedLines() {
        return this.lines;
    }

    String[] getHeaders() {
        return this.headers;
    }

    public List<Object[]> getRows() {
        return this.rows;
    }

    public CSVSchema getCSVSchema() {
        return this.schema;
    }
}

