/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.csv.conversions;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.univocity.parsers.common.DataProcessingException;
import com.ibm.cognos.jdbc.twc.univocity.parsers.conversions.FormattedConversion;
import com.ibm.cognos.jdbc.twc.univocity.parsers.conversions.ObjectConversion;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Locale;

public class TWCDateConversion
extends ObjectConversion<Date>
implements FormattedConversion<DateTimeFormatter>,
TWCMessageKeys {
    private final DateTimeFormatter[] formatters = new DateTimeFormatter[2];

    public TWCDateConversion() {
        this.formatters[0] = DateTimeFormatter.ISO_LOCAL_DATE;
        this.formatters[1] = DateTimeFormatter.BASIC_ISO_DATE;
    }

    public DateTimeFormatter[] getFormatterObjects() {
        return this.formatters;
    }

    @Override
    protected Date fromString(String input) {
        for (DateTimeFormatter formatter : this.formatters) {
            try {
                return Date.valueOf(LocalDate.parse(input, formatter));
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
            catch (NullPointerException npe) {
                return null;
            }
        }
        DataProcessingException exception = new DataProcessingException(TWCMessageUtil.getMessage("0026", input) + " " + Locale.getDefault() + "'. Expected: " + Arrays.toString(new String[]{DateTimeFormatter.ISO_LOCAL_DATE.toString(), DateTimeFormatter.BASIC_ISO_DATE.toString()}));
        exception.setValue(input);
        throw exception;
    }
}

