/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.org.apache.avro.reflect;

import com.ibm.cognos.jdbc.twc.org.apache.avro.AvroRuntimeException;
import com.ibm.cognos.jdbc.twc.org.apache.avro.io.Decoder;
import com.ibm.cognos.jdbc.twc.org.apache.avro.io.Encoder;
import com.ibm.cognos.jdbc.twc.org.apache.avro.reflect.AvroEncode;
import com.ibm.cognos.jdbc.twc.org.apache.avro.reflect.CustomEncoding;
import com.ibm.cognos.jdbc.twc.org.apache.avro.reflect.FieldAccess;
import com.ibm.cognos.jdbc.twc.org.apache.avro.reflect.FieldAccessor;
import com.ibm.cognos.jdbc.twc.org.apache.avro.reflect.Stringable;
import java.io.IOException;
import java.lang.reflect.Field;

class FieldAccessReflect
extends FieldAccess {
    FieldAccessReflect() {
    }

    @Override
    protected FieldAccessor getAccessor(Field field) {
        AvroEncode enc = field.getAnnotation(AvroEncode.class);
        if (enc != null) {
            try {
                return new ReflectionBasesAccessorCustomEncoded(field, enc.using().newInstance());
            }
            catch (Exception e) {
                throw new AvroRuntimeException("Could not instantiate custom Encoding");
            }
        }
        return new ReflectionBasedAccessor(field);
    }

    private final class ReflectionBasesAccessorCustomEncoded
    extends ReflectionBasedAccessor {
        private CustomEncoding<?> encoding;

        public ReflectionBasesAccessorCustomEncoded(Field f, CustomEncoding<?> encoding) {
            super(f);
            this.encoding = encoding;
        }

        @Override
        protected void read(Object object, Decoder in) throws IOException {
            try {
                this.field.set(object, this.encoding.read(in));
            }
            catch (IllegalAccessException e) {
                throw new AvroRuntimeException(e);
            }
        }

        @Override
        protected void write(Object object, Encoder out) throws IOException {
            try {
                this.encoding.write(this.field.get(object), out);
            }
            catch (IllegalAccessException e) {
                throw new AvroRuntimeException(e);
            }
        }

        @Override
        protected boolean isCustomEncoded() {
            return true;
        }

        @Override
        protected boolean supportsIO() {
            return true;
        }
    }

    private class ReflectionBasedAccessor
    extends FieldAccessor {
        protected final Field field;
        private boolean isStringable;
        private boolean isCustomEncoded;

        public ReflectionBasedAccessor(Field field) {
            this.field = field;
            this.field.setAccessible(true);
            this.isStringable = field.isAnnotationPresent(Stringable.class);
            this.isCustomEncoded = field.isAnnotationPresent(AvroEncode.class);
        }

        public String toString() {
            return this.field.getName();
        }

        @Override
        public Object get(Object object) throws IllegalAccessException {
            return this.field.get(object);
        }

        @Override
        public void set(Object object, Object value) throws IllegalAccessException, IOException {
            this.field.set(object, value);
        }

        @Override
        protected Field getField() {
            return this.field;
        }

        @Override
        protected boolean isStringable() {
            return this.isStringable;
        }

        @Override
        protected boolean isCustomEncoded() {
            return this.isCustomEncoded;
        }
    }
}

