/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractIdentifierEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import com.ibm.cognos.jdbc.twc.sqlparser.LiteralValue;
import java.util.Objects;
import java.util.Optional;

public class ColumnIdentifierEntity
extends AbstractIdentifierEntity
implements TWCMessageKeys {
    private final String schema;
    private final String table;
    private final String columnName;
    private final String columnAlias;
    private final Optional<LiteralValue> literal;

    protected ColumnIdentifierEntity(String schemaValue, String tableValue, String columnValue, String aliasValue, LiteralValue value, ParseTree ctx) {
        super(ctx);
        this.schema = Objects.requireNonNull(schemaValue, TWCMessageUtil.getMessage("0007", "schemaValue"));
        this.table = Objects.requireNonNull(tableValue, TWCMessageUtil.getMessage("0007", "tableValue"));
        this.columnName = Objects.requireNonNull(columnValue, TWCMessageUtil.getMessage("0007", "columnValue"));
        this.columnAlias = Objects.requireNonNull(aliasValue, TWCMessageUtil.getMessage("0007", "aliasValue"));
        if (columnValue.isEmpty()) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0008", "columnValue"));
        }
        this.literal = Optional.ofNullable(value);
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.columnName;
    }

    public String getAlias() {
        return this.columnAlias;
    }

    public LiteralValue getLiteral() {
        return this.literal.orElse(null);
    }

    public boolean isLiteral() {
        return this.literal.isPresent();
    }

    boolean isColumnStar() {
        return false;
    }

    @Override
    public boolean isEquivalent(Entity entity) {
        if (entity instanceof ColumnIdentifierEntity) {
            ColumnIdentifierEntity columnIdentifier = (ColumnIdentifierEntity)entity;
            boolean result = this.columnName.compareTo(columnIdentifier.getColumn()) == 0 && this.columnAlias.compareTo(columnIdentifier.getAlias()) == 0 && this.schema.compareTo(columnIdentifier.getSchema()) == 0 && this.table.compareTo(columnIdentifier.getTable()) == 0;
            boolean bl = result = result && this.literal.isPresent() == columnIdentifier.literal.isPresent();
            if (result && this.literal.isPresent()) {
                result = this.literal.filter(v -> v.isEquivalent(columnIdentifier.literal.get())).isPresent();
            }
            return result;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.schema.isEmpty()) {
            sb.append(DOUBLE_QUOTE_STR).append(this.schema).append(DOUBLE_QUOTE_STR).append(DOT_STR);
        }
        if (!this.table.isEmpty()) {
            sb.append(DOUBLE_QUOTE_STR).append(this.table).append(DOUBLE_QUOTE_STR).append(DOT_STR);
        }
        sb.append(DOUBLE_QUOTE_STR).append(this.columnName).append(DOUBLE_QUOTE_STR);
        if (!this.columnAlias.isEmpty()) {
            sb.append(" ").append(AS_STR).append(" ").append(DOUBLE_QUOTE_STR).append(this.columnAlias).append(DOUBLE_QUOTE_STR);
        }
        return sb.toString();
    }

    static class Builder {
        private String aSchema = "";
        private String aTable = "";
        private String aColumnName = "";
        private String aColumnAlias = "";
        private LiteralValue aLiteral;
        private ParseTree aCtx;

        Builder() {
        }

        Builder setSchema(String v) {
            this.aSchema = v;
            return this;
        }

        Builder setTable(String v) {
            this.aTable = v;
            return this;
        }

        Builder setColumnName(String v) {
            this.aColumnName = v;
            return this;
        }

        Builder setColumnAlias(String v) {
            this.aColumnAlias = v;
            return this;
        }

        Builder setLiteralValue(LiteralValue v) {
            this.aLiteral = v;
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        ColumnIdentifierEntity build() {
            return new ColumnIdentifierEntity(this.aSchema, this.aTable, this.aColumnName, this.aColumnAlias, this.aLiteral, this.aCtx);
        }
    }
}

