/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterConditionEvaluator;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterIdentifierValuesResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ComplexFilterExpression
extends AbstractFilterExpression
implements TWCMessageKeys {
    private final List<FilterExpression> filterExpressions;

    private ComplexFilterExpression(List<FilterExpression> filters, ParseTree ctx) {
        super(null, ctx);
        Objects.requireNonNull(filters, TWCMessageUtil.getMessage("0007", "filters"));
        ComplexFilterExpression.validateFilterExpressionsListNotEmpty(filters);
        ComplexFilterExpression.validateFilterExpressionsListNotContainingNulls(filters);
        ComplexFilterExpression.validateOddNumberOfFilterExpressions(filters);
        ComplexFilterExpression.validateLogicalFilterExpressions(filters);
        ArrayList<FilterExpression> tempList = new ArrayList<FilterExpression>(filters);
        this.filterExpressions = Collections.unmodifiableList(tempList);
    }

    private static void validateFilterExpressionsListNotEmpty(List<FilterExpression> filters) {
        if (filters.isEmpty()) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0008", "filters"));
        }
    }

    private static void validateFilterExpressionsListNotContainingNulls(List<FilterExpression> filters) {
        if (filters.contains(null)) {
            throw new IllegalArgumentException("'filters' list cannot contain null objects.");
        }
    }

    private static void validateOddNumberOfFilterExpressions(List<FilterExpression> filters) {
        if (filters.size() % 2 == 0) {
            throw new IllegalArgumentException("'filters' list must contain odd number of filter expressions.");
        }
    }

    private static void validateLogicalFilterExpressions(List<FilterExpression> filters) {
        Iterator<FilterExpression> it = filters.iterator();
        boolean isValid = true;
        int counter = 0;
        while (isValid && it.hasNext()) {
            FilterExpression current = it.next();
            isValid = counter % 2 == 1 ? FilterExpression.FilterExpressionType.CONJUNCTION.equals((Object)current.getFilterExpressionType()) || FilterExpression.FilterExpressionType.DISJUNCTION.equals((Object)current.getFilterExpressionType()) : !FilterExpression.FilterExpressionType.CONJUNCTION.equals((Object)current.getFilterExpressionType()) && !FilterExpression.FilterExpressionType.DISJUNCTION.equals((Object)current.getFilterExpressionType());
            ++counter;
        }
        if (!isValid) {
            throw new IllegalArgumentException("'filters' list must contain conjunction/disjunction expressions betweenunary/binary/negation/complex expressions.");
        }
    }

    List<FilterExpression> getFilterExpressions() {
        return this.filterExpressions;
    }

    @Override
    public FilterExpression.FilterExpressionType getFilterExpressionType() {
        return FilterExpression.FilterExpressionType.COMPLEX;
    }

    @Override
    public boolean isEquivalent(Entity entity) {
        if (entity instanceof ComplexFilterExpression) {
            List<FilterExpression> providedFilterExpressions = ((ComplexFilterExpression)entity).getFilterExpressions();
            if (this.filterExpressions.size() == providedFilterExpressions.size()) {
                int counter = 0;
                Iterator<FilterExpression> it = this.filterExpressions.iterator();
                Iterator<FilterExpression> providedIt = providedFilterExpressions.iterator();
                while (it.hasNext() && it.next().isEquivalent(providedIt.next())) {
                    ++counter;
                }
                return this.filterExpressions.size() == counter;
            }
        }
        return false;
    }

    @Override
    public FilterIdentifierValuesResolver accept(FilterIdentifierValuesResolver visitor) {
        Objects.requireNonNull(visitor, TWCMessageUtil.getMessage("0007", "visitor"));
        FilterIdentifierValuesResolver valuesResolver = new FilterIdentifierValuesResolver(visitor.getFilterIdentifier(), visitor.strictlyMatchFilterIdentifiers(), false, false);
        LinkedList<FilterIdentifierValuesResolver> potentialContradictions = new LinkedList<FilterIdentifierValuesResolver>();
        int counter = 0;
        int matchingExpressions = 0;
        int nonMatchingExpressions = 0;
        int contradictoryExpressions = 0;
        FilterExpression previous = null;
        Iterator<FilterExpression> it = this.filterExpressions.iterator();
        while (it.hasNext()) {
            ++counter;
            FilterExpression current = it.next();
            FilterIdentifierValuesResolver currentValuesResolver = current.accept(visitor);
            if (null == currentValuesResolver) {
                ++nonMatchingExpressions;
                previous = current;
                continue;
            }
            ++matchingExpressions;
            if (currentValuesResolver.isContradictory()) {
                ++contradictoryExpressions;
                potentialContradictions.add(currentValuesResolver);
                if (null != previous && FilterExpression.FilterExpressionType.CONJUNCTION.equals((Object)previous.getFilterExpressionType())) {
                    valuesResolver.clearAllIntervals();
                }
                while (it.hasNext()) {
                    ++counter;
                    ++contradictoryExpressions;
                    current = it.next();
                    if (!FilterExpression.FilterExpressionType.CONJUNCTION.equals((Object)current.getFilterExpressionType())) break;
                    ++counter;
                    ++contradictoryExpressions;
                    current = it.next();
                    currentValuesResolver = current.accept(visitor);
                    if (null == currentValuesResolver) continue;
                    ++matchingExpressions;
                    potentialContradictions.add(currentValuesResolver);
                }
                previous = current;
                continue;
            }
            if (1 == matchingExpressions) {
                valuesResolver.setIntervals(currentValuesResolver.getIntervals());
            } else if (FilterExpression.FilterExpressionType.CONJUNCTION.equals((Object)previous.getFilterExpressionType())) {
                valuesResolver.collapseIntervals(currentValuesResolver.getIntervals());
            } else {
                valuesResolver.mergeIntervals(currentValuesResolver.getIntervals());
            }
            previous = current;
        }
        if (counter == nonMatchingExpressions) {
            return null;
        }
        if (counter == contradictoryExpressions || (long)matchingExpressions == potentialContradictions.stream().filter(FilterIdentifierValuesResolver::isContradictory).count()) {
            valuesResolver.setRepresentingContradiction();
            valuesResolver.setContradictory(true);
        }
        return valuesResolver;
    }

    @Override
    public boolean accept(FilterConditionEvaluator evaluator) {
        return evaluator.visit(this);
    }

    public String toString() {
        return this.filterExpressions.stream().map(Object::toString).collect(Collectors.joining(" ", OPEN_PARENTHESIS_STR, CLOSE_PARENTHESIS_STR));
    }

    static class Builder {
        private List<FilterExpression> someFilterExpressions = new ArrayList<FilterExpression>();
        private ParseTree aCtx;

        Builder() {
        }

        Builder addFilterExpression(FilterExpression filterExpression) {
            this.someFilterExpressions.add(filterExpression);
            return this;
        }

        Builder cleanFilterExpressions() {
            this.someFilterExpressions.clear();
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        ComplexFilterExpression build() {
            return new ComplexFilterExpression(this.someFilterExpressions, this.aCtx);
        }
    }
}

