/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractIdentifierEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import java.util.Objects;

class FilterIdentifierEntity
extends AbstractIdentifierEntity
implements TWCMessageKeys {
    private final String schema;
    private final String table;
    private final String columnName;
    private Column.Datatype dataType;

    private FilterIdentifierEntity(String schemaValue, String tableValue, String columnValue, ParseTree ctx) {
        super(ctx);
        Objects.requireNonNull(schemaValue, TWCMessageUtil.getMessage("0007", "schemaValue"));
        Objects.requireNonNull(tableValue, TWCMessageUtil.getMessage("0007", "tableValue"));
        Objects.requireNonNull(columnValue, TWCMessageUtil.getMessage("0007", "columnValue"));
        if (columnValue.isEmpty()) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0008", "columnValue"));
        }
        this.schema = schemaValue;
        this.table = tableValue;
        this.columnName = columnValue;
    }

    String getSchema() {
        return this.schema;
    }

    String getTable() {
        return this.table;
    }

    String getColumn() {
        return this.columnName;
    }

    Column.Datatype getDataType() {
        return this.dataType;
    }

    void setDataType(Column.Datatype theDataType) {
        this.dataType = theDataType;
    }

    @Override
    public boolean isEquivalent(Entity entity) {
        if (entity instanceof FilterIdentifierEntity) {
            FilterIdentifierEntity filterIdentifier = (FilterIdentifierEntity)entity;
            return this.schema.compareTo(filterIdentifier.getSchema()) == 0 && this.table.compareTo(filterIdentifier.getTable()) == 0 && this.columnName.compareTo(filterIdentifier.getColumn()) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.schema.isEmpty()) {
            sb.append(DOUBLE_QUOTE_STR).append(this.schema).append(DOUBLE_QUOTE_STR).append(DOT_STR);
        }
        if (!this.table.isEmpty()) {
            sb.append(DOUBLE_QUOTE_STR).append(this.table).append(DOUBLE_QUOTE_STR).append(DOT_STR);
        }
        sb.append(DOUBLE_QUOTE_STR).append(this.columnName).append(DOUBLE_QUOTE_STR);
        return sb.toString();
    }

    static class Builder {
        private String aSchema = "";
        private String aTable = "";
        private String aColumnName = "";
        private ParseTree aCtx;

        Builder() {
        }

        Builder setSchema(String v) {
            this.aSchema = v;
            return this;
        }

        Builder setTable(String v) {
            this.aTable = v;
            return this;
        }

        Builder setColumnName(String v) {
            this.aColumnName = v;
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        FilterIdentifierEntity build() {
            return new FilterIdentifierEntity(this.aSchema, this.aTable, this.aColumnName, this.aCtx);
        }
    }
}

