/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import com.ibm.cognos.jdbc.twc.sqlparser.LiteralValue;

public class LongLiteralValue
extends AbstractLiteralValue {
    private final long value;

    private LongLiteralValue(String literal, ParseTree ctx) {
        super(literal, Column.Datatype.BIGINT, ctx);
        this.value = Long.parseLong(literal);
    }

    @Override
    public boolean isDataTypeCompatible(Column.Datatype providedDataType) {
        return super.isDataTypeCompatible(providedDataType) || Column.Datatype.INTEGER.equals((Object)providedDataType) || Column.Datatype.SMALLINT.equals((Object)providedDataType);
    }

    @Override
    public boolean isEquivalent(Entity literal) {
        if (literal instanceof LongLiteralValue) {
            return this.value == ((LongLiteralValue)literal).getLongValue();
        }
        return false;
    }

    @Override
    public int compareTo(LiteralValue o) {
        if (o instanceof LongLiteralValue) {
            LongLiteralValue literal = (LongLiteralValue)o;
            long v1 = this.getLongValue();
            long v2 = literal.getLongValue();
            return Long.compare(v1, v2);
        }
        throw new IllegalArgumentException("Provided argument is not of type 'LongLiteralValue'.");
    }

    long getLongValue() {
        return this.value;
    }

    static class Builder {
        private String aLiteralValue;
        private ParseTree aCtx;

        Builder() {
        }

        Builder setLiteralValue(String literal) {
            this.aLiteralValue = literal;
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        LongLiteralValue build() {
            return new LongLiteralValue(this.aLiteralValue, this.aCtx);
        }
    }
}

