/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.Token;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractErrorEntity;
import java.util.Objects;

class SyntaxErrorEntity
extends AbstractErrorEntity
implements TWCMessageKeys {
    SyntaxErrorEntity(String sql, Object theOffendingSymbol, int theLine, int theCharPositionInLine, String theMsg) {
        super(SyntaxErrorEntity.constructFormattedErrorMessage(sql, theOffendingSymbol, theLine, theCharPositionInLine, theMsg));
    }

    static String constructFormattedErrorMessage(String sql, Object offendingSymbol, int line, int charPositionAtLine, String msg) {
        int stopIdx;
        int startIdx;
        Objects.requireNonNull(sql, TWCMessageUtil.getMessage("0007", "sql"));
        Objects.requireNonNull(msg, TWCMessageUtil.getMessage("0007", "msg"));
        StringBuilder sb = new StringBuilder().append("line ").append(line).append(":").append(charPositionAtLine).append(" ").append(msg).append(System.lineSeparator());
        if (line <= 0) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0011", "line"));
        }
        String[] lines = sql.split("\\r?\\n");
        sb.append(lines[line - 1]).append(System.lineSeparator());
        for (int i = 0; i < charPositionAtLine; ++i) {
            sb.append(" ");
        }
        if (offendingSymbol instanceof Token) {
            Token offendingToken = (Token)offendingSymbol;
            startIdx = offendingToken.getStartIndex();
            stopIdx = offendingToken.getStopIndex();
        } else {
            startIdx = charPositionAtLine;
            stopIdx = charPositionAtLine;
        }
        if (startIdx >= 0 && stopIdx >= 0) {
            for (int i = startIdx; i <= stopIdx; ++i) {
                sb.append("^");
            }
        }
        sb.append(System.lineSeparator());
        return sb.toString();
    }
}

