/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.AbstractConnectionProperty;
import com.ibm.cognos.jdbc.twc.avro.shaded.com.google.common.collect.ImmutableList;
import com.ibm.cognos.jdbc.twc.avro.shaded.com.google.common.collect.ImmutableMap;
import com.ibm.cognos.jdbc.twc.avro.shaded.com.google.common.collect.ImmutableSet;
import com.ibm.cognos.jdbc.twc.metadata.generated.Catalog;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.metadata.generated.Schema;
import com.ibm.cognos.jdbc.twc.metadata.generated.Server;
import com.ibm.cognos.jdbc.twc.metadata.generated.Table;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.ANTLRErrorListener;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.Parser;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.ParserRuleContext;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.RecognitionException;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.Recognizer;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.atn.ATNConfigSet;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.dfa.DFA;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.TerminalNode;
import com.ibm.cognos.jdbc.twc.org.slf4j.Logger;
import com.ibm.cognos.jdbc.twc.org.slf4j.LoggerFactory;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.BinaryFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedColumn;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedFilterIdentifier;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedTable;
import com.ibm.cognos.jdbc.twc.sqlparser.ColumnIdentifierEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.ColumnStarIdentifierEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.ComplexFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.ConjunctionFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.DateLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.DisjunctionFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.DoubleLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.ErrorEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterConditionEvaluator;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterIdentifierEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterIdentifierValuesResolver;
import com.ibm.cognos.jdbc.twc.sqlparser.LiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.LongLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.NegationFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.NullLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.PlainErrorEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.SemanticErrorEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.StringLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.SyntaxErrorEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.TWCSQLParserEntitiesFactory;
import com.ibm.cognos.jdbc.twc.sqlparser.TableIdentifierEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.UnaryFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.ValuesInterval;
import com.ibm.cognos.jdbc.twc.sqlparser.generated.TWCSQLParser;
import com.ibm.cognos.jdbc.twc.sqlparser.generated.TWCSQLParserBaseListener;
import com.ibm.cognos.jdbc.twc.util.MetadataUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class TWCSQLParserListenerImpl
extends TWCSQLParserBaseListener
implements ANTLRErrorListener {
    static final Logger LOGGER = LoggerFactory.getLogger(TWCSQLParserListenerImpl.class);
    static final String LOG_SEMANTIC_ERROR = "QueryId: {} - Semantic error: {}";
    static final String LOG_PLAIN_ERROR = "QueryId: {} - Plain error: {}";
    static final String MULTI_CATALOG_JOIN_ERROR_FORMATTER = "Cannot join tables from multiple catalogs %s.";
    static final String MULTI_SCHEMA_JOIN_ERROR_FORMATTER = "Cannot join tables from multiple schemas %s.";
    static final String DUPLICATE_TABLE_IDENTIFIER_ERROR_FORMATTER = "Duplicate table identifier detected: %s - Use aliases.";
    static final String CATALOG_BIND_ERROR_FORMATTER = "Cannot bind %s [%s] - Unexpected catalog: '%s'.";
    static final String SCHEMA_BIND_ERROR_FORMATTER = "Cannot bind %s [%s] - Unexpected schema: '%s'.";
    static final String TABLE_BIND_ERROR_FORMATTER = "Cannot bind %s [%s] - Unexpected table: '%s'.";
    static final String COLUMN_BIND_ERROR_FORMATTER = "Cannot bind %s [%s] - Unexpected column: '%s'.";
    static final String INNER_JOIN_COMMON_IDENTIFIERS_ERROR_FORMATTER = "Cannot inner join [%s] to [%s] - Expected common column identifiers with matching metadata representations.";
    static final String INNER_JOIN_NON_KEY_IDENTIFIERS_NOT_ALLOWED_ERROR_FORMATTER = "Inner join expression identifier [%s] not part of composite key for table [%s].";
    static final String NOT_VALID_INTEGER_LITERAL_ERROR_FORMATTER = "Literal value '%s' is not a valid integer.";
    static final String NOT_VALID_DOUBLE_LITERAL_ERROR_FORMATTER = "Literal value '%s' is not a valid double.";
    static final String NOT_VALID_DATE_LITERAL_ERROR_FORMATTER = "Literal value '%s' is not a valid date.";
    static final String DATE_CALCULATION_INVALID_DATE_ARG_FORMATTER = "Calculation '%s' expects a valid date literal as a first argument - found: '%s";
    static final String DATE_CALCULATION_INVALID_OFFSET_ARG_FORMATTER = "Calculation '%s' expects an offset value that is castable to long - found: '%s";
    static final String DATE_CALCULATION_ERROR_FORMATTER = "Failed to resolve the new date value after applying '%s' calculation. - Reason: %s";
    static final String INCOMPATIBLE_LITERAL_DATATYPE_ERROR_FORMATTER = "Incompatible literal value '%s' of datatype '%s' for filter operand '%s' of datatype '%s'.";
    static final String INCOMPATIBLE_DATA_TYPES_BETWEEN_OPERANDS_ERROR_FORMATTER = "Incompatible datatypes between filter operands [left: '%s' - '%s', right: '%s' - '%s'] - No implicit casting supported.";
    static final String BETWEEN_OPERATOR_ERROR_FORMATTER = "Literal value '%s' is not equal or less than equal when compared to literal value '%s'.";
    static final String NO_POSTAL_KEY_VALUE_PROVIDED = "No values for global column 'postalKey' are provided.";
    static final String INVALID_POSTAL_KEY_VALUES_PROVIDED = "Value ranges '%s' for global column 'postalKey' are invalid.";
    static final String INVALID_UNITS_VALUES_FORMATTER = "Value ranges '%s' for 'units' global column are invalid - Expecting one of: ['%s','%s','%s']";
    static final String INVALID_UNITS_VALUE_FORMATTER = "Value '%s' for 'units' global column is invalid - Expecting one of: ['%s','%s','%s']";
    static final String INVALID_LANGUAGE_VALUES_FORMATTER = "Value ranges '%s' for 'language' global column are invalid - Expecting one of: ['%s']";
    static final String INVALID_LANGUAGE_VALUE_FORMATTER = "Value '%s' for 'language' global column is invalid - Expecting one of: ['%s']";
    static final String INVALID_DATE_VALUES_PROVIDED = "Value ranges '%s' for 'date' global column are invalid";
    private static final String SLASH_STR = "/";
    private static final String COMMA_STR = ",";
    private static final String AMPERSAND_STR = "&";
    private static final String QUESTIONMARK_STR = "?";
    private static final String UNDERSCORE_STR = "_";
    private static final String NULL_STR = "null";
    private static final String ANALYTICAL_STR = "analytical";
    private static final String TABLE_STR = "table";
    private static final String COLUMN_STR = "column";
    private static final String IDENTIFIER_STR = "identifier";
    private static final String ADDYEARS_STR = "ADDYEARS";
    private static final String ADDMONTHS_STR = "ADDMONTHS";
    private static final String ADDDAYS_STR = "ADDDAYS";
    private static final Map<String, String> TREAT_COLUMN_AS_MAP = ImmutableMap.of("postalKey", "geoTypeId");
    private static final List<String> IGNORED_FILTER_IDENTIFIERS = ImmutableList.of("UNITS", "LANGUAGE");
    private final List<ColumnIdentifierEntity> columns = new ArrayList<ColumnIdentifierEntity>();
    private final List<TableIdentifierEntity> tables = new ArrayList<TableIdentifierEntity>();
    private final List<ErrorEntity> errors = new LinkedList<ErrorEntity>();
    private final Map<ParseTree, String> identifiers2Values = new HashMap<ParseTree, String>();
    private final Map<ParseTree, FilterIdentifierEntity> filterIdentifiers2FilterEntities = new HashMap<ParseTree, FilterIdentifierEntity>();
    private final Map<ParseTree, LiteralValue> literals2Values = new HashMap<ParseTree, LiteralValue>();
    private final Map<ParseTree, FilterExpression> nodes2JoinExpressions = new HashMap<ParseTree, FilterExpression>();
    private final Map<ParseTree, FilterExpression> nodes2FilterExpressions = new HashMap<ParseTree, FilterExpression>();
    private FilterExpression rootFilterExpression;
    private final Map<String, BoundedTable> boundedTables = new LinkedHashMap<String, BoundedTable>();
    private final List<BoundedColumn> boundedColumns = new ArrayList<BoundedColumn>();
    private final Map<String, FilterIdentifierValuesResolver> valuesResolvers = new HashMap<String, FilterIdentifierValuesResolver>();
    private Map<String, Column> globalColumns = new HashMap<String, Column>();
    private final Map<String, BoundedColumn> columnsInScope = new HashMap<String, BoundedColumn>();
    private final String queryId;
    private final String sql;
    private final Server twcMd;
    private final boolean strictMode;
    private Catalog catalog;
    private Schema schema;
    private boolean projectAllColumns = false;
    private final String catalogDefault;
    private final String schemaDefault;
    private final String languageDefault;
    private final String unitsDefault;
    private final URI baseURI;
    private final LocalDate currentDate;
    private List<String> postalKeyValues = new LinkedList<String>();
    private List<LocalDate> dateValues = new LinkedList<LocalDate>();
    private String units;
    private String language;
    private List<String> uris = new LinkedList<String>();

    TWCSQLParserListenerImpl(String id, String sqlStatement, Server twcMetadata, String defaultCatalog, String defaultSchema, String defaultLanguage, String defaultUnits, URI absoluteBaseURI, boolean isStrictMode) {
        this.queryId = Objects.requireNonNull(id, "'id' is null.");
        this.sql = Objects.requireNonNull(sqlStatement, "'sqlStatement' is null.");
        this.twcMd = Objects.requireNonNull(twcMetadata, "'twcMetadata' is null.");
        this.catalogDefault = Objects.requireNonNull(defaultCatalog, "'defaultCatalog' is null.");
        this.schemaDefault = Objects.requireNonNull(defaultSchema, "'defaultSchema' is null.");
        this.languageDefault = Objects.requireNonNull(defaultLanguage, "'defaultLanguage' is null.");
        this.unitsDefault = Objects.requireNonNull(defaultUnits, "'defaultUnits' is null.");
        this.baseURI = Objects.requireNonNull(absoluteBaseURI, "'absoluteBaseURI' is null.");
        this.strictMode = isStrictMode;
        this.currentDate = LocalDate.now();
    }

    String getSQL() {
        return this.sql;
    }

    List<ErrorEntity> getErrors() {
        return this.errors;
    }

    Catalog getCatalog() {
        return this.catalog;
    }

    Schema getSchema() {
        return this.schema;
    }

    List<BoundedColumn> getBoundedColumns() {
        if (this.projectAllColumns) {
            LinkedList<BoundedColumn> allColumns = new LinkedList<BoundedColumn>();
            for (Map.Entry<String, BoundedTable> entry : this.boundedTables.entrySet()) {
                BoundedTable boundedTable = entry.getValue();
                allColumns.addAll(boundedTable.getTable().getColumns().stream().map(c -> {
                    ColumnIdentifierEntity.Builder builder = TWCSQLParserEntitiesFactory.columnIdentifierFactory();
                    builder.setSchema(this.schema.getName().value());
                    builder.setTable(boundedTable.getTable().getName());
                    builder.setColumnName(boundedTable.getTable().getName() + UNDERSCORE_STR + c.getName());
                    builder.setContext(boundedTable.getTableIdentifier().getContext());
                    return new BoundedColumn(builder.build(), (Column)c, boundedTable.getTable());
                }).collect(Collectors.toList()));
            }
            return allColumns;
        }
        return this.boundedColumns;
    }

    Object[] getProjectedLiterals() {
        LinkedList<Object> literals = new LinkedList<Object>();
        if (!this.projectAllColumns) {
            for (BoundedColumn bc : this.boundedColumns) {
                if (!bc.getColumnIdentifier().isLiteral()) continue;
                LiteralValue literal = bc.getColumnIdentifier().getLiteral();
                if (literal instanceof LongLiteralValue) {
                    literals.add(((LongLiteralValue)literal).getLongValue());
                    continue;
                }
                if (literal instanceof DoubleLiteralValue) {
                    literals.add(((DoubleLiteralValue)literal).getDoubleValue());
                    continue;
                }
                if (literal instanceof DateLiteralValue) {
                    literals.add(Date.valueOf(((DateLiteralValue)literal).getDateValue()));
                    continue;
                }
                literals.add(literal.getLiteralValue());
            }
        }
        return literals.toArray(new Object[0]);
    }

    int[] getProjectedLiteralsOrdinalPositions() {
        LinkedList<Integer> ordinalsOfLiterals = new LinkedList<Integer>();
        if (!this.projectAllColumns) {
            int ordinal = 0;
            for (BoundedColumn bc : this.boundedColumns) {
                if (bc.getColumnIdentifier().isLiteral()) {
                    ordinalsOfLiterals.add(ordinal);
                }
                ++ordinal;
            }
        }
        return ordinalsOfLiterals.stream().mapToInt(ordinalsOfLiteral -> ordinalsOfLiteral).toArray();
    }

    Map<String, BoundedTable> getBoundedTables() {
        return this.boundedTables;
    }

    List<String> getCommonColumns() {
        return this.schema.getResultColumns();
    }

    Map<String, String> getTreatColumnsAs() {
        if (Schema.Name.HISTORICAL.value().compareToIgnoreCase(this.schema.getName().value()) == 0) {
            return TREAT_COLUMN_AS_MAP;
        }
        return null;
    }

    List<String> getIgnoredFilterIdentifiers() {
        return IGNORED_FILTER_IDENTIFIERS;
    }

    List<String> getURIs() {
        return this.uris;
    }

    List<String> getPostalCodes() {
        return this.postalKeyValues;
    }

    List<LocalDate> getDateValues() {
        return this.dateValues;
    }

    boolean evaluateFilterExpression(FilterConditionEvaluator evaluator) {
        if (null == this.rootFilterExpression) {
            return true;
        }
        return this.rootFilterExpression.accept(evaluator);
    }

    @Override
    public void exitCte(TWCSQLParser.CteContext ctx) {
        this.rootFilterExpression = this.nodes2FilterExpressions.get(ctx.getChild(5));
        LOGGER.info("QueryId: {} - Root filter expression: {}", (Object)this.queryId, (Object)(this.rootFilterExpression == null ? null : this.rootFilterExpression.toString()));
        if (this.errors.isEmpty()) {
            LOGGER.info("QueryId: {} - No syntax errors detected. Perform validation for tables.", (Object)this.queryId);
            this.validateTables((TWCSQLParser.Tables_expressionContext)ctx.getChild(3));
        }
        if (this.errors.isEmpty()) {
            LOGGER.info("QueryId: {} - No semantic errors detected for tables. Perform validation for columns.", (Object)this.queryId);
            this.validateColumns();
        }
        if (this.errors.isEmpty()) {
            LOGGER.info("QueryId: {} - No semantic errors detected for columns. Perform validation for join identifiers.", (Object)this.queryId);
            this.validateJoinIdentifiers();
        }
        if (this.errors.isEmpty()) {
            LOGGER.info("QueryId: {} - No semantic errors detected for join identifiers. Perform validation for filter identifiers.", (Object)this.queryId);
            this.validateFilterIdentifiers();
        }
        if (this.errors.isEmpty() && (Schema.Name.HISTORICAL == this.schema.getName() || Schema.Name.FORECAST == this.schema.getName())) {
            LOGGER.info("QueryId: {} - No semantic errors detected for filter identifiers. Extract value ranges for global columns.", (Object)this.queryId);
            this.generateValueRanges(ctx);
        }
        if (this.errors.isEmpty()) {
            LOGGER.info("QueryId: {} - No errors detected for value ranges. Construct URIs.", (Object)this.queryId);
            this.constructURIs();
            LOGGER.info("QueryId: {} - URIs: {}", (Object)this.queryId, (Object)this.uris);
        }
    }

    @Override
    public void exitFilters_expression(TWCSQLParser.Filters_expressionContext ctx) {
        int idx = 0;
        FilterExpression filterExpression = this.nodes2FilterExpressions.get(ctx.getChild(idx));
        if (null == filterExpression) {
            return;
        }
        ComplexFilterExpression.Builder filterExpressionBuilder = TWCSQLParserEntitiesFactory.complexFilterExpressionFactory();
        filterExpressionBuilder.addFilterExpression(filterExpression);
        ++idx;
        while (null != ctx.getChild(idx) && ctx.getChild(idx).getChild(0) instanceof TerminalNode) {
            if (FilterExpression.LogicalOperator.AND.getType() == ((TerminalNode)ctx.getChild(idx).getChild(0)).getSymbol().getType()) {
                ConjunctionFilterExpression.Builder conjunctionFilterExpression = TWCSQLParserEntitiesFactory.conjunctionFilterExpressionFactory();
                conjunctionFilterExpression.setContext(ctx.getChild(idx));
                filterExpressionBuilder.addFilterExpression(conjunctionFilterExpression.build());
            } else {
                DisjunctionFilterExpression.Builder disjunctionFilterExpression = TWCSQLParserEntitiesFactory.disjunctionFilterExpressionFactory();
                disjunctionFilterExpression.setContext(ctx.getChild(idx));
                filterExpressionBuilder.addFilterExpression(disjunctionFilterExpression.build());
            }
            filterExpression = this.nodes2FilterExpressions.get(ctx.getChild(++idx));
            if (null == filterExpression) {
                return;
            }
            filterExpressionBuilder.addFilterExpression(filterExpression);
            ++idx;
        }
        filterExpressionBuilder.setContext(ctx);
        this.nodes2FilterExpressions.put(ctx, filterExpressionBuilder.build());
    }

    @Override
    public void exitFilterExpression(TWCSQLParser.FilterExpressionContext ctx) {
        FilterExpression filterExpression = this.nodes2FilterExpressions.get(ctx.getChild(0));
        if (null != filterExpression) {
            this.nodes2FilterExpressions.put(ctx, filterExpression);
        }
    }

    @Override
    public void exitNegatedFilterExpression(TWCSQLParser.NegatedFilterExpressionContext ctx) {
        FilterExpression filterExpression = this.nodes2FilterExpressions.get(ctx.getChild(1));
        if (null != filterExpression) {
            NegationFilterExpression.Builder negationFilterExpressionBuilder = TWCSQLParserEntitiesFactory.negationFilterExpressionFactory();
            negationFilterExpressionBuilder.setFilterExpression(filterExpression);
            negationFilterExpressionBuilder.setContext(ctx);
            this.nodes2FilterExpressions.put(ctx, negationFilterExpressionBuilder.build());
        }
    }

    @Override
    public void exitNestedFilterExpression(TWCSQLParser.NestedFilterExpressionContext ctx) {
        FilterExpression filterExpression = this.nodes2FilterExpressions.get(ctx.getChild(1));
        if (null != filterExpression) {
            ComplexFilterExpression.Builder complexFilterExpressionBuilder = TWCSQLParserEntitiesFactory.complexFilterExpressionFactory();
            complexFilterExpressionBuilder.addFilterExpression(filterExpression);
            complexFilterExpressionBuilder.setContext(ctx);
            this.nodes2FilterExpressions.put(ctx, complexFilterExpressionBuilder.build());
        }
    }

    @Override
    public void exitFilterBetweenExpression(TWCSQLParser.FilterBetweenExpressionContext ctx) {
        FilterIdentifierEntity filterOperand = this.filterIdentifiers2FilterEntities.get(ctx.getChild(0));
        LiteralValue literalValue1 = this.literals2Values.get(ctx.getChild(2));
        LiteralValue literalValue2 = this.literals2Values.get(ctx.getChild(4));
        if (null == filterOperand || null == literalValue1 || null == literalValue2) {
            return;
        }
        try {
            if (literalValue1.compareTo(literalValue2) <= 0) {
                UnaryFilterExpression.Builder filterExpressionBuilder = TWCSQLParserEntitiesFactory.unaryFilterExpressionFactory();
                filterExpressionBuilder.setFilterOperand(filterOperand);
                filterExpressionBuilder.addValue(literalValue1);
                filterExpressionBuilder.addValue(literalValue2);
                filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.BETWEEN);
                filterExpressionBuilder.setContext(ctx);
                this.nodes2FilterExpressions.put(ctx, filterExpressionBuilder.build());
            }
        }
        catch (Exception e) {
            String msg = String.format(BETWEEN_OPERATOR_ERROR_FORMATTER, literalValue1, literalValue2);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
    }

    @Override
    public void exitFilterInExpression(TWCSQLParser.FilterInExpressionContext ctx) {
        FilterIdentifierEntity filterOperand = this.filterIdentifiers2FilterEntities.get(ctx.getChild(0));
        LiteralValue literalValue = this.literals2Values.get(ctx.getChild(3));
        if (null == filterOperand || null == literalValue) {
            return;
        }
        UnaryFilterExpression.Builder filterExpressionBuilder = TWCSQLParserEntitiesFactory.unaryFilterExpressionFactory();
        filterExpressionBuilder.setFilterOperand(filterOperand);
        filterExpressionBuilder.addValue(literalValue);
        int idx = 4;
        ParseTree currentChild = ctx.getChild(idx);
        while (null != currentChild && AbstractFilterExpression.CLOSE_PARENTHESIS_STR.compareTo(currentChild.getText()) != 0) {
            if (null == (literalValue = this.literals2Values.get(ctx.getChild(++idx)))) {
                return;
            }
            filterExpressionBuilder.addValue(literalValue);
            currentChild = ctx.getChild(++idx);
        }
        filterExpressionBuilder.setContext(ctx);
        filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.IN);
        this.nodes2FilterExpressions.put(ctx, filterExpressionBuilder.build());
    }

    @Override
    public void exitFilterPredicateUnaryComparisonExpression(TWCSQLParser.FilterPredicateUnaryComparisonExpressionContext ctx) {
        FilterIdentifierEntity filterOperand = this.filterIdentifiers2FilterEntities.get(ctx.getChild(0));
        LiteralValue literalValue = this.literals2Values.get(ctx.getChild(2));
        if (null == filterOperand || null == literalValue || null == ctx.getChild(1)) {
            return;
        }
        if (!(ctx.getChild(1).getChild(0) instanceof TerminalNode)) {
            return;
        }
        UnaryFilterExpression.Builder filterExpressionBuilder = TWCSQLParserEntitiesFactory.unaryFilterExpressionFactory();
        filterExpressionBuilder.setFilterOperand(filterOperand);
        filterExpressionBuilder.addValue(literalValue);
        int operatorType = ((TerminalNode)ctx.getChild(1).getChild(0)).getSymbol().getType();
        if (FilterExpression.ComparisonOperator.EQUAL.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.EQUAL);
        } else if (FilterExpression.ComparisonOperator.NE.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.NE);
        } else if (FilterExpression.ComparisonOperator.GT.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.GT);
        } else if (FilterExpression.ComparisonOperator.GTE.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.GTE);
        } else if (FilterExpression.ComparisonOperator.LT.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.LT);
        } else if (FilterExpression.ComparisonOperator.LTE.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.LTE);
        } else {
            return;
        }
        filterExpressionBuilder.setContext(ctx);
        this.nodes2FilterExpressions.put(ctx, filterExpressionBuilder.build());
    }

    @Override
    public void exitPredicateFilterUnaryComparisonExpression(TWCSQLParser.PredicateFilterUnaryComparisonExpressionContext ctx) {
        FilterIdentifierEntity filterOperand = this.filterIdentifiers2FilterEntities.get(ctx.getChild(2));
        LiteralValue literalValue = this.literals2Values.get(ctx.getChild(0));
        if (null == filterOperand || null == literalValue || null == ctx.getChild(1)) {
            return;
        }
        if (!(ctx.getChild(1).getChild(0) instanceof TerminalNode)) {
            return;
        }
        UnaryFilterExpression.Builder filterExpressionBuilder = TWCSQLParserEntitiesFactory.unaryFilterExpressionFactory();
        filterExpressionBuilder.setFilterOperand(filterOperand);
        filterExpressionBuilder.addValue(literalValue);
        int operatorType = ((TerminalNode)ctx.getChild(1).getChild(0)).getSymbol().getType();
        if (FilterExpression.ComparisonOperator.EQUAL.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.EQUAL);
        } else if (FilterExpression.ComparisonOperator.NE.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.NE);
        } else if (FilterExpression.ComparisonOperator.GT.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.GT);
        } else if (FilterExpression.ComparisonOperator.GTE.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.GTE);
        } else if (FilterExpression.ComparisonOperator.LT.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.LT);
        } else if (FilterExpression.ComparisonOperator.LTE.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.LTE);
        } else {
            return;
        }
        filterExpressionBuilder.setContext(ctx);
        this.nodes2FilterExpressions.put(ctx, filterExpressionBuilder.build());
    }

    @Override
    public void exitFilterIsNullExpression(TWCSQLParser.FilterIsNullExpressionContext ctx) {
        FilterIdentifierEntity filterOperand = this.filterIdentifiers2FilterEntities.get(ctx.getChild(0));
        if (null == filterOperand) {
            return;
        }
        NullLiteralValue.Builder literalValueBuilder = TWCSQLParserEntitiesFactory.nullLiteralFactory();
        literalValueBuilder.setContext(ctx.NULL());
        UnaryFilterExpression.Builder filterExpressionBuilder = TWCSQLParserEntitiesFactory.unaryFilterExpressionFactory();
        filterExpressionBuilder.setFilterOperand(filterOperand);
        filterExpressionBuilder.addValue(literalValueBuilder.build());
        filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.EQUAL);
        filterExpressionBuilder.setContext(ctx);
        this.nodes2FilterExpressions.put(ctx, filterExpressionBuilder.build());
    }

    @Override
    public void exitFilterIsNotNullExpression(TWCSQLParser.FilterIsNotNullExpressionContext ctx) {
        FilterIdentifierEntity filterOperand = this.filterIdentifiers2FilterEntities.get(ctx.getChild(0));
        if (null == filterOperand) {
            return;
        }
        NullLiteralValue.Builder literalValueBuilder = TWCSQLParserEntitiesFactory.nullLiteralFactory();
        literalValueBuilder.setContext(ctx.NULL());
        UnaryFilterExpression.Builder filterExpressionBuilder = TWCSQLParserEntitiesFactory.unaryFilterExpressionFactory();
        filterExpressionBuilder.setFilterOperand(filterOperand);
        filterExpressionBuilder.addValue(literalValueBuilder.build());
        filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.NE);
        filterExpressionBuilder.setContext(ctx);
        this.nodes2FilterExpressions.put(ctx, filterExpressionBuilder.build());
    }

    @Override
    public void exitFilterBinaryExpression(TWCSQLParser.FilterBinaryExpressionContext ctx) {
        FilterIdentifierEntity leftOperand = this.filterIdentifiers2FilterEntities.get(ctx.getChild(0));
        FilterIdentifierEntity rightOperand = this.filterIdentifiers2FilterEntities.get(ctx.getChild(2));
        if (null == leftOperand || null == rightOperand || null == ctx.getChild(1)) {
            return;
        }
        if (!(ctx.getChild(1).getChild(0) instanceof TerminalNode)) {
            return;
        }
        BinaryFilterExpression.Builder filterExpressionBuilder = TWCSQLParserEntitiesFactory.binaryFilterExpressionFactory();
        filterExpressionBuilder.setLeftOperand(leftOperand);
        filterExpressionBuilder.setRightOperand(rightOperand);
        int operatorType = ((TerminalNode)ctx.getChild(1).getChild(0)).getSymbol().getType();
        if (FilterExpression.ComparisonOperator.EQUAL.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.EQUAL);
        } else if (FilterExpression.ComparisonOperator.NE.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.NE);
        } else if (FilterExpression.ComparisonOperator.GT.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.GT);
        } else if (FilterExpression.ComparisonOperator.GTE.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.GTE);
        } else if (FilterExpression.ComparisonOperator.LT.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.LT);
        } else if (FilterExpression.ComparisonOperator.LTE.getType() == operatorType) {
            filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.LTE);
        } else {
            return;
        }
        filterExpressionBuilder.setContext(ctx);
        this.nodes2FilterExpressions.put(ctx, filterExpressionBuilder.build());
    }

    @Override
    public void exitInner_join_filter_condition(TWCSQLParser.Inner_join_filter_conditionContext ctx) {
        FilterIdentifierEntity leftOperand = this.filterIdentifiers2FilterEntities.get(ctx.getChild(0));
        FilterIdentifierEntity rightOperand = this.filterIdentifiers2FilterEntities.get(ctx.getChild(2));
        if (null == leftOperand || null == rightOperand) {
            return;
        }
        BinaryFilterExpression.Builder filterExpressionBuilder = TWCSQLParserEntitiesFactory.binaryFilterExpressionFactory();
        filterExpressionBuilder.setLeftOperand(leftOperand);
        filterExpressionBuilder.setRightOperand(rightOperand);
        filterExpressionBuilder.setFilterOperator(FilterExpression.ComparisonOperator.EQUAL);
        filterExpressionBuilder.setContext(ctx);
        this.nodes2JoinExpressions.put(ctx, filterExpressionBuilder.build());
    }

    @Override
    public void exitLiteralPredicate(TWCSQLParser.LiteralPredicateContext ctx) {
        this.literals2Values.put(ctx, this.literals2Values.get(ctx.getChild(0)));
    }

    @Override
    public void exitAddYearsPredicate(TWCSQLParser.AddYearsPredicateContext ctx) {
        if (null == ctx.getChild(2) || null == ctx.getChild(4)) {
            return;
        }
        if (NULL_STR.compareToIgnoreCase(ctx.getChild(2).getText()) == 0) {
            NullLiteralValue.Builder builder = TWCSQLParserEntitiesFactory.nullLiteralFactory();
            builder.setContext(ctx.getChild(2));
            this.literals2Values.put(ctx, builder.build());
            return;
        }
        LiteralValue dateLiteral = this.literals2Values.get(ctx.getChild(2));
        String literal = ctx.getChild(4).getText();
        if (null == dateLiteral) {
            return;
        }
        if (dateLiteral.isNullLiteralValue()) {
            this.literals2Values.put(ctx, dateLiteral);
            return;
        }
        if (!(dateLiteral instanceof DateLiteralValue)) {
            String msg = String.format(DATE_CALCULATION_INVALID_DATE_ARG_FORMATTER, ADDYEARS_STR, ctx.getChild(2).getText());
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
            return;
        }
        if (NULL_STR.compareToIgnoreCase(literal) == 0) {
            NullLiteralValue.Builder builder = TWCSQLParserEntitiesFactory.nullLiteralFactory();
            builder.setContext(ctx.getChild(4));
            this.literals2Values.put(ctx, builder.build());
            return;
        }
        LocalDate dateValue = ((DateLiteralValue)dateLiteral).getDateValue();
        String resolvedDateLiteral = null;
        try {
            BigDecimal offsetYearsDec = new BigDecimal(literal);
            long offsetYears = offsetYearsDec.longValue();
            if ((long)offsetYearsDec.signum() * offsetYears < 0L) {
                throw new ArithmeticException();
            }
            LocalDate resolvedDate = dateValue.plusYears(offsetYears);
            resolvedDateLiteral = resolvedDate.toString();
            DateLiteralValue.Builder dateLiteralValueBuilder = TWCSQLParserEntitiesFactory.dateLiteralFactory();
            dateLiteralValueBuilder.setLiteralValue(resolvedDateLiteral);
            dateLiteralValueBuilder.setContext(ctx);
            this.literals2Values.put(ctx, dateLiteralValueBuilder.build());
        }
        catch (ArithmeticException ae) {
            String msg = String.format(DATE_CALCULATION_INVALID_OFFSET_ARG_FORMATTER, ADDYEARS_STR, literal);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
        catch (DateTimeParseException dtpe) {
            String msg = String.format(NOT_VALID_DATE_LITERAL_ERROR_FORMATTER, resolvedDateLiteral);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
        catch (DateTimeException dte) {
            String msg = String.format(DATE_CALCULATION_ERROR_FORMATTER, ADDYEARS_STR, dte.getMessage());
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
    }

    @Override
    public void exitAddMonthsPredicate(TWCSQLParser.AddMonthsPredicateContext ctx) {
        if (null == ctx.getChild(2) || null == ctx.getChild(4)) {
            return;
        }
        if (NULL_STR.compareToIgnoreCase(ctx.getChild(2).getText()) == 0) {
            NullLiteralValue.Builder builder = TWCSQLParserEntitiesFactory.nullLiteralFactory();
            builder.setContext(ctx.getChild(2));
            this.literals2Values.put(ctx, builder.build());
            return;
        }
        LiteralValue dateLiteral = this.literals2Values.get(ctx.getChild(2));
        String literal = ctx.getChild(4).getText();
        if (null == dateLiteral) {
            return;
        }
        if (dateLiteral.isNullLiteralValue()) {
            this.literals2Values.put(ctx, dateLiteral);
            return;
        }
        if (!(dateLiteral instanceof DateLiteralValue)) {
            String msg = String.format(DATE_CALCULATION_INVALID_DATE_ARG_FORMATTER, ADDMONTHS_STR, ctx.getChild(2).getText());
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
            return;
        }
        if (NULL_STR.compareToIgnoreCase(literal) == 0) {
            NullLiteralValue.Builder builder = TWCSQLParserEntitiesFactory.nullLiteralFactory();
            builder.setContext(ctx.getChild(4));
            this.literals2Values.put(ctx, builder.build());
            return;
        }
        LocalDate dateValue = ((DateLiteralValue)dateLiteral).getDateValue();
        String resolvedDateLiteral = null;
        try {
            BigDecimal offsetMonthsDec = new BigDecimal(literal);
            long offsetMonths = offsetMonthsDec.longValue();
            if ((long)offsetMonthsDec.signum() * offsetMonths < 0L) {
                throw new ArithmeticException();
            }
            LocalDate resolvedDate = dateValue.plusMonths(offsetMonths);
            resolvedDateLiteral = resolvedDate.toString();
            DateLiteralValue.Builder dateLiteralValueBuilder = TWCSQLParserEntitiesFactory.dateLiteralFactory();
            dateLiteralValueBuilder.setLiteralValue(resolvedDateLiteral);
            dateLiteralValueBuilder.setContext(ctx);
            this.literals2Values.put(ctx, dateLiteralValueBuilder.build());
        }
        catch (ArithmeticException ae) {
            String msg = String.format(DATE_CALCULATION_INVALID_OFFSET_ARG_FORMATTER, ADDMONTHS_STR, literal);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
        catch (DateTimeParseException dtpe) {
            String msg = String.format(NOT_VALID_DATE_LITERAL_ERROR_FORMATTER, resolvedDateLiteral);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
        catch (DateTimeException dte) {
            String msg = String.format(DATE_CALCULATION_ERROR_FORMATTER, ADDMONTHS_STR, dte.getMessage());
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
    }

    @Override
    public void exitAddDaysPredicate(TWCSQLParser.AddDaysPredicateContext ctx) {
        if (null == ctx.getChild(2) || null == ctx.getChild(4)) {
            return;
        }
        if (NULL_STR.compareToIgnoreCase(ctx.getChild(2).getText()) == 0) {
            NullLiteralValue.Builder builder = TWCSQLParserEntitiesFactory.nullLiteralFactory();
            builder.setContext(ctx.getChild(2));
            this.literals2Values.put(ctx, builder.build());
            return;
        }
        LiteralValue dateLiteral = this.literals2Values.get(ctx.getChild(2));
        String literal = ctx.getChild(4).getText();
        if (null == dateLiteral) {
            return;
        }
        if (dateLiteral.isNullLiteralValue()) {
            this.literals2Values.put(ctx, dateLiteral);
            return;
        }
        if (!(dateLiteral instanceof DateLiteralValue)) {
            String msg = String.format(DATE_CALCULATION_INVALID_DATE_ARG_FORMATTER, ADDDAYS_STR, ctx.getChild(2).getText());
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
            return;
        }
        if (NULL_STR.compareToIgnoreCase(literal) == 0) {
            NullLiteralValue.Builder builder = TWCSQLParserEntitiesFactory.nullLiteralFactory();
            builder.setContext(ctx.getChild(4));
            this.literals2Values.put(ctx, builder.build());
            return;
        }
        LocalDate dateValue = ((DateLiteralValue)dateLiteral).getDateValue();
        String resolvedDateLiteral = null;
        try {
            BigDecimal offsetDaysDec = new BigDecimal(literal);
            long offsetDays = offsetDaysDec.longValue();
            if ((long)offsetDaysDec.signum() * offsetDays < 0L) {
                throw new ArithmeticException();
            }
            LocalDate resolvedDate = dateValue.plusDays(offsetDays);
            resolvedDateLiteral = resolvedDate.toString();
            DateLiteralValue.Builder dateLiteralValueBuilder = TWCSQLParserEntitiesFactory.dateLiteralFactory();
            dateLiteralValueBuilder.setLiteralValue(resolvedDateLiteral);
            dateLiteralValueBuilder.setContext(ctx);
            this.literals2Values.put(ctx, dateLiteralValueBuilder.build());
        }
        catch (ArithmeticException ae) {
            String msg = String.format(DATE_CALCULATION_INVALID_OFFSET_ARG_FORMATTER, ADDDAYS_STR, literal);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
        catch (DateTimeParseException dtpe) {
            String msg = String.format(NOT_VALID_DATE_LITERAL_ERROR_FORMATTER, resolvedDateLiteral);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
        catch (DateTimeException dte) {
            String msg = String.format(DATE_CALCULATION_ERROR_FORMATTER, ADDDAYS_STR, dte.getMessage());
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
    }

    @Override
    public void exitSchemaTableFilterIdentifier(TWCSQLParser.SchemaTableFilterIdentifierContext ctx) {
        if (null == ctx.getChild(0) || null == ctx.getChild(2) || null == ctx.getChild(4)) {
            return;
        }
        String theSchema = this.identifiers2Values.get(ctx.getChild(0).getChild(0));
        String table = this.identifiers2Values.get(ctx.getChild(2).getChild(0));
        String column = this.identifiers2Values.get(ctx.getChild(4));
        if (null == theSchema || null == table || null == column) {
            return;
        }
        FilterIdentifierEntity.Builder filterBuilder = TWCSQLParserEntitiesFactory.filterIdentifierFactory();
        filterBuilder.setSchema(theSchema);
        filterBuilder.setTable(table);
        filterBuilder.setColumnName(column);
        filterBuilder.setContext(ctx);
        this.filterIdentifiers2FilterEntities.put(ctx, filterBuilder.build());
    }

    @Override
    public void exitTableFilterIdentifier(TWCSQLParser.TableFilterIdentifierContext ctx) {
        if (null == ctx.getChild(0) || null == ctx.getChild(2)) {
            return;
        }
        String table = this.identifiers2Values.get(ctx.getChild(0).getChild(0));
        String column = this.identifiers2Values.get(ctx.getChild(2));
        if (null == table || null == column) {
            return;
        }
        FilterIdentifierEntity.Builder filterBuilder = TWCSQLParserEntitiesFactory.filterIdentifierFactory();
        filterBuilder.setTable(table);
        filterBuilder.setColumnName(column);
        filterBuilder.setContext(ctx);
        this.filterIdentifiers2FilterEntities.put(ctx, filterBuilder.build());
    }

    @Override
    public void exitFilterIdentifier(TWCSQLParser.FilterIdentifierContext ctx) {
        String column = this.identifiers2Values.get(ctx.getChild(0));
        if (null == column) {
            return;
        }
        FilterIdentifierEntity.Builder filterBuilder = TWCSQLParserEntitiesFactory.filterIdentifierFactory();
        filterBuilder.setColumnName(column);
        filterBuilder.setContext(ctx);
        this.filterIdentifiers2FilterEntities.put(ctx, filterBuilder.build());
    }

    @Override
    public void exitInner_join_identifier(TWCSQLParser.Inner_join_identifierContext ctx) {
        if (null == ctx.getChild(0) || null == ctx.getChild(2)) {
            return;
        }
        String table = this.identifiers2Values.get(ctx.getChild(0).getChild(0));
        String column = this.identifiers2Values.get(ctx.getChild(2));
        if (null == table || null == column) {
            return;
        }
        FilterIdentifierEntity.Builder filterBuilder = TWCSQLParserEntitiesFactory.filterIdentifierFactory();
        filterBuilder.setTable(table);
        filterBuilder.setColumnName(column);
        filterBuilder.setContext(ctx);
        this.filterIdentifiers2FilterEntities.put(ctx, filterBuilder.build());
    }

    @Override
    public void exitCatalogSchemaTableIdentifier(TWCSQLParser.CatalogSchemaTableIdentifierContext ctx) {
        if (null == ctx.getChild(0) || null == ctx.getChild(2)) {
            return;
        }
        String catalogPart = this.identifiers2Values.get(ctx.getChild(0).getChild(0));
        String schemaPart = this.identifiers2Values.get(ctx.getChild(2).getChild(0));
        String table = this.identifiers2Values.get(ctx.getChild(4));
        if (null == catalogPart || null == schemaPart || null == table) {
            return;
        }
        TableIdentifierEntity.Builder tableBuilder = TWCSQLParserEntitiesFactory.tableIdentifierFactory();
        tableBuilder.setCatalog(catalogPart);
        tableBuilder.setSchema(schemaPart);
        tableBuilder.setTableName(table);
        if (6 == ctx.getChildCount() && null != this.identifiers2Values.get(ctx.getChild(5).getChild(0))) {
            tableBuilder.setTableAlias(this.identifiers2Values.get(ctx.getChild(5).getChild(0)));
        }
        tableBuilder.setContext(ctx);
        this.tables.add(tableBuilder.build());
    }

    @Override
    public void exitSchemaTableIdentifier(TWCSQLParser.SchemaTableIdentifierContext ctx) {
        if (null == ctx.getChild(0)) {
            return;
        }
        String schemaPart = this.identifiers2Values.get(ctx.getChild(0).getChild(0));
        String table = this.identifiers2Values.get(ctx.getChild(2));
        if (null == schemaPart || null == table) {
            return;
        }
        TableIdentifierEntity.Builder tableBuilder = TWCSQLParserEntitiesFactory.tableIdentifierFactory();
        tableBuilder.setSchema(schemaPart);
        tableBuilder.setTableName(table);
        if (4 == ctx.getChildCount() && null != this.identifiers2Values.get(ctx.getChild(3).getChild(0))) {
            tableBuilder.setTableAlias(this.identifiers2Values.get(ctx.getChild(3).getChild(0)));
        }
        tableBuilder.setContext(ctx);
        this.tables.add(tableBuilder.build());
    }

    @Override
    public void exitTableIdentifier(TWCSQLParser.TableIdentifierContext ctx) {
        String table = this.identifiers2Values.get(ctx.getChild(0));
        if (null == table) {
            return;
        }
        TableIdentifierEntity.Builder tableBuilder = TWCSQLParserEntitiesFactory.tableIdentifierFactory();
        tableBuilder.setTableName(table);
        if (2 == ctx.getChildCount() && null != this.identifiers2Values.get(ctx.getChild(1).getChild(0))) {
            tableBuilder.setTableAlias(this.identifiers2Values.get(ctx.getChild(1).getChild(0)));
        }
        tableBuilder.setContext(ctx);
        this.tables.add(tableBuilder.build());
    }

    @Override
    public void exitColumnStarIdentifier(TWCSQLParser.ColumnStarIdentifierContext ctx) {
        ColumnStarIdentifierEntity.Builder columnBuilder = TWCSQLParserEntitiesFactory.columnStarIdentifierFactory();
        columnBuilder.setContext(ctx);
        this.columns.add(columnBuilder.build());
    }

    @Override
    public void exitColumnLiteral(TWCSQLParser.ColumnLiteralContext ctx) {
        LiteralValue literal = this.literals2Values.get(ctx.getChild(0));
        if (null == literal) {
            return;
        }
        ColumnIdentifierEntity.Builder columnBuilder = TWCSQLParserEntitiesFactory.columnIdentifierFactory();
        columnBuilder.setColumnName("literal_" + (this.columns.size() + 1));
        if (3 == ctx.getChildCount() && null != this.identifiers2Values.get(ctx.getChild(2).getChild(0))) {
            columnBuilder.setColumnAlias(this.identifiers2Values.get(ctx.getChild(2).getChild(0)));
        }
        columnBuilder.setLiteralValue(literal);
        columnBuilder.setContext(ctx);
        this.columns.add(columnBuilder.build());
    }

    @Override
    public void exitSchemaTableColumnIdentifier(TWCSQLParser.SchemaTableColumnIdentifierContext ctx) {
        if (null == ctx.getChild(0) || null == ctx.getChild(2)) {
            return;
        }
        String schemaPart = this.identifiers2Values.get(ctx.getChild(0).getChild(0));
        String table = this.identifiers2Values.get(ctx.getChild(2).getChild(0));
        String column = this.identifiers2Values.get(ctx.getChild(4));
        if (null == schemaPart || null == table || null == column) {
            return;
        }
        ColumnIdentifierEntity.Builder columnBuilder = TWCSQLParserEntitiesFactory.columnIdentifierFactory();
        columnBuilder.setSchema(schemaPart);
        columnBuilder.setTable(table);
        columnBuilder.setColumnName(column);
        if (7 == ctx.getChildCount() && null != this.identifiers2Values.get(ctx.getChild(6).getChild(0))) {
            columnBuilder.setColumnAlias(this.identifiers2Values.get(ctx.getChild(6).getChild(0)));
        }
        columnBuilder.setContext(ctx);
        this.columns.add(columnBuilder.build());
    }

    @Override
    public void exitTableColumnIdentifier(TWCSQLParser.TableColumnIdentifierContext ctx) {
        if (null == ctx.getChild(0)) {
            return;
        }
        String table = this.identifiers2Values.get(ctx.getChild(0).getChild(0));
        String column = this.identifiers2Values.get(ctx.getChild(2));
        if (null == table || null == column) {
            return;
        }
        ColumnIdentifierEntity.Builder columnBuilder = TWCSQLParserEntitiesFactory.columnIdentifierFactory();
        columnBuilder.setTable(table);
        columnBuilder.setColumnName(column);
        if (5 == ctx.getChildCount() && null != this.identifiers2Values.get(ctx.getChild(4).getChild(0))) {
            columnBuilder.setColumnAlias(this.identifiers2Values.get(ctx.getChild(4).getChild(0)));
        }
        columnBuilder.setContext(ctx);
        this.columns.add(columnBuilder.build());
    }

    @Override
    public void exitColumnIdentifier(TWCSQLParser.ColumnIdentifierContext ctx) {
        String column = this.identifiers2Values.get(ctx.getChild(0));
        if (null == column) {
            return;
        }
        ColumnIdentifierEntity.Builder columnBuilder = TWCSQLParserEntitiesFactory.columnIdentifierFactory();
        columnBuilder.setColumnName(column);
        if (3 == ctx.getChildCount() && null != this.identifiers2Values.get(ctx.getChild(2).getChild(0))) {
            columnBuilder.setColumnAlias(this.identifiers2Values.get(ctx.getChild(2).getChild(0)));
        }
        columnBuilder.setContext(ctx);
        this.columns.add(columnBuilder.build());
    }

    @Override
    public void exitDelimitedIdentifier(TWCSQLParser.DelimitedIdentifierContext ctx) {
        String delimitedValue = ctx.getText();
        this.identifiers2Values.put(ctx, delimitedValue.substring(1, delimitedValue.length() - 1));
    }

    @Override
    public void exitRegularIdentifier(TWCSQLParser.RegularIdentifierContext ctx) {
        this.identifiers2Values.put(ctx, ctx.getText());
    }

    @Override
    public void exitIntegerLiteral(TWCSQLParser.IntegerLiteralContext ctx) {
        String literal = ctx.getText();
        LongLiteralValue.Builder literalValueBuilder = TWCSQLParserEntitiesFactory.longLiteralFactory();
        literalValueBuilder.setLiteralValue(literal);
        literalValueBuilder.setContext(ctx);
        try {
            this.literals2Values.put(ctx, literalValueBuilder.build());
        }
        catch (Exception e) {
            String msg = String.format(NOT_VALID_INTEGER_LITERAL_ERROR_FORMATTER, literal);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
    }

    @Override
    public void exitFixedPointLiteral(TWCSQLParser.FixedPointLiteralContext ctx) {
        String literal = ctx.getText();
        DoubleLiteralValue.Builder literalValueBuilder = TWCSQLParserEntitiesFactory.doubleLiteralFactory();
        literalValueBuilder.setLiteralValue(literal);
        literalValueBuilder.setContext(ctx);
        try {
            this.literals2Values.put(ctx, literalValueBuilder.build());
        }
        catch (Exception e) {
            String msg = String.format(NOT_VALID_DOUBLE_LITERAL_ERROR_FORMATTER, literal);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
    }

    @Override
    public void exitStringLiteral(TWCSQLParser.StringLiteralContext ctx) {
        String literal = ctx.getText();
        StringLiteralValue.Builder literalValueBuilder = TWCSQLParserEntitiesFactory.stringLiteralFactory();
        literalValueBuilder.setLiteralValue(literal.substring(1, literal.length() - 1));
        literalValueBuilder.setContext(ctx);
        this.literals2Values.put(ctx, literalValueBuilder.build());
    }

    @Override
    public void exitDateLiteral(TWCSQLParser.DateLiteralContext ctx) {
        String literal = ctx.getText();
        DateLiteralValue.Builder dateLiteralValueBuilder = TWCSQLParserEntitiesFactory.dateLiteralFactory();
        dateLiteralValueBuilder.setLiteralValue(literal);
        dateLiteralValueBuilder.setContext(ctx);
        try {
            this.literals2Values.put(ctx, dateLiteralValueBuilder.build());
        }
        catch (Exception e) {
            String msg = String.format(NOT_VALID_DATE_LITERAL_ERROR_FORMATTER, literal);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
    }

    @Override
    public void exitDateStringLiteral(TWCSQLParser.DateStringLiteralContext ctx) {
        String literal = ctx.getChild(1).getText();
        DateLiteralValue.Builder dateLiteralValueBuilder = TWCSQLParserEntitiesFactory.dateLiteralFactory();
        dateLiteralValueBuilder.setLiteralValue(literal.substring(1, literal.length() - 1));
        dateLiteralValueBuilder.setContext(ctx);
        try {
            this.literals2Values.put(ctx, dateLiteralValueBuilder.build());
        }
        catch (Exception e) {
            String msg = String.format(NOT_VALID_DATE_LITERAL_ERROR_FORMATTER, literal);
            SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
    }

    @Override
    public void exitCurrentDateLiteral(TWCSQLParser.CurrentDateLiteralContext ctx) {
        DateLiteralValue.Builder dateLiteralValueBuilder = TWCSQLParserEntitiesFactory.dateLiteralFactory();
        dateLiteralValueBuilder.setLiteralValue(this.currentDate.toString());
        dateLiteralValueBuilder.setContext(ctx);
        this.literals2Values.put(ctx, dateLiteralValueBuilder.build());
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        this.errors.add(new SyntaxErrorEntity(this.sql, offendingSymbol, line, charPositionInLine, msg));
    }

    @Override
    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
    }

    @Override
    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
    }

    @Override
    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
    }

    private void validateTables(TWCSQLParser.Tables_expressionContext tablesExpressionCtx) {
        SemanticErrorEntity se;
        String msg;
        Set detectedCatalogs = this.tables.stream().map(t -> {
            if (t.getCatalog().isEmpty()) {
                return this.catalogDefault;
            }
            return t.getCatalog().toUpperCase();
        }).collect(Collectors.toSet());
        Set detectedSchemas = this.tables.stream().map(t -> {
            if (t.getSchema().isEmpty()) {
                return this.schemaDefault;
            }
            return t.getSchema().toUpperCase();
        }).collect(Collectors.toSet());
        Set supportedCatalogs = this.twcMd.getCatalogs().stream().map(c -> c.getName().value().toUpperCase()).collect(Collectors.toSet());
        Set supportedSchemas = this.twcMd.getCatalogs().stream().map(c -> c.getSchemas().stream().map(s -> s.getName().value().toUpperCase()).collect(Collectors.toSet())).reduce((s1, s2) -> {
            s1.addAll(s2);
            return s1;
        }).orElse(Collections.emptySet());
        if (detectedCatalogs.size() > 1) {
            msg = String.format(MULTI_CATALOG_JOIN_ERROR_FORMATTER, detectedCatalogs);
            se = new SemanticErrorEntity(this.sql, tablesExpressionCtx.getStart(), tablesExpressionCtx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
        if (detectedSchemas.size() > 1) {
            msg = String.format(MULTI_SCHEMA_JOIN_ERROR_FORMATTER, detectedSchemas);
            se = new SemanticErrorEntity(this.sql, tablesExpressionCtx.getStart(), tablesExpressionCtx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
        if (!this.errors.isEmpty()) {
            return;
        }
        detectedCatalogs.removeAll(supportedCatalogs);
        if (!detectedCatalogs.isEmpty()) {
            this.tables.stream().filter(t -> detectedCatalogs.contains(t.getCatalog())).forEach(t -> {
                String msg = String.format(CATALOG_BIND_ERROR_FORMATTER, TABLE_STR, t, t.getCatalog());
                ParserRuleContext ctx = (ParserRuleContext)t.getContext();
                SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
            });
        }
        detectedSchemas.removeAll(supportedSchemas);
        if (!detectedSchemas.isEmpty()) {
            this.tables.stream().filter(t -> detectedSchemas.contains(t.getSchema())).forEach(t -> {
                String msg = String.format(SCHEMA_BIND_ERROR_FORMATTER, TABLE_STR, t, t.getSchema());
                ParserRuleContext ctx = (ParserRuleContext)t.getContext();
                SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
            });
        }
        if (!this.errors.isEmpty()) {
            return;
        }
        TableIdentifierEntity firstTable = this.tables.get(0);
        String catalogValue = firstTable.getCatalog().isEmpty() ? this.catalogDefault : firstTable.getCatalog().toUpperCase();
        String schemaValue = firstTable.getSchema().isEmpty() ? this.schemaDefault : firstTable.getSchema().toUpperCase();
        HashSet supportedTables = new HashSet();
        block0: for (Catalog c2 : this.twcMd.getCatalogs()) {
            if (catalogValue.compareToIgnoreCase(c2.getName().value()) != 0) continue;
            this.catalog = c2;
            for (Schema s : c2.getSchemas()) {
                if (schemaValue.compareToIgnoreCase(s.getName().value()) != 0) continue;
                this.schema = s;
                supportedTables.addAll(s.getTables().stream().map(t -> t.getName().toUpperCase()).collect(Collectors.toSet()));
                continue block0;
            }
        }
        this.globalColumns = this.schema.getGlobalColumns().stream().collect(Collectors.toMap(c -> c.getName().toUpperCase(), Function.identity()));
        ((Stream)this.tables.stream().sequential()).forEach(t -> {
            if (supportedTables.contains(t.getTable().toUpperCase())) {
                Table tableMd = (Table)this.schema.getTables().stream().filter(tMd -> tMd.getName().compareToIgnoreCase(t.getTable()) == 0).collect(Collectors.toList()).get(0);
                BoundedTable boundedTable = new BoundedTable((TableIdentifierEntity)t, tableMd);
                boundedTable = t.getAlias().isEmpty() ? this.boundedTables.put(t.getTable(), boundedTable) : this.boundedTables.put(t.getAlias(), boundedTable);
                if (null != boundedTable) {
                    String msg = String.format(DUPLICATE_TABLE_IDENTIFIER_ERROR_FORMATTER, t);
                    ParserRuleContext ctx = (ParserRuleContext)t.getContext();
                    SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
                    LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                    this.errors.add(se);
                }
            } else {
                String msg = String.format(TABLE_BIND_ERROR_FORMATTER, TABLE_STR, t, t.getTable());
                ParserRuleContext ctx = (ParserRuleContext)t.getContext();
                SemanticErrorEntity se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
            }
        });
        if (!this.errors.isEmpty()) {
            return;
        }
        for (BoundedTable boundedTable : this.boundedTables.values()) {
            for (Column columnInScope : boundedTable.getTable().getColumns()) {
                ColumnIdentifierEntity.Builder columnIdentifierBuilder = TWCSQLParserEntitiesFactory.columnIdentifierFactory();
                columnIdentifierBuilder.setColumnName(columnInScope.getName());
                columnIdentifierBuilder.setContext(boundedTable.getTableIdentifier().getContext());
                BoundedColumn boundedColumnMd = new BoundedColumn(columnIdentifierBuilder.build(), columnInScope, boundedTable.getTable());
                this.columnsInScope.putIfAbsent(columnInScope.getName().toUpperCase(), boundedColumnMd);
            }
        }
    }

    private void validateColumns() {
        if (this.columns.size() == 1 && this.columns.get(0) instanceof ColumnStarIdentifierEntity) {
            this.projectAllColumns = true;
            LOGGER.info("QueryId: {} - Projecting all columns. No individual column validation performed.", (Object)this.queryId);
            return;
        }
        for (ColumnIdentifierEntity c : this.columns) {
            SemanticErrorEntity se;
            String msg;
            BoundedColumn boundedColumn;
            ParserRuleContext ctx = (ParserRuleContext)c.getContext();
            if (c.isLiteral()) {
                Table tableMd = new Table();
                tableMd.setName("");
                Column columnMd = new Column();
                columnMd.setName(c.getColumn());
                columnMd.setDatatype(c.getLiteral().getDataType());
                columnMd.setIsKey(false);
                columnMd.setNullable(c.getLiteral().isNullLiteralValue());
                columnMd.setVisible(true);
                columnMd.setPrecision(c.getLiteral() instanceof StringLiteralValue ? c.getLiteral().getLiteralValue().length() : -1);
                columnMd.setScale(c.getLiteral() instanceof StringLiteralValue ? 0 : -1);
                BoundedColumn bouldedColumn = new BoundedColumn(c, columnMd, tableMd);
                this.boundedColumns.add(bouldedColumn);
                continue;
            }
            if (!c.getSchema().isEmpty() && c.getSchema().compareToIgnoreCase(this.schema.getName().value()) != 0) {
                String msg2 = String.format(SCHEMA_BIND_ERROR_FORMATTER, COLUMN_STR, c, c.getSchema());
                SemanticErrorEntity se2 = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg2);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se2.getFormattedErrorMessage());
                this.errors.add(se2);
                continue;
            }
            BoundedTable boundedTable = this.boundedTables.get(c.getTable());
            if (null == boundedTable) {
                BoundedColumn boundedColumnMd = this.columnsInScope.get(c.getColumn().toUpperCase());
                if (null != boundedColumnMd) {
                    boundedColumn = new BoundedColumn(c, boundedColumnMd.getColumn(), boundedColumnMd.getTable());
                    this.boundedColumns.add(boundedColumn);
                    continue;
                }
                msg = String.format(TABLE_BIND_ERROR_FORMATTER, COLUMN_STR, c, c.getTable());
                se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
                continue;
            }
            List columnMdList = boundedTable.getTable().getColumns().stream().filter(cMd -> cMd.getName().compareToIgnoreCase(c.getColumn()) == 0).collect(Collectors.toList());
            if (columnMdList.size() == 1) {
                boundedColumn = new BoundedColumn(c, (Column)columnMdList.get(0), boundedTable.getTable());
                this.boundedColumns.add(boundedColumn);
                continue;
            }
            msg = String.format(COLUMN_BIND_ERROR_FORMATTER, COLUMN_STR, c, c.getColumn());
            se = new SemanticErrorEntity(this.sql, ctx.getStart(), ctx.getStop(), msg);
            LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
            this.errors.add(se);
        }
    }

    private void validateJoinIdentifiers() {
        ((Stream)this.nodes2JoinExpressions.values().stream().sequential()).filter(je -> je instanceof BinaryFilterExpression).forEach(je -> {
            SemanticErrorEntity se;
            String msg;
            SemanticErrorEntity se2;
            String msg2;
            SemanticErrorEntity se3;
            String msg3;
            boolean boundError = false;
            BinaryFilterExpression binaryJE = (BinaryFilterExpression)je;
            ParserRuleContext binaryJECtx = (ParserRuleContext)binaryJE.getContext();
            FilterIdentifierEntity left = binaryJE.getLeftOperand();
            FilterIdentifierEntity right = binaryJE.getRightOperand();
            ParserRuleContext leftCtx = (ParserRuleContext)left.getContext();
            ParserRuleContext rightCtx = (ParserRuleContext)right.getContext();
            if (left.getColumn().compareToIgnoreCase(right.getColumn()) != 0) {
                String msg4 = String.format(INNER_JOIN_COMMON_IDENTIFIERS_ERROR_FORMATTER, left, right);
                SemanticErrorEntity se4 = new SemanticErrorEntity(this.sql, binaryJECtx.getStart(), binaryJECtx.getStop(), msg4);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se4.getFormattedErrorMessage());
                this.errors.add(se4);
                return;
            }
            if (!left.getSchema().isEmpty() && left.getSchema().compareToIgnoreCase(this.schema.getName().value()) != 0) {
                msg3 = String.format(SCHEMA_BIND_ERROR_FORMATTER, IDENTIFIER_STR, left, left.getSchema());
                se3 = new SemanticErrorEntity(this.sql, leftCtx.getStart(), leftCtx.getStop(), msg3);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se3.getFormattedErrorMessage());
                this.errors.add(se3);
                boundError = true;
            }
            if (!right.getSchema().isEmpty() && right.getSchema().compareToIgnoreCase(this.schema.getName().value()) != 0) {
                msg3 = String.format(SCHEMA_BIND_ERROR_FORMATTER, IDENTIFIER_STR, right, right.getSchema());
                se3 = new SemanticErrorEntity(this.sql, rightCtx.getStart(), rightCtx.getStop(), msg3);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se3.getFormattedErrorMessage());
                this.errors.add(se3);
                boundError = true;
            }
            if (boundError) {
                return;
            }
            BoundedTable leftTable = this.boundedTables.get(left.getTable());
            BoundedTable rightTable = this.boundedTables.get(right.getTable());
            if (null == leftTable) {
                msg2 = String.format(TABLE_BIND_ERROR_FORMATTER, IDENTIFIER_STR, left, left.getTable());
                se2 = new SemanticErrorEntity(this.sql, leftCtx.getStart(), leftCtx.getStop(), msg2);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se2.getFormattedErrorMessage());
                this.errors.add(se2);
                boundError = true;
            }
            if (null == rightTable) {
                msg2 = String.format(TABLE_BIND_ERROR_FORMATTER, IDENTIFIER_STR, right, right.getTable());
                se2 = new SemanticErrorEntity(this.sql, rightCtx.getStart(), rightCtx.getStop(), msg2);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se2.getFormattedErrorMessage());
                this.errors.add(se2);
                boundError = true;
            }
            if (boundError) {
                return;
            }
            List leftColumnLst = leftTable.getTable().getColumns().stream().filter(cMd -> cMd.getName().compareToIgnoreCase(left.getColumn()) == 0).collect(Collectors.toList());
            List rightColumnLst = rightTable.getTable().getColumns().stream().filter(cMd -> cMd.getName().compareToIgnoreCase(right.getColumn()) == 0).collect(Collectors.toList());
            if (leftColumnLst.size() != 1) {
                msg = String.format(COLUMN_BIND_ERROR_FORMATTER, IDENTIFIER_STR, left, left.getColumn());
                se = new SemanticErrorEntity(this.sql, leftCtx.getStart(), leftCtx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
                boundError = true;
            }
            if (rightColumnLst.size() != 1) {
                msg = String.format(COLUMN_BIND_ERROR_FORMATTER, IDENTIFIER_STR, right, right.getColumn());
                se = new SemanticErrorEntity(this.sql, rightCtx.getStart(), rightCtx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
                boundError = true;
            }
            if (boundError) {
                return;
            }
            if (!((Column)leftColumnLst.get(0)).getIsKey().booleanValue()) {
                msg = String.format(INNER_JOIN_NON_KEY_IDENTIFIERS_NOT_ALLOWED_ERROR_FORMATTER, left, leftTable.getTableIdentifier());
                se = new SemanticErrorEntity(this.sql, leftCtx.getStart(), leftCtx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
            }
            if (!((Column)rightColumnLst.get(0)).getIsKey().booleanValue()) {
                msg = String.format(INNER_JOIN_NON_KEY_IDENTIFIERS_NOT_ALLOWED_ERROR_FORMATTER, right, rightTable.getTableIdentifier());
                se = new SemanticErrorEntity(this.sql, rightCtx.getStart(), rightCtx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
            }
        });
    }

    private void validateFilterIdentifiers() {
        this.nodes2FilterExpressions.values().stream().filter(fe -> fe instanceof UnaryFilterExpression).forEach(fe -> {
            UnaryFilterExpression unaryFE = (UnaryFilterExpression)fe;
            FilterIdentifierEntity operand = unaryFE.getOperand();
            ParserRuleContext operandCtx = (ParserRuleContext)operand.getContext();
            List values = unaryFE.getValues().stream().filter(v -> !v.isNullLiteralValue()).collect(Collectors.toList());
            if (!operand.getSchema().isEmpty() && operand.getSchema().compareToIgnoreCase(this.schema.getName().value()) != 0) {
                String msg = String.format(SCHEMA_BIND_ERROR_FORMATTER, IDENTIFIER_STR, operand, operand.getSchema());
                SemanticErrorEntity se = new SemanticErrorEntity(this.sql, operandCtx.getStart(), operandCtx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
                return;
            }
            BoundedTable boundedTable = this.boundedTables.get(operand.getTable());
            Column columnMd = this.globalColumns.get(operand.getColumn().toUpperCase());
            if (null == columnMd && null == boundedTable) {
                BoundedColumn boundedColumnMd = this.columnsInScope.get(operand.getColumn().toUpperCase());
                if (null != boundedColumnMd) {
                    columnMd = boundedColumnMd.getColumn();
                } else {
                    String msg = String.format(TABLE_BIND_ERROR_FORMATTER, IDENTIFIER_STR, operand, operand.getTable());
                    SemanticErrorEntity se = new SemanticErrorEntity(this.sql, operandCtx.getStart(), operandCtx.getStop(), msg);
                    LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                    this.errors.add(se);
                    return;
                }
            }
            if (null != boundedTable && null == columnMd) {
                List columnLst = boundedTable.getTable().getColumns().stream().filter(cMd -> cMd.getName().compareToIgnoreCase(operand.getColumn()) == 0).collect(Collectors.toList());
                if (columnLst.size() != 1) {
                    String msg = String.format(COLUMN_BIND_ERROR_FORMATTER, IDENTIFIER_STR, operand, operand.getColumn());
                    SemanticErrorEntity se = new SemanticErrorEntity(this.sql, operandCtx.getStart(), operandCtx.getStop(), msg);
                    LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                    this.errors.add(se);
                    return;
                }
                columnMd = (Column)columnLst.get(0);
            }
            for (LiteralValue value : values) {
                ParserRuleContext valueCtx = (ParserRuleContext)value.getContext();
                if (value.isDataTypeCompatible(columnMd.getDatatype())) continue;
                String msg = String.format(INCOMPATIBLE_LITERAL_DATATYPE_ERROR_FORMATTER, value, value.getTypeName(), operand, MetadataUtils.inferDatatypeName(columnMd.getDatatype(), columnMd.getPrecision(), columnMd.getScale(), columnMd.getPrecision()));
                SemanticErrorEntity se = new SemanticErrorEntity(this.sql, valueCtx.getStart(), valueCtx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
                return;
            }
            operand.setDataType(columnMd.getDatatype());
        });
        this.nodes2FilterExpressions.values().stream().filter(fe -> fe instanceof BinaryFilterExpression).forEach(fe -> {
            List columnLst;
            BoundedColumn boundedColumnMd;
            BinaryFilterExpression binaryFE = (BinaryFilterExpression)fe;
            ParserRuleContext binaryFECtx = (ParserRuleContext)binaryFE.getContext();
            FilterIdentifierEntity left = binaryFE.getLeftOperand();
            FilterIdentifierEntity right = binaryFE.getRightOperand();
            ParserRuleContext leftCtx = (ParserRuleContext)left.getContext();
            ParserRuleContext rightCtx = (ParserRuleContext)right.getContext();
            BoundedTable leftBoundedTable = this.boundedTables.get(left.getTable());
            BoundedTable rightBoundedTable = this.boundedTables.get(right.getTable());
            Column leftColumnMd = this.globalColumns.get(left.getColumn().toUpperCase());
            Column rightColumnMd = this.globalColumns.get(right.getColumn().toUpperCase());
            if (null == leftColumnMd && null == leftBoundedTable) {
                boundedColumnMd = this.columnsInScope.get(left.getColumn().toUpperCase());
                if (null != boundedColumnMd) {
                    leftColumnMd = boundedColumnMd.getColumn();
                } else {
                    String msg = String.format(TABLE_BIND_ERROR_FORMATTER, IDENTIFIER_STR, left, left.getTable());
                    SemanticErrorEntity se = new SemanticErrorEntity(this.sql, leftCtx.getStart(), leftCtx.getStop(), msg);
                    LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                    this.errors.add(se);
                    return;
                }
            }
            if (null == rightColumnMd && null == rightBoundedTable) {
                boundedColumnMd = this.columnsInScope.get(left.getColumn().toUpperCase());
                if (null != boundedColumnMd) {
                    rightColumnMd = boundedColumnMd.getColumn();
                } else {
                    String msg = String.format(TABLE_BIND_ERROR_FORMATTER, IDENTIFIER_STR, right, right.getTable());
                    SemanticErrorEntity se = new SemanticErrorEntity(this.sql, rightCtx.getStart(), rightCtx.getStop(), msg);
                    LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                    this.errors.add(se);
                    return;
                }
            }
            if (null != leftBoundedTable && null == leftColumnMd) {
                columnLst = leftBoundedTable.getTable().getColumns().stream().filter(cMd -> cMd.getName().compareToIgnoreCase(left.getColumn()) == 0).collect(Collectors.toList());
                if (columnLst.size() != 1) {
                    String msg = String.format(COLUMN_BIND_ERROR_FORMATTER, IDENTIFIER_STR, left, left.getColumn());
                    SemanticErrorEntity se = new SemanticErrorEntity(this.sql, leftCtx.getStart(), leftCtx.getStop(), msg);
                    LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                    this.errors.add(se);
                    return;
                }
                leftColumnMd = (Column)columnLst.get(0);
            }
            if (null != rightBoundedTable && null == rightColumnMd) {
                columnLst = rightBoundedTable.getTable().getColumns().stream().filter(cMd -> cMd.getName().compareToIgnoreCase(right.getColumn()) == 0).collect(Collectors.toList());
                if (columnLst.size() != 1) {
                    String msg = String.format(COLUMN_BIND_ERROR_FORMATTER, IDENTIFIER_STR, right, right.getColumn());
                    SemanticErrorEntity se = new SemanticErrorEntity(this.sql, rightCtx.getStart(), rightCtx.getStop(), msg);
                    LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                    this.errors.add(se);
                    return;
                }
                rightColumnMd = (Column)columnLst.get(0);
            }
            if (!leftColumnMd.getDatatype().equals((Object)rightColumnMd.getDatatype())) {
                String msg = String.format(INCOMPATIBLE_DATA_TYPES_BETWEEN_OPERANDS_ERROR_FORMATTER, left, MetadataUtils.inferDatatypeName(leftColumnMd.getDatatype(), leftColumnMd.getPrecision(), leftColumnMd.getScale(), leftColumnMd.getPrecision()), right, MetadataUtils.inferDatatypeName(rightColumnMd.getDatatype(), rightColumnMd.getPrecision(), rightColumnMd.getScale(), rightColumnMd.getPrecision()));
                SemanticErrorEntity se = new SemanticErrorEntity(this.sql, binaryFECtx.getStart(), binaryFECtx.getStop(), msg);
                LOGGER.info(LOG_SEMANTIC_ERROR, (Object)this.queryId, (Object)se.getFormattedErrorMessage());
                this.errors.add(se);
            }
            left.setDataType(leftColumnMd.getDatatype());
            right.setDataType(rightColumnMd.getDatatype());
        });
    }

    private void generateValueRanges(TWCSQLParser.CteContext ctx) {
        PlainErrorEntity plainError;
        PlainErrorEntity plainError2;
        PlainErrorEntity plainError3;
        for (Map.Entry<String, Column> entry : this.globalColumns.entrySet()) {
            FilterIdentifierEntity.Builder builder = TWCSQLParserEntitiesFactory.filterIdentifierFactory();
            builder.setSchema("");
            builder.setTable("");
            builder.setColumnName(entry.getKey());
            builder.setContext(ctx);
            FilterIdentifierEntity filterIdentifier = builder.build();
            BoundedFilterIdentifier boundedFilterIdentifier = new BoundedFilterIdentifier(filterIdentifier, entry.getValue());
            FilterIdentifierValuesResolver resolver = new FilterIdentifierValuesResolver(boundedFilterIdentifier, false, false, false);
            if (null == this.rootFilterExpression) {
                this.valuesResolvers.put(entry.getKey(), null);
                continue;
            }
            FilterIdentifierValuesResolver result = this.rootFilterExpression.accept(resolver);
            this.valuesResolvers.put(entry.getKey(), result);
        }
        FilterIdentifierValuesResolver postalKeyResolver = this.valuesResolvers.get("POSTALKEY");
        if (null == postalKeyResolver && this.strictMode) {
            plainError3 = new PlainErrorEntity(NO_POSTAL_KEY_VALUE_PROVIDED);
            LOGGER.info(LOG_PLAIN_ERROR, (Object)this.queryId, (Object)plainError3.getFormattedErrorMessage());
            this.errors.add(plainError3);
        } else if (null != postalKeyResolver && !postalKeyResolver.containsOnlyClosedSingularPointsAsIntervals(!this.strictMode)) {
            plainError3 = new PlainErrorEntity(String.format(INVALID_POSTAL_KEY_VALUES_PROVIDED, postalKeyResolver.getIntervals().toString()));
            LOGGER.info(LOG_PLAIN_ERROR, (Object)this.queryId, (Object)plainError3.getFormattedErrorMessage());
            this.errors.add(plainError3);
        } else if (null != postalKeyResolver) {
            this.postalKeyValues = postalKeyResolver.getIntervals().stream().map(i -> i.getBegin().getLiteralValue()).collect(Collectors.toList());
        }
        this.units = this.unitsDefault;
        FilterIdentifierValuesResolver unitsResolver = this.valuesResolvers.get("UNITS");
        if (null != unitsResolver) {
            if (1 != unitsResolver.getIntervals().size() || !unitsResolver.containsOnlyClosedSingularPointsAsIntervals(false)) {
                plainError2 = new PlainErrorEntity(String.format(INVALID_UNITS_VALUES_FORMATTER, unitsResolver.getIntervals().toString(), AbstractConnectionProperty.UnitValues.E.getValue(), AbstractConnectionProperty.UnitValues.M.getValue(), AbstractConnectionProperty.UnitValues.S.getValue()));
                LOGGER.info(LOG_PLAIN_ERROR, (Object)this.queryId, (Object)plainError2.getFormattedErrorMessage());
                this.errors.add(plainError2);
            } else {
                this.units = unitsResolver.getIntervals().toArray(new ValuesInterval[1])[0].getBegin().getLiteralValue();
            }
        }
        if (!(this.units.equalsIgnoreCase(AbstractConnectionProperty.UnitValues.E.getValue()) || this.units.equalsIgnoreCase(AbstractConnectionProperty.UnitValues.M.getValue()) || this.units.equalsIgnoreCase(AbstractConnectionProperty.UnitValues.S.getValue()))) {
            plainError2 = new PlainErrorEntity(String.format(INVALID_UNITS_VALUE_FORMATTER, this.units, AbstractConnectionProperty.UnitValues.E.getValue(), AbstractConnectionProperty.UnitValues.M.getValue(), AbstractConnectionProperty.UnitValues.S.getValue()));
            LOGGER.info(LOG_PLAIN_ERROR, (Object)this.queryId, (Object)plainError2.getFormattedErrorMessage());
            this.errors.add(plainError2);
        }
        this.language = this.languageDefault;
        FilterIdentifierValuesResolver languageResolver = this.valuesResolvers.get("LANGUAGE");
        if (null != languageResolver) {
            if (1 != languageResolver.getIntervals().size() || !languageResolver.containsOnlyClosedSingularPointsAsIntervals(false)) {
                plainError = new PlainErrorEntity(String.format(INVALID_LANGUAGE_VALUES_FORMATTER, languageResolver.getIntervals().toString(), AbstractConnectionProperty.LanguageValues.EN_US.getValue()));
                LOGGER.info(LOG_PLAIN_ERROR, (Object)this.queryId, (Object)plainError.getFormattedErrorMessage());
                this.errors.add(plainError);
            } else {
                this.language = languageResolver.getIntervals().toArray(new ValuesInterval[1])[0].getBegin().getLiteralValue();
            }
        }
        if (!this.language.equalsIgnoreCase(AbstractConnectionProperty.LanguageValues.EN_US.getValue())) {
            plainError = new PlainErrorEntity(String.format(INVALID_LANGUAGE_VALUE_FORMATTER, this.language, AbstractConnectionProperty.LanguageValues.EN_US.getValue()));
            LOGGER.info(LOG_PLAIN_ERROR, (Object)this.queryId, (Object)plainError.getFormattedErrorMessage());
            this.errors.add(plainError);
        }
        FilterIdentifierValuesResolver datesResolver = this.valuesResolvers.get("DATE");
        if (Schema.Name.FORECAST.value().compareToIgnoreCase(this.schema.getName().value()) == 0) {
            return;
        }
        if (null != datesResolver && !datesResolver.getIntervals().isEmpty()) {
            if (!this.strictMode) {
                DateLiteralValue.Builder yesterdayLiteralBuilder = TWCSQLParserEntitiesFactory.dateLiteralFactory();
                yesterdayLiteralBuilder.setLiteralValue(this.currentDate.plusDays(-1L).toString());
                yesterdayLiteralBuilder.setContext(ctx);
                ValuesInterval minusInfinityToYesterday = new ValuesInterval(null, yesterdayLiteralBuilder.build(), false, true);
                datesResolver.collapseIntervals(ImmutableSet.of(minusInfinityToYesterday));
            }
            for (ValuesInterval current : datesResolver.getIntervals()) {
                LocalDate startDate = DateLiteralValue.MIN_SQL_ISO_DATE;
                LocalDate endDate = DateLiteralValue.MAX_SQL_ISO_DATE;
                if (null != current.getBegin()) {
                    startDate = ((DateLiteralValue)current.getBegin()).getDateValue();
                }
                if (null != current.getEnd()) {
                    endDate = ((DateLiteralValue)current.getEnd()).getDateValue();
                }
                if (!current.isBeginBounded()) {
                    startDate = startDate.plusDays(1L);
                }
                if (!current.isEndBounded()) {
                    endDate = endDate.minusDays(1L);
                }
                if (startDate.isAfter(endDate)) continue;
                this.dateValues.add(startDate);
                this.dateValues.add(endDate);
            }
        }
    }

    private void constructURIs() {
        if (Schema.Name.HISTORICAL == this.schema.getName() || Schema.Name.FORECAST == this.schema.getName()) {
            List products = this.boundedTables.values().stream().map(BoundedTable::getTable).sorted(Comparator.comparingInt(Table::getOrdinal)).collect(Collectors.toList());
            String productIdValue = products.stream().map(t -> null == t.getProductId() ? t.getName() : t.getProductId()).collect(Collectors.joining(COMMA_STR));
            StringJoiner uriNoConnParameters = new StringJoiner(SLASH_STR).add(this.baseURI.toString()).add(this.catalog.getRelativePath().value()).add(this.schema.getRelativePath().value());
            if (Schema.Name.HISTORICAL == this.schema.getName()) {
                uriNoConnParameters.add(ANALYTICAL_STR);
            }
            StringBuilder uriSB = new StringBuilder(uriNoConnParameters.toString());
            uriSB.append(QUESTIONMARK_STR).append("postalKey=%s").append(AMPERSAND_STR).append("productId=").append(productIdValue).append(AMPERSAND_STR).append("language=").append(this.language).append(AMPERSAND_STR).append("units=").append(this.units).append(AMPERSAND_STR).append("format=csv");
            if (!this.dateValues.isEmpty()) {
                uriSB.append(AMPERSAND_STR).append("startDate=").append("%s").append(AMPERSAND_STR).append("endDate=").append("%s");
            }
            String uriFormatter = uriSB.toString();
            for (String postalCode : this.postalKeyValues) {
                if (this.dateValues.isEmpty()) {
                    this.uris.add(String.format(uriFormatter, this.encodeValue(postalCode)));
                    continue;
                }
                Iterator<LocalDate> it = this.dateValues.iterator();
                while (it.hasNext()) {
                    LocalDate startDateValue = it.next();
                    LocalDate endDateValue = it.next();
                    this.uris.add(String.format(uriFormatter, this.encodeValue(postalCode), startDateValue.format(DateTimeFormatter.BASIC_ISO_DATE), endDateValue.format(DateTimeFormatter.BASIC_ISO_DATE)));
                }
            }
        } else if (Schema.Name.SYSTEM == this.schema.getName()) {
            List<String> relativePaths;
            Optional<Table> table = this.boundedTables.values().stream().map(BoundedTable::getTable).findAny();
            if (table.isPresent() && null != (relativePaths = table.get().getRelativePaths())) {
                for (String relativePath : relativePaths) {
                    String uriNoConnParameters = new StringJoiner(SLASH_STR).add(this.baseURI.toString()).add(this.catalog.getRelativePath().value()).add(this.schema.getRelativePath().value()).add(relativePath).toString();
                    this.uris.add(uriNoConnParameters);
                }
            }
        } else {
            this.uris.add(this.schema.getScheme().value() + (Object)((Object)this.schema.getRelativePath()));
        }
    }

    private String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return "UnsupportedEncoding";
        }
    }
}

