/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterConditionEvaluator;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterIdentifierEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterIdentifierValuesResolver;
import com.ibm.cognos.jdbc.twc.sqlparser.LiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.ValuesInterval;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

class UnaryFilterExpression
extends AbstractFilterExpression
implements TWCMessageKeys {
    private final FilterIdentifierEntity operand;
    private final List<LiteralValue> values;

    private UnaryFilterExpression(FilterIdentifierEntity filterOperand, FilterExpression.ComparisonOperator op, List<LiteralValue> filterValues, ParseTree ctx) {
        super(op, ctx);
        Objects.requireNonNull(op, TWCMessageUtil.getMessage("0007", "op"));
        Objects.requireNonNull(filterOperand, TWCMessageUtil.getMessage("0007", "filterOperand"));
        Objects.requireNonNull(filterValues, TWCMessageUtil.getMessage("0007", "filterValues"));
        UnaryFilterExpression.validateFilterValuesListIsNotEmpty(filterValues);
        UnaryFilterExpression.validateFilterValuesListNotContainingNulls(filterValues);
        if (FilterExpression.ComparisonOperator.BETWEEN.equals(op)) {
            UnaryFilterExpression.validateFilterValuesForBetweenExpressions(filterValues);
        }
        this.operand = filterOperand;
        ArrayList<LiteralValue> tempList = new ArrayList<LiteralValue>(filterValues);
        this.values = Collections.unmodifiableList(tempList);
    }

    private static void validateFilterValuesListIsNotEmpty(List<LiteralValue> filterValues) {
        if (filterValues.isEmpty()) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0008", "filterValues"));
        }
    }

    private static void validateFilterValuesListNotContainingNulls(List<LiteralValue> filterValues) {
        if (filterValues.contains(null)) {
            throw new IllegalArgumentException("'filterValues' list cannot contain null objects.");
        }
    }

    private static void validateFilterValuesForBetweenExpressions(List<LiteralValue> filterValues) {
        if (filterValues.size() != 2) {
            throw new IllegalArgumentException("BETWEEN filter expression expects exactly two literal values.");
        }
        if (filterValues.get(0).compareTo(filterValues.get(1)) > 0) {
            throw new IllegalArgumentException(String.format("First literal value '%s' should be always less than equal compared to second literal value '%s' provided in BETWEEN filter expression.", filterValues.get(0), filterValues.get(1)));
        }
    }

    FilterIdentifierEntity getOperand() {
        return this.operand;
    }

    @Override
    public FilterExpression.FilterExpressionType getFilterExpressionType() {
        return FilterExpression.FilterExpressionType.UNARY;
    }

    List<LiteralValue> getValues() {
        return this.values;
    }

    @Override
    public boolean isEquivalent(Entity entity) {
        if (entity instanceof UnaryFilterExpression) {
            UnaryFilterExpression unaryFilter = (UnaryFilterExpression)entity;
            return this.getOperand().isEquivalent(unaryFilter.getOperand()) && this.getFilterOperator() == unaryFilter.getFilterOperator() && this.values.containsAll(unaryFilter.getValues()) && unaryFilter.getValues().containsAll(this.values);
        }
        return false;
    }

    @Override
    public FilterIdentifierValuesResolver accept(FilterIdentifierValuesResolver visitor) {
        Objects.requireNonNull(visitor, TWCMessageUtil.getMessage("0007", "visitor"));
        FilterIdentifierValuesResolver currentVisitor = new FilterIdentifierValuesResolver(visitor.getFilterIdentifier(), visitor.strictlyMatchFilterIdentifiers(), false, false);
        FilterIdentifierEntity visitorFilterIdentifier = visitor.getFilterIdentifier().getFilterIdentifier();
        FilterExpression.ComparisonOperator operator = (FilterExpression.ComparisonOperator)this.getFilterOperator();
        List nonNullValues = this.values.stream().filter(l -> !l.isNullLiteralValue()).collect(Collectors.toList());
        if (nonNullValues.isEmpty()) {
            if (FilterExpression.ComparisonOperator.EQUAL.equals(operator) && this.isFilterVisitorMatchingOperandIdentifiers(visitorFilterIdentifier, visitor.strictlyMatchFilterIdentifiers())) {
                currentVisitor.setContradictory(true);
                currentVisitor.setRepresentingContradiction();
                return currentVisitor;
            }
            return null;
        }
        if (this.isFilterVisitorMatchingOperandIdentifiers(visitorFilterIdentifier, visitor.strictlyMatchFilterIdentifiers())) {
            if (FilterExpression.ComparisonOperator.EQUAL.equals(operator)) {
                LiteralValue literalValue = (LiteralValue)nonNullValues.get(0);
                ValuesInterval interval = new ValuesInterval(literalValue, literalValue, true, true);
                currentVisitor.mergeInterval(interval);
            } else if (FilterExpression.ComparisonOperator.GT.equals(operator)) {
                LiteralValue literalValue = (LiteralValue)nonNullValues.get(0);
                ValuesInterval interval = new ValuesInterval(literalValue, null, false, false);
                currentVisitor.mergeInterval(interval);
            } else if (FilterExpression.ComparisonOperator.GTE.equals(operator)) {
                LiteralValue literalValue = (LiteralValue)nonNullValues.get(0);
                ValuesInterval interval = new ValuesInterval(literalValue, null, true, false);
                currentVisitor.mergeInterval(interval);
            } else if (FilterExpression.ComparisonOperator.LT.equals(operator)) {
                LiteralValue literalValue = (LiteralValue)nonNullValues.get(0);
                ValuesInterval interval = new ValuesInterval(null, literalValue, false, false);
                currentVisitor.mergeInterval(interval);
            } else if (FilterExpression.ComparisonOperator.LTE.equals(operator)) {
                LiteralValue literalValue = (LiteralValue)nonNullValues.get(0);
                ValuesInterval interval = new ValuesInterval(null, literalValue, false, true);
                currentVisitor.mergeInterval(interval);
            } else if (FilterExpression.ComparisonOperator.IN.equals(operator)) {
                Set intervals = nonNullValues.stream().map(l -> new ValuesInterval((LiteralValue)l, (LiteralValue)l, true, true)).collect(Collectors.toCollection(TreeSet::new));
                currentVisitor.mergeIntervals(intervals);
            } else if (FilterExpression.ComparisonOperator.NE.equals(operator)) {
                LiteralValue literalValue = (LiteralValue)nonNullValues.get(0);
                ValuesInterval leftInterval = new ValuesInterval(null, literalValue, false, false);
                ValuesInterval rightInterval = new ValuesInterval(literalValue, null, false, false);
                TreeSet<ValuesInterval> intervals = new TreeSet<ValuesInterval>();
                intervals.add(leftInterval);
                intervals.add(rightInterval);
                currentVisitor.mergeIntervals(intervals);
            } else {
                LiteralValue start = (LiteralValue)nonNullValues.get(0);
                LiteralValue end = (LiteralValue)nonNullValues.get(1);
                ValuesInterval interval = new ValuesInterval(start, end, true, true);
                currentVisitor.mergeInterval(interval);
            }
            return currentVisitor;
        }
        return null;
    }

    private boolean isFilterVisitorMatchingOperandIdentifiers(FilterIdentifierEntity visitorFilterIdentifier, boolean strictMatch) {
        if (strictMatch) {
            return visitorFilterIdentifier.isEquivalent(this.getOperand());
        }
        return visitorFilterIdentifier.getColumn().compareToIgnoreCase(this.getOperand().getColumn()) == 0;
    }

    @Override
    public boolean accept(FilterConditionEvaluator evaluator) {
        return evaluator.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOperand()).append(" ");
        if (FilterExpression.ComparisonOperator.EQUAL == this.getFilterOperator() && this.values.get(0).isNullLiteralValue()) {
            sb.append("IS").append(" ");
        } else if (FilterExpression.ComparisonOperator.NE == this.getFilterOperator() && this.values.get(0).isNullLiteralValue()) {
            sb.append("IS NOT").append(" ");
        } else {
            sb.append(this.getFilterOperator().getLiteralName()).append(" ");
        }
        if (FilterExpression.ComparisonOperator.BETWEEN == this.getFilterOperator()) {
            sb.append(this.values.get(0)).append(" ").append(AND_STR).append(" ").append(this.values.get(1));
        } else if (FilterExpression.ComparisonOperator.IN == this.getFilterOperator()) {
            sb.append(OPEN_PARENTHESIS_STR).append(this.values.get(0));
            if (this.values.size() > 1) {
                Iterator<LiteralValue> it = this.values.iterator();
                it.next();
                while (it.hasNext()) {
                    sb.append(COMMA_STR).append(" ").append(it.next());
                }
            }
            sb.append(CLOSE_PARENTHESIS_STR);
        } else {
            sb.append(this.values.get(0));
        }
        return sb.toString();
    }

    static class Builder {
        private FilterIdentifierEntity aFilterOperand;
        private FilterExpression.ComparisonOperator aFilterOperator;
        private List<LiteralValue> someValues = new ArrayList<LiteralValue>();
        private ParseTree aCtx;

        Builder() {
        }

        Builder setFilterOperand(FilterIdentifierEntity filterOperand) {
            this.aFilterOperand = filterOperand;
            return this;
        }

        Builder setFilterOperator(FilterExpression.ComparisonOperator filterOperator) {
            this.aFilterOperator = filterOperator;
            return this;
        }

        Builder addValue(LiteralValue value) {
            this.someValues.add(value);
            return this;
        }

        Builder clearValues() {
            this.someValues.clear();
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        UnaryFilterExpression build() {
            return new UnaryFilterExpression(this.aFilterOperand, this.aFilterOperator, this.someValues, this.aCtx);
        }
    }
}

