/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.sqlparser.LiteralValue;
import java.util.Objects;

class ValuesInterval
implements Comparable<ValuesInterval> {
    private LiteralValue begin;
    private LiteralValue end;
    private boolean beginBounded;
    private boolean endBounded;

    ValuesInterval(LiteralValue intervalBegins, LiteralValue intervalEnds, boolean isBoundedAtBegin, boolean isBoundedAtEnd) {
        ValuesInterval.validateInterval(intervalBegins, intervalEnds, isBoundedAtBegin, isBoundedAtEnd);
        this.begin = intervalBegins;
        this.end = intervalEnds;
        this.beginBounded = isBoundedAtBegin;
        this.endBounded = isBoundedAtEnd;
    }

    private static void validateInterval(LiteralValue intervalBegins, LiteralValue intervalEnds, boolean isBoundedAtBegin, boolean isBoundedAtEnd) {
        if (null == intervalBegins && isBoundedAtBegin) {
            throw new IllegalArgumentException("'intervalBegins' is set to minus infinity; begin cannot be bound.");
        }
        if (null == intervalEnds && isBoundedAtEnd) {
            throw new IllegalArgumentException("'intervalEnds' is set to max infinity; end cannot be bound.");
        }
        if (null != intervalBegins && null != intervalEnds) {
            if (intervalBegins.compareTo(intervalEnds) > 0) {
                throw new IllegalArgumentException("Literal 'intervalBegins' must be less or equal than literal 'intervalEnds'.");
            }
            if (intervalBegins.compareTo(intervalEnds) == 0 && isBoundedAtBegin != isBoundedAtEnd) {
                throw new IllegalArgumentException("Interval endpoints are equal - Both begin and end must be bounded or unbounded.");
            }
        }
    }

    LiteralValue getBegin() {
        return this.begin;
    }

    LiteralValue getEnd() {
        return this.end;
    }

    boolean isBeginBounded() {
        return this.beginBounded;
    }

    boolean isEndBounded() {
        return this.endBounded;
    }

    void setBegin(LiteralValue newBegin) {
        boolean tempBeginBounded = this.beginBounded;
        if (null == newBegin) {
            tempBeginBounded = false;
        }
        ValuesInterval.validateInterval(newBegin, this.end, tempBeginBounded, this.endBounded);
        this.begin = newBegin;
        this.beginBounded = tempBeginBounded;
    }

    void setEnd(LiteralValue newEnd) {
        boolean tempEndBounded = this.endBounded;
        if (null == newEnd) {
            tempEndBounded = false;
        }
        ValuesInterval.validateInterval(this.begin, newEnd, this.beginBounded, tempEndBounded);
        this.end = newEnd;
        this.endBounded = tempEndBounded;
    }

    void setBeginBounded(boolean bounded) {
        ValuesInterval.validateInterval(this.begin, this.end, bounded, this.endBounded);
        this.beginBounded = bounded;
    }

    void setEndBounded(boolean bounded) {
        ValuesInterval.validateInterval(this.begin, this.end, this.beginBounded, bounded);
        this.endBounded = bounded;
    }

    boolean includes(ValuesInterval interval) {
        boolean result = true;
        if (null != this.begin && null != this.end && null != interval.getBegin() && null != interval.getEnd()) {
            int compareLeft = this.begin.compareTo(interval.getBegin());
            int compareRight = this.end.compareTo(interval.getEnd());
            boolean bl = result = compareLeft <= 0 && compareRight >= 0;
            if (result && compareLeft == 0 && interval.isBeginBounded() != this.beginBounded && !this.beginBounded) {
                boolean bl2 = result = !result;
            }
            if (result && compareRight == 0 && this.endBounded != interval.isEndBounded() && !this.endBounded) {
                result = !result;
            }
            return result;
        }
        if (null != this.begin) {
            if (null == interval.getBegin()) {
                return false;
            }
            int compareLeft = this.begin.compareTo(interval.getBegin());
            boolean bl = result = compareLeft <= 0;
            if (result && compareLeft == 0 && this.beginBounded != interval.isBeginBounded() && !this.beginBounded) {
                boolean bl3 = result = !result;
            }
        }
        if (result && null != this.end) {
            if (null == interval.getEnd()) {
                return false;
            }
            int compareRight = this.end.compareTo(interval.getEnd());
            boolean bl = result = compareRight >= 0;
            if (result && compareRight == 0 && this.endBounded != interval.isEndBounded() && !this.endBounded) {
                result = !result;
            }
        }
        return result;
    }

    boolean collides(ValuesInterval interval) {
        boolean result;
        if (null != this.begin && null != this.end) {
            boolean result2;
            if (null == interval.getBegin() && null == interval.getEnd()) {
                return true;
            }
            if (null != interval.getBegin() && null != interval.getEnd()) {
                boolean result3;
                int compareLeft = this.begin.compareTo(interval.getEnd());
                int compareRight = this.end.compareTo(interval.getBegin());
                boolean bl = result3 = compareLeft <= 0 && compareRight >= 0;
                if (!(!result3 || compareLeft != 0 || this.beginBounded && interval.isEndBounded())) {
                    boolean bl2 = result3 = !result3;
                }
                if (!(!result3 || compareRight != 0 || this.endBounded && interval.isBeginBounded())) {
                    result3 = !result3;
                }
                return result3;
            }
            if (null == interval.getBegin()) {
                boolean result4;
                int compareLeft = this.begin.compareTo(interval.getEnd());
                boolean bl = result4 = compareLeft <= 0;
                if (!(!result4 || compareLeft != 0 || this.beginBounded && interval.isEndBounded())) {
                    result4 = !result4;
                }
                return result4;
            }
            int compareRight = this.end.compareTo(interval.getBegin());
            boolean bl = result2 = compareRight >= 0;
            if (!(!result2 || compareRight != 0 || this.endBounded && interval.isBeginBounded())) {
                result2 = !result2;
            }
            return result2;
        }
        if (null == this.begin && null == this.end) {
            return true;
        }
        if (null == this.begin) {
            boolean result5;
            if (null == interval.getBegin()) {
                return true;
            }
            int compareRight = this.end.compareTo(interval.getBegin());
            boolean bl = result5 = compareRight >= 0;
            if (!(!result5 || compareRight != 0 || this.endBounded && interval.isBeginBounded())) {
                result5 = !result5;
            }
            return result5;
        }
        if (null == interval.getEnd()) {
            return true;
        }
        int compareLeft = this.begin.compareTo(interval.getEnd());
        boolean bl = result = compareLeft <= 0;
        if (!(!result || compareLeft != 0 || this.beginBounded && interval.isEndBounded())) {
            result = !result;
        }
        return result;
    }

    @Override
    public int compareTo(ValuesInterval o) {
        if (null == this.begin && null == o.getBegin()) {
            if (null == this.end && null == o.getEnd()) {
                return 0;
            }
            if (null == this.end) {
                return 1;
            }
            if (null == o.getEnd()) {
                return -1;
            }
            if (this.end.compareTo(o.getEnd()) < 0) {
                return -1;
            }
            if (this.end.compareTo(o.getEnd()) > 0) {
                return 1;
            }
            if (this.endBounded && !o.isEndBounded()) {
                return 1;
            }
            if (!this.endBounded && o.isEndBounded()) {
                return -1;
            }
            return 0;
        }
        if (null == this.begin) {
            return -1;
        }
        if (null == o.getBegin()) {
            return 1;
        }
        if (this.begin.compareTo(o.getBegin()) < 0) {
            return -1;
        }
        if (this.begin.compareTo(o.getBegin()) > 0) {
            return 1;
        }
        if (this.beginBounded && !o.isBeginBounded()) {
            return -1;
        }
        if (!this.beginBounded && o.isBeginBounded()) {
            return 1;
        }
        if (null == this.end && null == o.getEnd()) {
            return 0;
        }
        if (null == this.end) {
            return 1;
        }
        if (null == o.getEnd()) {
            return -1;
        }
        if (this.end.compareTo(o.getEnd()) < 0) {
            return -1;
        }
        if (this.end.compareTo(o.getEnd()) > 0) {
            return 1;
        }
        if (this.endBounded && !o.isEndBounded()) {
            return 1;
        }
        if (!this.endBounded && o.isEndBounded()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValuesInterval) {
            return this.compareTo((ValuesInterval)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.begin, this.end, this.beginBounded, this.endBounded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.beginBounded) {
            sb.append("[");
        } else {
            sb.append("(");
        }
        if (null == this.begin) {
            sb.append("-Inf");
        } else {
            sb.append(this.begin);
        }
        sb.append(",");
        if (null == this.end) {
            sb.append("+Inf");
        } else {
            sb.append(this.end);
        }
        if (this.endBounded) {
            sb.append("]");
        } else {
            sb.append(")");
        }
        return sb.toString();
    }

    static LiteralValue getLeftmostBegin(ValuesInterval interval1, ValuesInterval interval2) {
        if (null == interval1.getBegin() || null == interval2.getBegin()) {
            return null;
        }
        return interval1.getBegin().compareTo(interval2.getBegin()) <= 0 ? interval1.getBegin() : interval2.getBegin();
    }

    static LiteralValue getRightmostBegin(ValuesInterval interval1, ValuesInterval interval2) {
        if (null == interval1.getBegin() && null == interval2.getBegin()) {
            return null;
        }
        if (null == interval1.getBegin()) {
            return interval2.getBegin();
        }
        if (null == interval2.getBegin()) {
            return interval1.getBegin();
        }
        return interval1.getBegin().compareTo(interval2.getBegin()) >= 0 ? interval1.getBegin() : interval2.getBegin();
    }

    static LiteralValue getLeftmostEnd(ValuesInterval interval1, ValuesInterval interval2) {
        if (null == interval1.getEnd() && null == interval2.getEnd()) {
            return null;
        }
        if (null == interval1.getEnd()) {
            return interval2.getEnd();
        }
        if (null == interval2.getEnd()) {
            return interval1.getEnd();
        }
        return interval1.getEnd().compareTo(interval2.getEnd()) <= 0 ? interval1.getEnd() : interval2.getEnd();
    }

    static LiteralValue getRightmostEnd(ValuesInterval interval1, ValuesInterval interval2) {
        if (null == interval1.getEnd() || null == interval2.getEnd()) {
            return null;
        }
        return interval1.getEnd().compareTo(interval2.getEnd()) >= 0 ? interval1.getEnd() : interval2.getEnd();
    }

    static ValuesInterval collapseIntervals(ValuesInterval interval1, ValuesInterval interval2) {
        boolean isBeginBounded;
        LiteralValue beginLiteral = ValuesInterval.getRightmostBegin(interval1, interval2);
        LiteralValue endLiteral = ValuesInterval.getLeftmostEnd(interval1, interval2);
        if (beginLiteral == interval1.getBegin() && beginLiteral == interval2.getBegin()) {
            isBeginBounded = interval1.isBeginBounded() && interval2.isBeginBounded();
        } else {
            boolean bl = isBeginBounded = beginLiteral == interval1.getBegin() ? interval1.isBeginBounded() : interval2.isBeginBounded();
        }
        boolean isEndBounded = endLiteral == interval1.getEnd() && endLiteral == interval2.getEnd() ? interval1.isEndBounded() && interval2.isEndBounded() : (endLiteral == interval1.getEnd() ? interval1.isEndBounded() : interval2.isEndBounded());
        return new ValuesInterval(beginLiteral, endLiteral, isBeginBounded, isEndBounded);
    }

    static boolean isClosedSingularPoint(ValuesInterval interval) {
        return interval.getBegin() == interval.getEnd() && interval.isBeginBounded() && interval.isEndBounded();
    }
}

