/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.univocity.parsers.conversions;

import com.ibm.cognos.jdbc.twc.univocity.parsers.common.ArgumentUtils;
import com.ibm.cognos.jdbc.twc.univocity.parsers.common.DataProcessingException;
import com.ibm.cognos.jdbc.twc.univocity.parsers.conversions.FormattedConversion;
import com.ibm.cognos.jdbc.twc.univocity.parsers.conversions.ObjectConversion;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class DateConversion
extends ObjectConversion<Date>
implements FormattedConversion<SimpleDateFormat> {
    private final SimpleDateFormat[] parsers;
    private final String[] formats;

    public DateConversion(Date valueIfStringIsNull, String valueIfObjectIsNull, String ... dateFormats) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.noNulls("Date formats", dateFormats);
        this.formats = (String[])dateFormats.clone();
        this.parsers = new SimpleDateFormat[dateFormats.length];
        for (int i = 0; i < dateFormats.length; ++i) {
            String dateFormat = dateFormats[i];
            this.parsers[i] = new SimpleDateFormat(dateFormat);
        }
    }

    public DateConversion(String ... dateFormats) {
        this((Date)null, (String)null, dateFormats);
    }

    @Override
    public String revert(Date input) {
        if (input == null) {
            return super.revert((Object)null);
        }
        return this.parsers[0].format(input);
    }

    @Override
    protected Date fromString(String input) {
        for (SimpleDateFormat formatter : this.parsers) {
            try {
                return formatter.parse(input);
            }
            catch (ParseException ex) {
            }
        }
        DataProcessingException exception = new DataProcessingException("Cannot parse '{value}' as a valid date. Supported formats are: " + Arrays.toString(this.formats));
        exception.setValue(input);
        throw exception;
    }

    public SimpleDateFormat[] getFormatterObjects() {
        return this.parsers;
    }
}

