/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.util;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import java.util.Objects;

public abstract class MetadataUtils {
    public static final int MAX_VARCHAR_PRECISION = 1024;
    public static final int DEFAULT_PRECISION = -1;
    public static final int DEFAULT_SCALE = -1;

    private static void validateType(Column.Datatype dataType, int precision, int scale, int displaySize) {
        Objects.requireNonNull(dataType, TWCMessageUtil.getMessage("0007", "dataType"));
        if (precision < -1) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0065", precision));
        }
        if (scale < -1) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0066", scale));
        }
        if (Column.Datatype.VARCHAR.equals((Object)dataType)) {
            if (scale != 0) {
                throw new IllegalArgumentException(TWCMessageUtil.getMessage("0066", precision));
            }
            if (precision > 1024 || precision != displaySize) {
                throw new IllegalArgumentException(TWCMessageUtil.getMessage("0065", precision));
            }
        }
    }

    public static String inferDatatypeName(Column.Datatype dataType, int precision, int scale, int displaySize) {
        MetadataUtils.validateType(dataType, precision, scale, displaySize);
        String baseType = dataType.value().toUpperCase();
        switch (dataType) {
            case VARCHAR: {
                if (precision == -1) {
                    throw new IllegalArgumentException(TWCMessageUtil.getMessage("0065", precision));
                }
                return baseType;
            }
            case DATE: 
            case FLOAT: 
            case INTEGER: 
            case SMALLINT: 
            case BIGINT: 
            case BOOLEAN: 
            case NULL: {
                return baseType;
            }
        }
        throw new IllegalArgumentException(TWCMessageUtil.getMessage("0015", baseType));
    }

    public static int inferDatatypeAsJDBC(Column.Datatype dataType) {
        Objects.requireNonNull(dataType, TWCMessageUtil.getMessage("0007", "dataType"));
        String baseType = dataType.value().toUpperCase();
        switch (dataType) {
            case VARCHAR: {
                return 12;
            }
            case DATE: {
                return 91;
            }
            case FLOAT: {
                return 8;
            }
            case INTEGER: {
                return 4;
            }
            case SMALLINT: {
                return 5;
            }
            case BIGINT: {
                return -5;
            }
            case BOOLEAN: {
                return 16;
            }
            case NULL: {
                return 0;
            }
        }
        throw new IllegalArgumentException(TWCMessageUtil.getMessage("0015", baseType));
    }

    public static String convertSupportedSQLTypeToString(int sqlType) {
        switch (sqlType) {
            case 12: {
                return Column.Datatype.VARCHAR.value().toUpperCase();
            }
            case 4: {
                return Column.Datatype.INTEGER.value().toUpperCase();
            }
            case 91: {
                return Column.Datatype.DATE.value().toUpperCase();
            }
            case 8: {
                return Column.Datatype.FLOAT.value().toUpperCase();
            }
            case 0: {
                return Column.Datatype.NULL.value().toUpperCase();
            }
        }
        throw new IllegalArgumentException(TWCMessageUtil.getMessage("0015", sqlType));
    }
}

