/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.ibm.cognos.internal.hts.fragment.context.UsvFragmentContextImpl;
import com.ibm.cognos.internal.hts.fragment.context.UsvPipelineContext;
import com.ibm.cognos.internal.hts.fragment.stage.TaskListInteractionStage;
import com.ibm.cognos.internal.hts.fragment.utils.MenuState;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.GetTasksWhereClause;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSFolder;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FilterBuilder {
    private ServiceLogger m_logger;
    private MenuState m_menuState;
    private String m_name;
    private UsvPipelineContext m_context;
    private Map<String, String> m_statusMappings = new HashMap<String, String>();

    public FilterBuilder(String name, StageContext context, MenuState menuState, ServiceLogger logger) {
        this.m_name = name;
        this.m_context = new UsvFragmentContextImpl(context);
        this.m_logger = logger;
        this.m_menuState = menuState;
    }

    public void addStatusMapping(TaskListInteractionStage.STATUS status, TStatus.Enum beplStatus) {
        if (!this.m_statusMappings.containsKey((Object)status)) {
            this.m_statusMappings.put(status.toString(), beplStatus.toString());
        }
    }

    public String generateFilterString() throws PipelineException {
        StringBuffer buf = new StringBuffer();
        try {
            String user = this.m_menuState.getOwner();
            if (user != null && user.equals("MY_TASKS")) {
                String ownerFilter = "Task.ActualOwner=" + GetTasksWhereClause.decodeWhereClauseToken((String)"@@CURRENT_USER@@");
                buf.append(ownerFilter);
            }
            this.appendDateFilter(buf);
            this.appendFilterValue(buf, this.m_menuState.getPriority(), "Task.Priority");
            this.appendFilterValue(buf, this.m_menuState.getTaskType(), "Task.Type");
            this.appendFilterValue(buf, this.m_menuState.getStatus(), "Task.Status");
            List<String> customFolders = this.m_menuState.getCustomFolders();
            if (customFolders.isEmpty()) {
                this.appendFolderFilter(buf, this.m_menuState.getFolderName());
            } else {
                this.appendCustomFoldersFilter(buf, customFolders);
            }
        }
        catch (HumanTaskServiceException ex) {
            if (this.m_logger != null && this.m_logger.isErrorEnabled()) {
                this.m_logger.error("Process '" + this.m_name + "' failed to execute", (Throwable)ex);
            }
            throw new PipelineException("could not read inputs", (Throwable)ex);
        }
        return buf.toString();
    }

    public String getTaskType() throws PipelineException {
        String type = this.getJSONParameterValue("Task.Type");
        if (type == null) {
            type = "ALL";
        }
        return type;
    }

    private void appendDateFilter(StringBuffer buf) throws PipelineException {
        String dateStyle = this.getDateStyle();
        if (dateStyle.equals("Task.DueDate")) {
            this.appendFilterValue(buf, this.m_menuState.getDueDate(), "Task.DueDate");
        } else {
            this.appendFilterValue(buf, this.m_menuState.getCreateDate(), "Task.CreateDate");
        }
    }

    private String getDateStyle() throws PipelineException {
        String dateStyle = this.getJSONParameterValue("dateStyle");
        if (dateStyle == null) {
            dateStyle = "Task.CreateDate";
        }
        return dateStyle;
    }

    private void appendCustomFoldersFilter(StringBuffer buf, List<String> customFolders) {
        if (buf.length() > 0) {
            buf.append(" AND ");
        }
        buf.append("Task.folderName");
        buf.append(" IN (");
        Iterator<String> it = customFolders.iterator();
        while (it.hasNext()) {
            String customFolder = it.next();
            buf.append(customFolder);
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        buf.append(")");
    }

    private void appendFolderFilter(StringBuffer buf, String folderName) throws PipelineException {
        if (folderName != null) {
            folderName = folderName.toUpperCase();
            if (buf.length() > 0) {
                buf.append(" AND ");
            }
            buf.append("Task.folderName");
            buf.append("=");
            buf.append(folderName);
        } else {
            if (buf.length() > 0) {
                buf.append(" AND ");
            }
            buf.append("Task.folderName");
            buf.append("=");
            buf.append(HTSFolder.UI_FOLDERS.INBOX);
        }
        try {
            if (buf.length() > 0) {
                buf.append(" AND ");
            }
            buf.append("Task.folderUser");
            buf.append("=");
            String cam_id = this.m_context.getEnv().getUserID();
            if (cam_id.equals("__unknown__")) {
                cam_id = "CAMID(\"::Anonymous\")";
            }
            buf.append(GetTasksWhereClause.encodeWhereClauseToken((String)cam_id));
        }
        catch (HumanTaskServiceException ex) {
            if (this.m_logger != null && this.m_logger.isErrorEnabled()) {
                this.m_logger.error("Process '" + this.m_name + "' failed to execute", (Throwable)ex);
            }
            throw new PipelineException("could not read inputs", (Throwable)ex);
        }
    }

    private void appendFilterValue(StringBuffer buf, String paramValue, String transientParamName) throws PipelineException {
        if (paramValue != null && paramValue != null && !paramValue.equals("ALL")) {
            if (transientParamName.equals("Task.Status") && this.m_statusMappings.containsKey(paramValue)) {
                paramValue = this.m_statusMappings.get(paramValue);
            }
            if (buf.length() > 0) {
                buf.append(" AND ");
            }
            buf.append(transientParamName);
            if (transientParamName.equals("Task.DueDate") || transientParamName.equals("Task.CreateDate")) {
                long current = System.currentTimeMillis();
                long filterDate = Long.parseLong(paramValue);
                buf.append(" >=");
                buf.append(Math.min(current, filterDate));
                buf.append(" AND ");
                buf.append(transientParamName);
                buf.append(" <=");
                buf.append(Math.max(current, filterDate));
            } else {
                buf.append("=");
                buf.append(paramValue);
            }
        }
    }

    private String getJSONParameterValue(String transientParamName) throws PipelineException {
        String paramValue = null;
        try {
            String transientParamValue = this.m_context.getParameterValue(transientParamName);
            if (transientParamValue != null && transientParamValue.length() > 0) {
                JSONObject json = JSONObject.parse((String)transientParamValue);
                paramValue = json.get((Object)"value").toString();
            }
        }
        catch (IOException ex) {
            if (this.m_logger != null && this.m_logger.isErrorEnabled()) {
                this.m_logger.error("Process '" + this.m_name + "' failed to execute", (Throwable)ex);
            }
            throw new PipelineException("could not read inputs", (Throwable)ex);
        }
        return paramValue;
    }
}

