/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.ports;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.ibm.cognos.internal.hts.fragment.context.UsvPipelineContext;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;

public class BasePort {
    private UsvPipelineContext m_context;
    private String m_stageName;
    private ServiceLogger m_logger;

    public BasePort(UsvPipelineContext context, String stageName, ServiceLogger logger) {
        this.m_context = context;
        this.m_stageName = stageName;
        this.m_logger = logger;
    }

    public UsvPipelineContext getContext() {
        return this.m_context;
    }

    public String getStageName() {
        return this.m_stageName;
    }

    public ServiceLogger getLogger() {
        return this.m_logger;
    }

    protected void sendServerRequest(SOAPMessage soapMessage, SOAPConnection connection, String url) throws PipelineException {
        try {
            connection.execute(soapMessage, url);
        }
        catch (MalformedURLException e) {
            this.handleBadURL(e);
        }
        catch (SOAPFault e) {
            this.handleSOAPFault(e);
        }
        catch (IOException e) {
            this.handleBadIO(e);
        }
        catch (XMLStreamException e) {
            this.handleBadXML(e);
        }
    }

    public static String getWrappedServiceResponse(ServiceResponse response) throws PipelineException {
        String result = "";
        result = response != null ? BasePort.getWrappedServiceResponse(response.toString()) : BasePort.getWrappedServiceResponse("");
        return result;
    }

    public static String getWrappedServiceResponse(String serviceResponse) throws PipelineException {
        StringWriter writer = new StringWriter();
        writer.write("<queryResponse>");
        if (serviceResponse != null) {
            writer.write(serviceResponse);
        } else {
            writer.write("");
        }
        writer.write("</queryResponse>");
        return writer.toString();
    }

    private void handleBadXML(XMLStreamException e) throws PipelineException {
        if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
            this.getLogger().error("Encountered an xml stream exception while retrieving the object from cm.", (Throwable)e);
        }
        throw new PipelineException("pf.pipeline.process.xml.error", (Object[])new String[]{this.getStageName()}, (Throwable)e);
    }

    private void handleBadIO(IOException e) throws PipelineException {
        if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
            this.getLogger().error("Encountered an IO exception while retrieving the object from cm.", (Throwable)e);
        }
        throw new PipelineException("pf.pipeline.process.io.error", (Object[])new String[]{this.getStageName()}, (Throwable)e);
    }

    private void handleSOAPFault(SOAPFault e) throws PipelineException {
        String detail = e.getDetail();
        if (detail != null && (detail.indexOf("CM-REQ-4159") != -1 || detail.indexOf("CM-REQ-4342") != -1) || detail.indexOf("HTS-GEN-0085") != -1) {
            throw new InvalidCredentialsFault("pf.fragment.server.invalidcredentials", null, null);
        }
        if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
            this.getLogger().error("Content Manager returned a fault in the response.", (Throwable)e);
        }
        if (detail != null && detail.indexOf("HTS-GEN-0086") != 1 && "true".equals(this.m_context.getEnv().getSessionParameter("e_isImpersonating"))) {
            String nativeTenantID = this.m_context.getEnv().getSessionParameter("e_tenantID");
            String readTenantID = this.m_context.getEnv().getSessionParameter("e_readTenantID");
            if (readTenantID != null && !readTenantID.equals(nativeTenantID)) {
                throw new PipelineException(I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_US_INACCESSIBLE_USER_DATA_IMPERSONATE, (Locale)new Locale(this.m_context.getEnv().getProductLocale())), (Throwable)e);
            }
        }
        throw new PipelineException("pf.pipeline.process.error", (Object[])new String[]{this.getStageName()});
    }

    private void handleBadURL(MalformedURLException e) throws PipelineException {
        if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
            this.getLogger().error("bad url.", (Throwable)e);
        }
        throw new PipelineException("pf.pipeline.process.error", (Object[])new String[]{this.getStageName()}, (Throwable)e);
    }
}

