/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.jsmcommon.util.StringUtil;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.ActionUtils;
import com.ibm.cognos.internal.hts.fragment.utils.ParamUtils;
import com.ibm.cognos.internal.hts.fragment.utils.Utils;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.status.MenuManagement;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetTaskDescriptionDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetTaskInfoDocument;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public abstract class AbstractViewerInteractionStage
extends BaseInteractionStage {
    private static final String[] CAPABILITIES = new String[]{"complete", "delegate", "claim", "skip", "updateTaskDetails"};
    protected ServiceLogger _logger;

    public AbstractViewerInteractionStage(ServiceLogger logger) {
        super(logger);
        this._logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        this.handleTaskInfoResponse(context);
    }

    protected abstract void addResponseToOutput(String var1, StageContext var2) throws PipelineException;

    protected abstract String getTaskId(StageContext var1) throws PipelineException;

    protected void handleTaskInfoResponse(StageContext context) throws PipelineException {
        String response = "";
        try {
            String id = this.getTaskId(context);
            if (ParamUtils.isValid(id)) {
                this.addParameter(context, "taskid", id);
                HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
                response = this.buildTaskInfoResponse(humanTaskPort, id, context);
                this.addResponseToOutput(response, context);
            }
        }
        catch (HumanTaskServiceException e) {
            if (this._logger != null && this._logger.isErrorEnabled()) {
                this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
            }
            throw new PipelineException("Unable to process request: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            if (this._logger != null && this._logger.isErrorEnabled()) {
                this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
            }
            throw new PipelineException("could not read inputs", (Throwable)e);
        }
    }

    public boolean canShare() {
        return false;
    }

    private String buildTaskInfoResponse(HumanTaskServicePort humanTaskPort, String id, StageContext context) throws HumanTaskServiceException, PipelineException {
        StringBuffer response = new StringBuffer();
        GetTaskInfoDocument getTaskInfoDocument = GetTaskInfoDocument.Factory.newInstance();
        GetTaskInfoDocument.GetTaskInfo getTaskInfo = getTaskInfoDocument.addNewGetTaskInfo();
        getTaskInfo.setIdentifier(id);
        ServiceResponse actionResponse = new ServiceResponse();
        ActionUtils.handleAction(humanTaskPort, actionResponse, context.getInteractionParams(), this._logger);
        ServiceResponse getTaskInfoResponse = new ServiceResponse();
        humanTaskPort.getTaskInfo(getTaskInfoDocument, getTaskInfoResponse);
        response.append(this.formatResponse(getTaskInfoResponse.toString(), context));
        response.append(this.getDescription(context, id));
        return response.toString();
    }

    private String formatResponse(String strhumanTaskServiceResponse, StageContext context) {
        String formattedResponse;
        block4: {
            formattedResponse = strhumanTaskServiceResponse;
            StringReader xmlStringReader = null;
            SAXReader saxReader = null;
            Document document = null;
            Element task = null;
            Element rootElement = null;
            Node childNode = null;
            String strFormattedValue = "";
            try {
                xmlStringReader = new StringReader(strhumanTaskServiceResponse);
                saxReader = new SAXReader();
                document = saxReader.read((Reader)xmlStringReader);
                rootElement = document.getRootElement();
                if (rootElement != null) {
                    Iterator iterator = rootElement.elementIterator("task");
                    while (iterator.hasNext()) {
                        task = (Element)iterator.next();
                        if (task == null) continue;
                        childNode = task.selectSingleNode("./*[local-name()='createdOn']");
                        strFormattedValue = Utils.instance().getFormattedDate(childNode, context, this._logger);
                        task.addElement("formattedCreatedOn").addText(strFormattedValue);
                        childNode = task.selectSingleNode("./*[local-name()='activationTime']");
                        strFormattedValue = Utils.instance().getFormattedDate(childNode, context, this._logger);
                        task.addElement("formattedActivationTime").addText(strFormattedValue);
                        childNode = task.selectSingleNode("./*[local-name()='expirationTime']");
                        strFormattedValue = Utils.instance().getFormattedDate(childNode, context, this._logger);
                        task.addElement("formattedExpirationTime").addText(strFormattedValue);
                        this.formatDeadlines(context, task);
                        List<HTSRole.Roles> roles = Utils.instance().getRolesForTask(task, context);
                        TStatus.Enum status = TStatus.Enum.forString((String)Utils.instance().getTaskProperty(task, "status"));
                        HTSTask.TYPE type = HTSTask.TYPE.valueOf((String)Utils.instance().getTaskProperty(task, "taskType"));
                        this.appendMenusToShow(task, context, roles, status, type);
                        Utils.instance().appendMethodCapabilities(task, context, roles, status, type, CAPABILITIES);
                    }
                    formattedResponse = rootElement.asXML();
                }
            }
            catch (Exception ex) {
                formattedResponse = strhumanTaskServiceResponse;
                if (this._logger == null || !this._logger.isErrorEnabled()) break block4;
                this._logger.error(" " + this.getName() + " : There was an ERROR formating the user service response.", (Throwable)ex);
            }
        }
        return formattedResponse;
    }

    private void formatDeadlines(StageContext context, Element task) {
        List deadlineInstances = task.selectNodes("./*[local-name()='deadlines']/*[local-name()='deadlineInstance']");
        Element formattedDeadlinesElement = null;
        int cnt = 1;
        for (Node deadlineInstance : deadlineInstances) {
            String typeStr = deadlineInstance.selectSingleNode("./*[local-name()='type']").getStringValue();
            String dateStr = Utils.instance().getFormattedDate(deadlineInstance.selectSingleNode("./*[local-name()='date']"), context, this._logger);
            String formattedDateForDatePicker = Utils.instance().getFormattedDateForDatePicker(deadlineInstance.selectSingleNode("./*[local-name()='date']"), context, this._logger);
            if (cnt == 1) {
                formattedDeadlinesElement = task.addElement("formattedDeadlines");
            }
            ++cnt;
            Element deadlineInstanceElement = formattedDeadlinesElement.addElement("deadlineInstance");
            deadlineInstanceElement.addElement("date").addText(dateStr);
            deadlineInstanceElement.addElement("type").addText(typeStr);
            deadlineInstanceElement.addElement("formattedDateForDatePicker").addText(formattedDateForDatePicker);
        }
    }

    private String getDescription(StageContext context, String taskId) throws PipelineException {
        StringBuffer buf = new StringBuffer("<presentationDescription>");
        String desc = this.getDescription(context, taskId, "text/html");
        if (desc == null && (desc = this.getDescription(context, taskId, "text/plain")) != null) {
            desc = StringUtil.replace((String)desc, (String)"\n", (String)"<br/>");
            desc = StringUtil.replace((String)desc, (String)"'", (String)"\\'");
        }
        if (desc != null) {
            buf.append(desc);
        }
        buf.append("</presentationDescription>");
        return buf.toString();
    }

    private String getDescription(StageContext context, String taskId, String contentType) throws PipelineException {
        GetTaskDescriptionDocument gtdd = GetTaskDescriptionDocument.Factory.newInstance();
        gtdd.addNewGetTaskDescription().setIdentifier(taskId);
        if (contentType != null && !contentType.equals("")) {
            gtdd.getGetTaskDescription().setContentType(contentType);
        }
        HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
        DescriptionResponseHandler descriptionResponse = new DescriptionResponseHandler();
        humanTaskPort.getTaskDescription(gtdd, descriptionResponse);
        String desc = null;
        if (descriptionResponse.hasDescription()) {
            desc = descriptionResponse.toString();
        }
        return desc;
    }

    private void appendMenusToShow(Element taskAbstract, StageContext context, List<HTSRole.Roles> roles, TStatus.Enum status, HTSTask.TYPE type) throws HumanTaskServiceException {
        MenuManagement menuManagement = new MenuManagement(roles.toArray(new HTSRole.Roles[0]), status, type);
        Map operations = menuManagement.getOperationList();
        HTSSDKUtils.buildMenus((Element)taskAbstract, (Map)operations);
    }

    private class DescriptionResponseHandler
    implements IXMLHandler {
        private StringBuffer m_description = new StringBuffer();

        private DescriptionResponseHandler() {
        }

        public void handle(XMLStreamReader reader) throws XMLStreamException {
            StringWriter stringWriter = new StringWriter();
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter((Writer)stringWriter);
            try {
                StaxUtils.moveToElement((String)"description", (XMLStreamReader)reader);
                StaxUtils.copyCurrentElement((XMLStreamReader)reader, (XMLStreamWriter)xsw);
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
            this.m_description.append(stringWriter.getBuffer());
        }

        public String toString() {
            return this.m_description.toString();
        }

        public boolean hasDescription() {
            return !"".equals(this.m_description.toString().trim());
        }
    }
}

