/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.DomResponseHandler;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.ActionUtils;
import com.ibm.cognos.internal.hts.fragment.utils.ParamUtils;
import java.io.IOException;
import org.apache.xmlbeans.XmlException;

public class AcknowledgeRenderingInteractionStage
extends BaseInteractionStage {
    private ServiceLogger _logger;

    public AcknowledgeRenderingInteractionStage(ServiceLogger logger) {
        super(logger);
        this._logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        if (outputName != null) {
            try {
                String id = ParamUtils.validate(context.getInteractionParams(), "taskid", this._logger);
                if (ParamUtils.isValid(id)) {
                    HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
                    String action = ParamUtils.validate(context.getInteractionParams(), "action", this._logger);
                    if ("completeNotification".equals(action)) {
                        ServiceResponse serviceResponse = new ServiceResponse();
                        ActionUtils.handleAction(humanTaskPort, serviceResponse, context.getInteractionParams(), this._logger);
                    }
                    DomResponseHandler responseHandler = new DomResponseHandler("manualTask");
                    humanTaskPort.getInput(id, responseHandler);
                    this.processInputMessage(id, context, responseHandler);
                }
            }
            catch (Exception e) {
                if (this._logger != null && this._logger.isErrorEnabled()) {
                    this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                throw new PipelineException("could not read inputs", (Throwable)e);
            }
        }
    }

    public boolean canShare() {
        return false;
    }

    private void processInputMessage(String id, StageContext context, DomResponseHandler responseHandler) throws PipelineException, IOException, XmlException {
        StringBuffer outputBuffer = new StringBuffer();
        outputBuffer.append("<queryResponse>");
        outputBuffer.append(responseHandler.toString());
        outputBuffer.append("</queryResponse>");
        String outputName = this.getOutputName(context);
        IPipelineOutput pOutput = this.getOutput(outputBuffer.toString());
        context.addOutput(outputName, pOutput);
    }
}

