/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.DomResponseHandler;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.ActionUtils;
import com.ibm.cognos.internal.hts.fragment.utils.ParamUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetTaskInfoDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetTaskInfoResponseDocument;
import java.io.IOException;
import org.apache.xmlbeans.XmlException;

public class ApproveRenderingInteractionStage
extends BaseInteractionStage {
    private ServiceLogger _logger;

    public ApproveRenderingInteractionStage(ServiceLogger logger) {
        super(logger);
        this._logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        if (outputName != null) {
            try {
                String id = ParamUtils.validate(context.getInteractionParams(), "taskid", this._logger);
                if (ParamUtils.isValid(id)) {
                    String action = ParamUtils.validate(context.getInteractionParams(), "action", this._logger);
                    if ("complete".equals(action)) {
                        this.doComplete(context);
                    }
                    this.createGetInputOutput(id, context);
                }
            }
            catch (Exception e) {
                if (this._logger != null && this._logger.isErrorEnabled()) {
                    this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                throw new PipelineException("could not read inputs", (Throwable)e);
            }
        }
    }

    public boolean canShare() {
        return false;
    }

    private void doComplete(StageContext context) throws PipelineException {
        HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
        ActionUtils.handleAction(humanTaskPort, null, context.getInteractionParams(), this._logger);
    }

    private void createGetInputOutput(String id, StageContext context) throws PipelineException, IOException, XmlException {
        HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
        GetTaskInfoDocument getTaskInfoDocument = GetTaskInfoDocument.Factory.newInstance();
        GetTaskInfoDocument.GetTaskInfo getTaskInfo = getTaskInfoDocument.addNewGetTaskInfo();
        getTaskInfo.setIdentifier(id);
        ServiceResponse getTaskInfoHandler = new ServiceResponse();
        humanTaskPort.getTaskInfo(getTaskInfoDocument, getTaskInfoHandler);
        GetTaskInfoResponseDocument response = GetTaskInfoResponseDocument.Factory.parse((String)getTaskInfoHandler.toString());
        StringBuffer responseBuffer = new StringBuffer();
        String input = "";
        DomResponseHandler responseHandler = new DomResponseHandler("manualTask");
        humanTaskPort.getInput(id, responseHandler);
        input = responseHandler.toString();
        responseBuffer.append("<queryResponse>");
        responseBuffer.append(input);
        this.appendGetOutputResponse(response, responseBuffer, humanTaskPort);
        responseBuffer.append("</queryResponse>");
        String outputName = this.getOutputName(context);
        IPipelineOutput pOutput = this.getOutput(responseBuffer.toString());
        context.addOutput(outputName, pOutput);
    }
}

