/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameter;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.DomResponseHandler;
import com.ibm.cognos.internal.hts.fragment.utils.ParamUtils;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.status.StateManagement;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import com.ibm.cognos.internal.hts.ws_ht.api.TTask;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetTaskInfoResponseDocument;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.exolab.castor.xml.Marshaller;

public abstract class BaseInteractionStage
extends Stage {
    public static final String TRANSIENT_TASK_CHANGED = "cognosTaskChanged";
    public static final String TRANSIENT_PAYLOAD_URI = "payload_uri";
    public static final String CURRENT_USER_MARKER = "@@CURRENT_USER@@";

    public BaseInteractionStage(ServiceLogger logger) {
        super(logger);
    }

    protected Marshaller getMarshaller(StringWriter writer) throws HumanTaskServiceException {
        try {
            Marshaller marshaller = new Marshaller((Writer)writer);
            marshaller.setMarshalAsDocument(false);
            return marshaller;
        }
        catch (IOException e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_SERVICE_MARSHALL_ERROR, new Object[]{e});
        }
    }

    protected void appendGetOutputResponse(GetTaskInfoResponseDocument response, StringBuffer responseBuffer, HumanTaskServicePort humanTaskPort) throws PipelineException {
        TStatus.Enum status;
        TStatus.Enum enum_ = status = response.getGetTaskInfoResponse().getTask() != null ? response.getGetTaskInfoResponse().getTask().getStatus() : null;
        if (status == TStatus.COMPLETED) {
            TTask task = response.getGetTaskInfoResponse().getTask();
            try {
                List roles = HTSSDKUtils.getRolesForTask((XmlObject)response);
                HTSTask.TYPE taskType = HTSTask.TYPE.valueOf((String)response.getGetTaskInfoResponse().getTask().getTaskType());
                new StateManagement("getOutput", roles.toArray(new HTSRole.Roles[0]), status, taskType, null);
                DomResponseHandler serviceResponseHandler = new DomResponseHandler();
                humanTaskPort.getOutput(task.getId(), serviceResponseHandler);
                String output = serviceResponseHandler.getXML("./*[local-name()='getOutputResponse']/*[local-name()='taskData']/*");
                responseBuffer.append(output);
            }
            catch (HumanTaskServiceException humanTaskServiceException) {
                // empty catch block
            }
        }
        if (status == TStatus.ERROR || status == TStatus.COMPLETED || status == TStatus.SUSPENDED || status == TStatus.EXITED || status == TStatus.FAILED || status == TStatus.OBSOLETE) {
            responseBuffer.append("<hideRendering/>");
        }
    }

    protected String getOutputName(StageContext context) {
        String id;
        Enumeration outputNames = context.getOutputNamesEnumeration();
        String outputName = null;
        if (outputNames != null && outputNames.hasMoreElements()) {
            outputName = (String)outputNames.nextElement();
        }
        if ((id = context.getEnv().getUserID()).equals("__unknown__")) {
            id = "CAMID(\"::Anonymous\")";
        }
        String name = context.getEnv().getUserName();
        this.addParameter(context, "user_id", EncodingUtils.javascriptencode((String)id));
        this.addParameter(context, "user_name", EncodingUtils.javascriptencode((String)name));
        return outputName;
    }

    protected void addParameter(StageContext context, String name, String value) {
        if (!ParamUtils.paramExists(context.getInteractionParams(), name)) {
            context.getInteractionParams().addParameter(name, value);
        } else {
            XMLParameter param = context.getInteractionParams().getXMLParameter(name);
            if (!param.getValue().equals(value)) {
                param.setValue(value);
            }
        }
    }

    protected IPipelineOutput getOutput(String outputString) throws IOException, PipelineException {
        IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
        output.getWriter().write(outputString);
        output.getWriter().flush();
        output.getWriter().close();
        return output;
    }

    protected void doTransientUpdate(String name, String value, StageContext context) {
        Fragment f = context.getFragment();
        Fragment.TransientUpdate tu = new Fragment.TransientUpdate(f);
        tu.setName(name);
        tu.setValue(value);
        tu.setScope("application");
        f.addTransientUpdate(tu);
    }

    protected String getTransient(StageContext context, String key) {
        XMLParameters transients = context.getTransientParams();
        return transients.getValue(key);
    }

    protected boolean hasTransient(StageContext context, String key) {
        boolean hasTransient = false;
        String param = this.getTransient(context, key);
        hasTransient = param != null && param.length() > 0;
        return hasTransient;
    }
}

