/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.FragmentInstance;
import com.cognos.portal.schemas.fragments.Params;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.stream.StaxUtils;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class BuildSubFragment
extends BaseInteractionStage {
    private ServiceLogger _logger;

    public BuildSubFragment(ServiceLogger logger) {
        super(logger);
        this._logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        if (outputName != null) {
            try {
                Element rootElement = this.getRootElement(context, "subFragParams");
                String subFrag = this.getSubFragParam(rootElement, "subfrag");
                String id = this.getSubFragParam(rootElement, "id");
                this.setSubfragment(context, id, subFrag);
                String response = "<queryResponse>" + subFrag + "</queryResponse>";
                IPipelineOutput output = this.getOutput(response);
                context.addOutput(outputName, output);
            }
            catch (Exception e) {
                if (this._logger != null && this._logger.isErrorEnabled()) {
                    this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                throw new PipelineException("could not read inputs", (Throwable)e);
            }
        }
    }

    private void setSubfragment(StageContext context, String id, String subFrag) throws PipelineException, XMLStreamException, DocumentException {
        Fragment fragment = context.getFragment();
        FragmentInstance fragmentInstance = new FragmentInstance();
        fragmentInstance.setId(id);
        fragmentInstance.setHref(subFrag);
        Params custom = this.getParams(context, "custom");
        if (custom != null) {
            fragmentInstance.setCustom(custom);
        }
        fragment.addSubfragment(fragmentInstance);
    }

    private Params getParams(StageContext context, String paramName) throws PipelineException, DocumentException, XMLStreamException {
        XMLStreamReader xsr = context.getInputAsXMLStreamReader(paramName);
        xsr.nextTag();
        Params params = new Params();
        params.read(xsr);
        return params;
    }

    private String getSubFragParam(Element rootElement, String param) {
        String value = "";
        Node node = rootElement.selectSingleNode("//param[@name='" + param + "']");
        if (node != null) {
            value = node.getStringValue();
        }
        return value;
    }

    private Element getRootElement(StageContext context, String param) throws DocumentException, PipelineException, XMLStreamException {
        StringBuffer sb = new StringBuffer();
        StaxUtils.toString((XMLStreamReader)context.getInputAsXMLStreamReader(param), (StringBuffer)sb);
        StringReader xmlStringReader = new StringReader(sb.toString());
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((Reader)xmlStringReader);
        return document.getRootElement();
    }

    public boolean canShare() {
        return false;
    }
}

