/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.ibm.cognos.internal.hts.fragment.context.UsvFragmentContextImpl;
import com.ibm.cognos.internal.hts.fragment.ports.BasePort;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.AbstractViewerInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.Utils;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TComment;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.CommentType;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetCommentsByTypeDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetCommentsByTypeGroup;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetCommentsByTypeResponseDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.AddCommentDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetCommentsDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetCommentsResponseDocument;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.dom4j.Element;
import org.dom4j.Node;

public class CommentViewerInteractionStage
extends AbstractViewerInteractionStage {
    private String m_taskID;
    private Map<String, CommentType.Enum[]> m_commentTypes = new HashMap<String, CommentType.Enum[]>();

    public CommentViewerInteractionStage(ServiceLogger logger) {
        super(logger);
        this.m_commentTypes.put("USER_COMMENTS", new CommentType.Enum[]{CommentType.USER});
        this.m_commentTypes.put("AUDIT_COMMENTS", new CommentType.Enum[]{CommentType.AUDIT});
        this.m_commentTypes.put("ALL_COMMENTS", new CommentType.Enum[]{CommentType.USER, CommentType.AUDIT});
    }

    @Override
    protected void addResponseToOutput(String taskInfoResponse, StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        StringBuffer response = new StringBuffer();
        if (outputName != null) {
            String userID = context.getEnv().getUserID();
            if (this.m_taskID == null || "".equals(this.m_taskID)) {
                this.m_taskID = this.getTaskId(context);
            }
            XMLParameters interactionParams = context.getInteractionParams();
            String action = interactionParams.getValue("action");
            response.append(taskInfoResponse);
            if (action != null && action.equals("addComment")) {
                response.append(this.addCommentsResponse(context, userID, interactionParams.getValue("comment")));
            }
            if (this.m_taskID != null && this.m_taskID.length() > 0) {
                response.append(this.getCommentsResponse(context, userID));
            }
            try {
                String queryResponse = BasePort.getWrappedServiceResponse(response.toString());
                IPipelineOutput output = this.getOutput(queryResponse);
                context.addOutput(outputName, output);
            }
            catch (IOException e) {
                if (this._logger != null && this._logger.isErrorEnabled()) {
                    this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                throw new PipelineException("could not read inputs", (Throwable)e);
            }
        }
    }

    private String getCommentsResponse(StageContext context, String userID) throws PipelineException {
        String commentType = this.getParameterValue("Task.Comments", context);
        GetCommentsByTypeDocument taskCommentsRequest = null;
        GetCommentsDocument getCommentsRequest = null;
        String humanTaskResponse = "";
        HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
        ServiceResponse humanTaskServiceResponse = new ServiceResponse();
        if (commentType != null && commentType.equalsIgnoreCase("ALL_COMMENTS")) {
            getCommentsRequest = GetCommentsDocument.Factory.newInstance();
            getCommentsRequest.addNewGetComments().setIdentifier(this.m_taskID);
            humanTaskPort.getComments(getCommentsRequest, humanTaskServiceResponse);
            humanTaskResponse = this.formatGetCommentsResponse(context, humanTaskServiceResponse);
        } else {
            taskCommentsRequest = GetCommentsByTypeDocument.Factory.newInstance();
            taskCommentsRequest.addNewGetCommentsByType();
            taskCommentsRequest.getGetCommentsByType().setIdentifier(this.m_taskID);
            if (commentType != null) {
                taskCommentsRequest.getGetCommentsByType().setCommentTypeArray(this.m_commentTypes.get(commentType));
            } else {
                taskCommentsRequest.getGetCommentsByType().setCommentTypeArray(this.m_commentTypes.get("USER_COMMENTS"));
            }
            humanTaskPort.getCommentsByType(taskCommentsRequest, humanTaskServiceResponse);
            humanTaskResponse = this.formatGetCommentsByTypeResponse(context, humanTaskServiceResponse);
        }
        return humanTaskResponse.toString();
    }

    private String formatGetCommentsResponse(StageContext context, ServiceResponse humanTaskServiceResponse) {
        String humanTaskResponse;
        block5: {
            humanTaskResponse = humanTaskServiceResponse.toString();
            try {
                GetCommentsResponseDocument responseDoc = GetCommentsResponseDocument.Factory.parse((String)humanTaskResponse);
                Element rootElement = HTSSDKUtils.marshallAPIObjectToElement((Object)responseDoc);
                TComment[] tComments = responseDoc.getGetCommentsResponse().getCommentArray();
                TComment comment = null;
                for (int i = 0; i < tComments.length; ++i) {
                    comment = tComments[i];
                    String dateText = Utils.instance().getFormattedDate(comment.getAddedAt().toString(), context, this._logger);
                    int commentIndex = i + 1;
                    String addedAtXpath = "/*[local-name()='getCommentsResponse']/*[local-name()='comment'][" + commentIndex + "]/*[local-name()='addedAt']";
                    Node addedAt = rootElement.selectSingleNode(addedAtXpath);
                    addedAt.setText(dateText);
                }
                humanTaskResponse = rootElement.asXML();
            }
            catch (XmlException e) {
                if (this._logger != null && this._logger.isInfoEnabled()) {
                    this._logger.info("Process '" + this.getName() + "' was unable to localise comments: " + e.getLocalizedMessage());
                }
            }
            catch (Exception e) {
                if (this._logger == null || !this._logger.isInfoEnabled()) break block5;
                this._logger.info("Process '" + this.getName() + "' was unable to localise comments: " + e.getLocalizedMessage());
            }
        }
        return humanTaskResponse;
    }

    private String formatGetCommentsByTypeResponse(StageContext context, ServiceResponse humanTaskServiceResponse) {
        String humanTaskResponse;
        block6: {
            humanTaskResponse = humanTaskServiceResponse.toString();
            try {
                GetCommentsByTypeResponseDocument responseDoc = GetCommentsByTypeResponseDocument.Factory.parse((String)humanTaskResponse);
                Element rootElement = HTSSDKUtils.marshallAPIObjectToElement((Object)responseDoc);
                GetCommentsByTypeGroup[] commentsGroup = responseDoc.getGetCommentsByTypeResponse().getGetCommentsByTypeGroupArray();
                for (int i = 0; i < commentsGroup.length; ++i) {
                    TComment[] comment = commentsGroup[i].getCommentArray();
                    for (int j = 0; j < comment.length; ++j) {
                        String dateText = Utils.instance().getFormattedDate(comment[j].getAddedAt().toString(), context, this._logger);
                        int groupIndex = i + 1;
                        int commentIndex = j + 1;
                        String addedAtXpath = "/*[local-name()='getCommentsByTypeResponse']/*[local-name()='getCommentsByTypeGroup'][" + groupIndex + "]" + "/*[local-name()='comment'][" + commentIndex + "]/*[local-name()='addedAt']";
                        Node addedAt = rootElement.selectSingleNode(addedAtXpath);
                        addedAt.setText(dateText);
                    }
                }
                humanTaskResponse = rootElement.asXML();
            }
            catch (XmlException e) {
                if (this._logger != null && this._logger.isInfoEnabled()) {
                    this._logger.info("Process '" + this.getName() + "' was unable to localise comments: " + e.getLocalizedMessage());
                }
            }
            catch (Exception e) {
                if (this._logger == null || !this._logger.isInfoEnabled()) break block6;
                this._logger.info("Process '" + this.getName() + "' was unable to localise comments: " + e.getLocalizedMessage());
            }
        }
        return humanTaskResponse;
    }

    private String addCommentsResponse(StageContext context, String userID, String comment) throws PipelineException {
        String encComment;
        try {
            encComment = URLEncoder.encode(comment, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new PipelineException("could not encode comment " + comment, (Throwable)ex);
        }
        AddCommentDocument addCommentsRequest = AddCommentDocument.Factory.newInstance();
        addCommentsRequest.addNewAddComment();
        addCommentsRequest.getAddComment().setIdentifier(this.m_taskID);
        addCommentsRequest.getAddComment().setText(encComment);
        HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
        ServiceResponse humanTaskServiceResponse = new ServiceResponse();
        humanTaskPort.addComment(addCommentsRequest, humanTaskServiceResponse);
        return humanTaskServiceResponse.toString();
    }

    private String getParameterValue(String transientParamName, StageContext context) throws PipelineException {
        String paramValue = null;
        try {
            UsvFragmentContextImpl pipeLineContext = new UsvFragmentContextImpl(context);
            String transientParamValue = pipeLineContext.getParameterValue(transientParamName);
            if (transientParamValue != null && transientParamValue.length() > 0) {
                JSONObject json = JSONObject.parse((String)transientParamValue);
                paramValue = (String)json.get((Object)"value");
            }
        }
        catch (IOException ex) {
            throw new PipelineException("could not read inputs", (Throwable)ex);
        }
        return paramValue;
    }

    @Override
    protected String getTaskId(StageContext context) throws PipelineException {
        String id = this.getTransient(context, "taskid");
        if (id == null || "".equals(id)) {
            id = context.getTransientParams().getValue("notificationtaskid");
        }
        this.m_taskID = id;
        return id;
    }
}

