/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class DomResponseHandler
implements IXMLHandler {
    private StringBuffer m_buffer = new StringBuffer();
    private Document m_doc;
    private String elementName;

    public DomResponseHandler() {
    }

    public DomResponseHandler(String elementName) {
        this.elementName = elementName;
    }

    public void handle(XMLStreamReader reader) throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter((Writer)stringWriter);
        if (this.elementName != null) {
            StaxUtils.moveToElement((String)this.elementName, (XMLStreamReader)reader);
        }
        StaxUtils.copyCurrentElement((XMLStreamReader)reader, (XMLStreamWriter)xsw);
        this.m_buffer.append(stringWriter.getBuffer());
        try {
            SAXReader sReader = new SAXReader();
            this.m_doc = sReader.read(new InputSource(new StringReader(this.toString())));
        }
        catch (DocumentException e) {
            throw new XMLStreamException(e);
        }
    }

    public String toString() {
        return this.m_buffer.toString();
    }

    public String getSingleValue(String xPath) {
        Node node = this.m_doc.selectSingleNode(xPath);
        return node == null ? "" : node.getText();
    }

    public String getXML(String xPath) {
        Node node = this.m_doc.selectSingleNode(xPath);
        return node == null ? "" : node.asXML();
    }

    public Document getDom() {
        return this.m_doc;
    }

    public ArrayList<Parameter> getNameValues(String xPathIterator, String xpathName, String xpathValue) {
        ArrayList<Parameter> idList = new ArrayList<Parameter>();
        List ids = this.m_doc.selectNodes(xPathIterator);
        for (Node id : ids) {
            String name = id.selectSingleNode(xpathName).getText();
            String value = id.selectSingleNode(xpathValue).getText();
            idList.add(new Parameter(name, value));
        }
        return idList;
    }

    public String[] getValues(String xPath) {
        ArrayList<String> idList = new ArrayList<String>();
        List ids = this.m_doc.selectNodes(xPath);
        for (Node id : ids) {
            idList.add(id.getText());
        }
        return idList.toArray(new String[0]);
    }

    public class Parameter {
        protected Object value;
        protected String name;

        public Parameter(String name_, Object value_) {
            this.name = name_;
            this.value = value_;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

