/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.ibm.cognos.internal.hts.fragment.FilterBuilder;
import com.ibm.cognos.internal.hts.fragment.ports.BasePort;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.ActionUtils;
import com.ibm.cognos.internal.hts.fragment.utils.MenuState;
import com.ibm.cognos.internal.hts.fragment.utils.ParamUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetMyTaskAbstractsDocument;

public class MyTaskInteractionStage
extends BaseInteractionStage {
    private ServiceLogger _logger;

    public MyTaskInteractionStage(ServiceLogger logger) {
        super(logger);
        this._logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        if (outputName != null) {
            try {
                XMLParameters interactionParams = context.getInteractionParams();
                if (ParamUtils.hasParam(interactionParams, "action")) {
                    HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
                    ServiceResponse serviceResponse = new ServiceResponse();
                    ActionUtils.handleAction(humanTaskPort, serviceResponse, interactionParams, this._logger);
                }
                String tasks = this.getResponse(context, "@@CURRENT_USER@@");
                IPipelineOutput output = this.getOutput(tasks);
                context.addOutput(outputName, output);
            }
            catch (Exception e) {
                if (this._logger != null && this._logger.isErrorEnabled()) {
                    this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                throw new PipelineException("could not read inputs", (Throwable)e);
            }
        }
    }

    public boolean canShare() {
        return false;
    }

    private String getResponse(StageContext context, String userID) throws PipelineException {
        GetMyTaskAbstractsDocument getMyTaskAbstractsDocument = GetMyTaskAbstractsDocument.Factory.newInstance();
        GetMyTaskAbstractsDocument.GetMyTaskAbstracts getMyTaskAbstracts = getMyTaskAbstractsDocument.addNewGetMyTaskAbstracts();
        FilterBuilder builder = new FilterBuilder(this.getName(), context, new MenuState(context, this._logger), this._logger);
        String filters = builder.generateFilterString();
        getMyTaskAbstracts.setTaskType(builder.getTaskType());
        getMyTaskAbstracts.setWhereClause(filters);
        HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
        ServiceResponse humanTaskServiceResponse = new ServiceResponse();
        humanTaskPort.getMyTaskAbstracts(getMyTaskAbstractsDocument, humanTaskServiceResponse);
        return BasePort.getWrappedServiceResponse(humanTaskServiceResponse);
    }
}

