/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.ibm.cognos.internal.hts.fragment.ports.BasePort;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.AbstractViewerInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetUnsubscriptionsDocument;
import java.io.IOException;

public class NotificationOptionsViewerInteractionStage
extends AbstractViewerInteractionStage {
    private String m_taskID;

    public NotificationOptionsViewerInteractionStage(ServiceLogger logger) {
        super(logger);
    }

    @Override
    protected void addResponseToOutput(String taskInfoResponse, StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        StringBuffer response = new StringBuffer();
        if (outputName != null) {
            String userID = context.getEnv().getUserID();
            this.m_taskID = context.getTransientParams().getValue("taskid");
            response.append(taskInfoResponse);
            if (this.m_taskID != null && this.m_taskID.length() > 0) {
                response.append(this.getUnsubscriptionsResponse(context, userID));
                try {
                    String queryResponse = BasePort.getWrappedServiceResponse(response.toString());
                    IPipelineOutput output = this.getOutput(queryResponse);
                    context.addOutput(outputName, output);
                }
                catch (IOException e) {
                    if (this._logger != null && this._logger.isErrorEnabled()) {
                        this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                    }
                    throw new PipelineException("could not read inputs", (Throwable)e);
                }
            }
        }
    }

    private String getUnsubscriptionsResponse(StageContext context, String userID) throws PipelineException {
        GetUnsubscriptionsDocument request = GetUnsubscriptionsDocument.Factory.newInstance();
        GetUnsubscriptionsDocument.GetUnsubscriptions getUnsubscriptions = request.addNewGetUnsubscriptions();
        getUnsubscriptions.setTaskID(this.m_taskID);
        HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
        ServiceResponse humanTaskServiceResponse = new ServiceResponse();
        humanTaskPort.getUnsubscriptions(request, humanTaskServiceResponse);
        return humanTaskServiceResponse.toString();
    }

    @Override
    protected String getTaskId(StageContext context) throws PipelineException {
        return this.getTransient(context, "taskid");
    }
}

