/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameter;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.DomResponseHandler;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.ActionUtils;
import com.ibm.cognos.internal.hts.fragment.utils.ParamUtils;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import java.io.IOException;
import java.util.Iterator;

public class NotificationRenderingInteractionStage
extends BaseInteractionStage {
    private ServiceLogger m_logger;

    public NotificationRenderingInteractionStage(ServiceLogger logger) {
        super(logger);
        this.m_logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        if (outputName != null) {
            if (this.m_logger.isDebugEnabled()) {
                this.dumpInteractionParams(context);
            }
            try {
                HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this.m_logger);
                String id = ParamUtils.validate(context.getInteractionParams(), "taskid", this.m_logger);
                if (ParamUtils.isValid(id)) {
                    String action = ParamUtils.validate(context.getInteractionParams(), "action", this.m_logger);
                    if ("completeNotification".equals(action)) {
                        ServiceResponse serviceResponse = new ServiceResponse();
                        ActionUtils.handleAction(humanTaskPort, serviceResponse, context.getInteractionParams(), this.m_logger);
                    }
                    this.addManualTaskToResponse(context, outputName, humanTaskPort, id);
                }
            }
            catch (Exception e) {
                if (this.m_logger != null && this.m_logger.isErrorEnabled()) {
                    this.m_logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                throw new PipelineException("could not read inputs", (Throwable)e);
            }
        }
    }

    private void addManualTaskToResponse(StageContext context, String outputName, HumanTaskServicePort humanTaskPort, String id) throws PipelineException, IOException, HumanTaskServiceException {
        String input = "";
        StringBuffer responseBuffer = new StringBuffer();
        DomResponseHandler responseHandler = new DomResponseHandler("manualTask");
        humanTaskPort.getInput(id, responseHandler);
        input = responseHandler.toString();
        responseBuffer.append("<queryResponse>");
        responseBuffer.append(input);
        responseBuffer.append("</queryResponse>");
        IPipelineOutput pOutput = this.getOutput(responseBuffer.toString());
        context.addOutput(outputName, pOutput);
    }

    public boolean canShare() {
        return false;
    }

    private void dumpInteractionParams(StageContext context) {
        XMLParameters params = context.getInteractionParams();
        Iterator it = params.iterator();
        if (it.hasNext()) {
            System.out.println("Dumping interaction parameters");
        } else {
            System.out.println("No interaction parameters found for " + this.getName());
        }
        while (it.hasNext()) {
            XMLParameter param = (XMLParameter)it.next();
            System.out.println("name:" + param.getName() + ", value:" + param.getValue());
        }
    }
}

