/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.FragmentInstance;
import com.cognos.portal.schemas.fragments.Params;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.ParamUtils;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetRenderingDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetRenderingResponseDocument;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class RenderingInteractionStage
extends BaseInteractionStage {
    private ServiceLogger _logger;

    public RenderingInteractionStage(ServiceLogger logger) {
        super(logger);
        this._logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        if (outputName != null) {
            try {
                this.addParameter(context, "display_id", "");
                String response = "<queryResponse></queryResponse>";
                String info = this.getTransient(context, "renderingTaskInfo");
                if (info == null) {
                    info = this.getTransient(context, "renderingNotificationInfo");
                }
                String id = "";
                if (info != null && !"".equals(info)) {
                    try {
                        JSONObject jsonObj = JSONObject.parse((String)info);
                        id = String.valueOf(jsonObj.get((Object)"id"));
                    }
                    catch (IOException e) {
                        throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (ParamUtils.isValid(id)) {
                    GetRenderingDocument requestDoc = GetRenderingDocument.Factory.newInstance();
                    requestDoc.addNewGetRendering().setIdentifier(id);
                    requestDoc.getGetRendering().setRenderingType(new QName("http://developer.cognos.com/fragments/implementation/1/", "html"));
                    HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
                    ServiceResponse humanTaskServiceResponse = new ServiceResponse();
                    humanTaskPort.getRendering(requestDoc, humanTaskServiceResponse);
                    String rendering = this.getRenderingString(humanTaskServiceResponse);
                    if (!ParamUtils.isValid(rendering)) {
                        rendering = "bus://fragments/myinbox/emptyRendering";
                    }
                    this.setSubfragment(context, id, rendering);
                    response = "<queryResponse>" + rendering + "</queryResponse>";
                } else {
                    context.getFragment().clearSubfragment();
                }
                IPipelineOutput output = this.getOutput(response);
                context.addOutput(outputName, output);
            }
            catch (Exception e) {
                if (this._logger != null && this._logger.isErrorEnabled()) {
                    this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                throw new PipelineException("could not read inputs", (Throwable)e);
            }
        }
    }

    private void setSubfragment(StageContext context, String id, String rendering) throws PipelineException {
        Fragment fragment = context.getFragment();
        FragmentInstance fragmentInstance = new FragmentInstance();
        fragmentInstance.setId("renderingSubFrag");
        fragmentInstance.setHref(rendering);
        Params params = ParamUtils.addParameter(new Params(), "taskid", id);
        params = ParamUtils.addParameter(params, "user_name", context.getInteractionParams().getValue("user_name"));
        fragmentInstance.setParams(params);
        fragment.addSubfragment(fragmentInstance);
    }

    private String getRenderingString(ServiceResponse humanTaskServiceResponse) throws XmlException, PipelineException {
        String rendering = "";
        String usrString = humanTaskServiceResponse.toString();
        if (usrString.indexOf("Rendering") == -1) {
            throw new PipelineException("pf.pipeline.process.error", (Object[])new String[]{this.getName()}, (Throwable)new Exception(usrString));
        }
        GetRenderingResponseDocument responseDoc = GetRenderingResponseDocument.Factory.parse((String)usrString);
        rendering = HTSSDKUtils.getText((XmlObject)responseDoc.getGetRenderingResponse().getRendering());
        return rendering;
    }

    public boolean canShare() {
        return false;
    }
}

