/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.ActionUtils;
import com.ibm.cognos.internal.hts.fragment.utils.Utils;
import java.util.Locale;

public class TaskCreateInteractionStage
extends BaseInteractionStage {
    private ServiceLogger _logger;

    public TaskCreateInteractionStage(ServiceLogger logger) {
        super(logger);
        this._logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        if (outputName != null) {
            try {
                HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
                ServiceResponse actionResponse = new ServiceResponse();
                XMLParameters params = context.getInteractionParams();
                ActionUtils.handleAction(humanTaskPort, actionResponse, params, this._logger);
                StringBuffer currentUser = new StringBuffer();
                currentUser.append("<currentUser>");
                currentUser.append("<id>");
                String userID = context.getEnv().getUserID();
                EncodingUtils.xmlEncode((String)userID, (StringBuffer)currentUser);
                currentUser.append("</id>");
                currentUser.append("<name>");
                Locale locale = new Locale(context.getEnv().getProductLocale());
                EncodingUtils.xmlEncode((String)Utils.instance().getUserName(userID, locale, context), (StringBuffer)currentUser);
                currentUser.append("</name>");
                currentUser.append("</currentUser>");
                IPipelineOutput output = this.getOutput(currentUser.toString());
                context.addOutput(outputName, output);
            }
            catch (Exception e) {
                if (this._logger != null && this._logger.isErrorEnabled()) {
                    this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                throw new PipelineException("could not read inputs", (Throwable)e);
            }
        }
    }

    public boolean canShare() {
        return false;
    }
}

