/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.ibm.cognos.internal.hts.fragment.Constants;
import com.ibm.cognos.internal.hts.fragment.FilterBuilder;
import com.ibm.cognos.internal.hts.fragment.ports.BasePort;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.ActionUtils;
import com.ibm.cognos.internal.hts.fragment.utils.MenuState;
import com.ibm.cognos.internal.hts.fragment.utils.ParamUtils;
import com.ibm.cognos.internal.hts.fragment.utils.Utils;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.QueryDocument;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class TaskListInteractionStage
extends BaseInteractionStage {
    private ServiceLogger _logger;
    private static final String[] CAPABILITIES = new String[]{"completeNotification", "complete"};

    public TaskListInteractionStage(ServiceLogger logger) {
        super(logger);
        this._logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    public boolean canShare() {
        return false;
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        if (outputName != null) {
            XMLParameters interactionParams = context.getInteractionParams();
            try {
                String id = ParamUtils.validate(interactionParams, "taskid", this._logger);
                String notificationTaskId = ParamUtils.validate(interactionParams, "notificationtaskid", this._logger);
                MenuState menuState = new MenuState(context, this._logger);
                if (ParamUtils.isValid(id)) {
                    this.addParameter(context, "taskid", id);
                }
                if (ParamUtils.isValid(notificationTaskId)) {
                    this.addParameter(context, "notificationtaskid", notificationTaskId);
                }
                HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
                ServiceResponse serviceResponse = new ServiceResponse();
                ActionUtils.handleAction(humanTaskPort, serviceResponse, interactionParams, this._logger);
                String tasks = this.getResponse(context, menuState);
                IPipelineOutput output = this.getOutput(tasks);
                context.addOutput(outputName, output);
            }
            catch (Exception e) {
                if (this._logger != null && this._logger.isErrorEnabled()) {
                    this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                if (e instanceof PipelineException) {
                    throw (PipelineException)e;
                }
                throw new PipelineException(I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_HTS_ERROR_LOADING_TASKLIST, (Locale)new Locale(context.getEnv().getProductLocale())), (Throwable)e);
            }
        }
    }

    private String getResponse(StageContext context, MenuState menuState) throws PipelineException {
        FilterBuilder builder = new FilterBuilder(this.getName(), context, menuState, this._logger);
        builder.addStatusMapping(STATUS.READY, TStatus.RESERVED);
        builder.addStatusMapping(STATUS.ON_HOLD, TStatus.SUSPENDED);
        builder.addStatusMapping(STATUS.IN_PROGRESS, TStatus.IN_PROGRESS);
        builder.addStatusMapping(STATUS.COMPLETED, TStatus.COMPLETED);
        builder.addStatusMapping(STATUS.FAILED, TStatus.FAILED);
        builder.addStatusMapping(STATUS.OBSOLETE, TStatus.OBSOLETE);
        String filters = builder.generateFilterString();
        HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
        ServiceResponse humanTaskServiceResponse2 = new ServiceResponse();
        QueryDocument queryRequest = QueryDocument.Factory.newInstance();
        QueryDocument.Query query = queryRequest.addNewQuery();
        query.setOrderByClause(Constants.US_QUERY.parse(menuState.getSortBy()));
        query.setWhereClause(filters);
        humanTaskPort.getMySortedTasks(queryRequest, humanTaskServiceResponse2);
        String response = humanTaskServiceResponse2.toString().replace("api:row", "taskAbstract").replace("queryResponse", "getMyTasksResponse").replace("<query>", "").replace("</query>", "");
        String dateStyle = menuState.getDateStyle();
        String formattedResponse = this.formatResponse(response, context, menuState.getSortBy(), dateStyle);
        return BasePort.getWrappedServiceResponse(formattedResponse);
    }

    private String formatResponse(String strhumanTaskServiceResponse, StageContext context, String sortBy, String dateStyle) {
        String formattedResponse;
        block12: {
            StringReader xmlStringReader = null;
            SAXReader saxReader = null;
            Document document = null;
            Element rootElement = null;
            Element taskAbstract = null;
            Node childNode = null;
            String strFormattedValue = "";
            formattedResponse = "";
            try {
                xmlStringReader = new StringReader(strhumanTaskServiceResponse);
                saxReader = new SAXReader();
                document = saxReader.read((Reader)xmlStringReader);
                rootElement = document.getRootElement();
                if (rootElement != null) {
                    Iterator iterator = rootElement.elementIterator("taskAbstract");
                    while (iterator.hasNext()) {
                        taskAbstract = (Element)iterator.next();
                        this.addCapabilities(context, taskAbstract, CAPABILITIES);
                        if (taskAbstract == null) continue;
                        childNode = taskAbstract.selectSingleNode("./*[local-name()='expirationTime']");
                        strFormattedValue = Utils.instance().getFormattedDate(childNode, context, this._logger);
                        taskAbstract.addElement("formattedExpirationTime").addText(strFormattedValue);
                        childNode = taskAbstract.selectSingleNode("./*[local-name()='createdOn']");
                        strFormattedValue = Utils.instance().getFormattedDate(childNode, context, this._logger);
                        taskAbstract.addElement("formattedTaskCreatedTime").addText(strFormattedValue);
                        childNode = taskAbstract.selectSingleNode("./*[local-name()='dueDate']/text()");
                        strFormattedValue = Utils.instance().getFormattedDate(childNode, context, this._logger);
                        taskAbstract.addElement("formattedDueDate").addText(strFormattedValue);
                        if (dateStyle != null) {
                            taskAbstract.addElement("dateStyle").addText(dateStyle);
                        }
                        List stakeholders = taskAbstract.selectNodes("./*[local-name()='formattedTaskStakeholders']/*[local-name()='users']/*[local-name()='user']/text()");
                        StringBuffer stakesInAList = null;
                        for (Node node : stakeholders) {
                            if (stakesInAList == null) {
                                stakesInAList = new StringBuffer();
                            } else {
                                stakesInAList.append(", ");
                            }
                            stakesInAList.append(node.getText());
                        }
                        if (stakesInAList == null) continue;
                        taskAbstract.addElement("commaSeperatedTaskStakeholders").addText(stakesInAList.toString());
                    }
                    if (sortBy != null && !"".equals(sortBy)) {
                        if (Constants.US_QUERY.isIcon(sortBy)) {
                            XPath xpath = DocumentHelper.createXPath((String)"/*[local-name() = \"getMyTasksResponse\"]/*[local-name() = \"taskAbstract\"]");
                            XPath sortXPath = DocumentHelper.createXPath((String)"./*[local-name() = \"taskIconPath\"]");
                            List nodes = xpath.selectNodes((Object)document, sortXPath);
                            if (!Constants.US_QUERY.isAscending(sortBy)) {
                                Collections.reverse(nodes);
                            }
                            rootElement.setContent(nodes);
                        }
                        rootElement.addElement("sort").addText(sortBy);
                    }
                    if (dateStyle != null && !"".equals(dateStyle)) {
                        rootElement.addElement("dateStyle").addText(dateStyle);
                    }
                    formattedResponse = rootElement.asXML();
                }
            }
            catch (Exception ex) {
                formattedResponse = strhumanTaskServiceResponse;
                if (this._logger == null || !this._logger.isErrorEnabled()) break block12;
                this._logger.error(" " + this.getName() + " : There was an ERROR formating the user service response.", (Throwable)ex);
            }
        }
        return formattedResponse;
    }

    private void addCapabilities(StageContext context, Element taskAbstract, String[] capabilities) throws HumanTaskServiceException {
        List<HTSRole.Roles> roles = Utils.instance().getRolesForTask(taskAbstract, context);
        TStatus.Enum status = TStatus.Enum.forString((String)Utils.instance().getTaskProperty(taskAbstract, "status"));
        HTSTask.TYPE type = HTSTask.TYPE.valueOf((String)Utils.instance().getTaskProperty(taskAbstract, "taskType"));
        Utils.instance().appendMethodCapabilities(taskAbstract, context, roles, status, type, capabilities);
    }

    public static enum STATUS {
        READY,
        ON_HOLD,
        IN_PROGRESS,
        COMPLETED,
        FAILED,
        OBSOLETE;

    }
}

