/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.ActionUtils;
import com.ibm.cognos.internal.hts.fragment.utils.ParamUtils;

public class TaskUpdateInteractionStage
extends BaseInteractionStage {
    private ServiceLogger _logger;

    public TaskUpdateInteractionStage(ServiceLogger logger) {
        super(logger);
        this._logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        if (outputName != null) {
            try {
                String id = ParamUtils.validate(context.getInteractionParams(), "taskid", this._logger);
                if (ParamUtils.isValid(id)) {
                    this.addParameter(context, "taskid", id);
                    HumanTaskServicePort humanTaskPort = new HumanTaskServicePort(context, this.getName(), this._logger);
                    ServiceResponse actionResponse = new ServiceResponse();
                    ActionUtils.handleAction(humanTaskPort, actionResponse, context.getInteractionParams(), this._logger);
                }
            }
            catch (Exception e) {
                if (this._logger != null && this._logger.isErrorEnabled()) {
                    this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                throw new PipelineException("could not read inputs", (Throwable)e);
            }
        }
    }

    public boolean canShare() {
        return false;
    }
}

