/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameter;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.ibm.cognos.internal.hts.fragment.stage.BaseInteractionStage;
import java.util.Iterator;
import javax.xml.stream.XMLStreamWriter;

public class TaskWizardInteractionStage
extends BaseInteractionStage {
    private static final String NAV_ACTION = "navAction";
    private static final String TASK_RADIO = "taskRadio";
    private static final String NOTIFICATION_RADIO = "notificationRadio";
    private static final String ASSIGNEE_TEXT_INPUT = "assigneeTextInput";
    private static final String TASK_TITLE_INPUT = "taskTitleInput";
    private static final String TASK_RADIO_NOTIFICATION = "notification";
    private static final String CURRENT_PAGE = "currentPage";
    private static final String ENABLE_BACK_BUTTON = "enableBackButton";
    private static final String ENABLE_NEXT_BUTTON = "enableNextButton";
    private static final String ENABLE_FINISH_BUTTON = "enableFinishButton";
    private static final String NAV_ACTION_NEXT = "Next";
    private static final String NAV_ACTION_BACK = "Back";
    private static final String PAGE_0 = "page0";
    private static final String PAGE_1 = "page1";
    private ServiceLogger _logger;

    public TaskWizardInteractionStage(ServiceLogger logger) {
        super(logger);
        this._logger = logger == null ? null : logger.cloneForClass(((Object)((Object)this)).getClass());
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String outputName = this.getOutputName(context);
        if (outputName != null) {
            try {
                XMLParameters stateParams = context.getStateParams();
                XMLParameters interactionParams = context.getInteractionParams();
                this.updateState(interactionParams, stateParams);
                IPipelineOutput output1 = PipelineOutputFactory.getInstance().createOutput();
                XMLStreamWriter xmlStreamWriter = output1.getXMLStreamWriter();
                xmlStreamWriter.writeStartElement("queryResponse");
                xmlStreamWriter.writeStartElement("state");
                Iterator stateParamsIter = stateParams.iterator();
                while (stateParamsIter.hasNext()) {
                    xmlStreamWriter.writeStartElement("param");
                    ((XMLParameter)stateParamsIter.next()).write(xmlStreamWriter);
                    xmlStreamWriter.writeEndElement();
                }
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.close();
                context.addOutput(outputName, output1);
            }
            catch (Exception e) {
                if (this._logger != null && this._logger.isErrorEnabled()) {
                    this._logger.error("Process '" + this.getName() + "' failed to execute", (Throwable)e);
                }
                throw new PipelineException("could not read inputs", (Throwable)e);
            }
        }
    }

    private void updateState(XMLParameters interactionParams, XMLParameters stateParams) {
        String navAction;
        String currentPage = stateParams.getValue(CURRENT_PAGE);
        if (currentPage == null) {
            currentPage = PAGE_0;
            stateParams.addParameter(CURRENT_PAGE, currentPage);
            XMLParameter next = stateParams.getXMLParameter(ENABLE_NEXT_BUTTON);
            if (next == null) {
                next = stateParams.setParameter(ENABLE_NEXT_BUTTON, "true");
            } else {
                next.setValue("true");
            }
        }
        if ((navAction = interactionParams.getValue(NAV_ACTION)) != null && navAction.equals(NAV_ACTION_NEXT)) {
            this.nextPage(interactionParams, stateParams, currentPage);
        } else if (navAction != null && navAction.equals(NAV_ACTION_BACK)) {
            this.previousPage(interactionParams, stateParams, currentPage);
        }
        for (XMLParameter interParam : interactionParams) {
            stateParams.setParameter(interParam.getName(), interParam.getValue());
        }
    }

    private void nextPage(XMLParameters interactionParams, XMLParameters stateParams, String currentPage) {
        if (currentPage.equals(PAGE_0)) {
            String taskRadio = interactionParams.getValue(TASK_RADIO);
            if (taskRadio.equals(TASK_RADIO_NOTIFICATION)) {
                stateParams.setParameter(CURRENT_PAGE, PAGE_1);
            } else {
                stateParams.setParameter(CURRENT_PAGE, PAGE_1);
            }
        }
        stateParams.setParameter(ENABLE_BACK_BUTTON, "true");
    }

    private void previousPage(XMLParameters interactionParams, XMLParameters stateParams, String currentPage) {
        if (currentPage.equals(PAGE_1)) {
            XMLParameter cp = stateParams.getXMLParameter(CURRENT_PAGE);
            if (cp == null) {
                cp = stateParams.setParameter(CURRENT_PAGE, PAGE_0);
            } else {
                cp.setValue(PAGE_0);
            }
            stateParams.setParameter(ENABLE_BACK_BUTTON, "false");
        }
    }

    public boolean canShare() {
        return false;
    }
}

