/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.utils;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.ibm.cognos.internal.hts._1.BeplNotificationDocument;
import com.ibm.cognos.internal.hts._1.BeplTaskDocument;
import com.ibm.cognos.internal.hts._1.CogBeplNotification;
import com.ibm.cognos.internal.hts._1.CogBeplTask;
import com.ibm.cognos.internal.hts._1.LinkType;
import com.ibm.cognos.internal.hts._1.LinksListType;
import com.ibm.cognos.internal.hts._1.ManualTask;
import com.ibm.cognos.internal.hts._1.ManualTaskDescription;
import com.ibm.cognos.internal.hts._1.ManualTaskDocument;
import com.ibm.cognos.internal.hts.fragment.ports.HumanTaskServicePort;
import com.ibm.cognos.internal.hts.fragment.stage.ServiceResponse;
import com.ibm.cognos.internal.hts.fragment.utils.ParamUtils;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSFolder;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TFrom;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.TGroup;
import com.ibm.cognos.internal.hts.ws_ht.TGrouplist;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;
import com.ibm.cognos.internal.hts.ws_ht.TUser;
import com.ibm.cognos.internal.hts.ws_ht.TUserlist;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.AssignFolderToTasksDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.ChangeSubscriptionDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.CompleteNotificationDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineInstance;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineInstanceList;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineType;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FolderAction;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FolderUpdateAction;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.PrivateFolder;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.StatusOperations;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.Subscription;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.SubscriptionEventState;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.SubscriptionEventType;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.TaskIdList;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.UpdateTaskDetailsDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.ActivateDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.ClaimDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.CompleteDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.DelegateDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.ReleaseDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.RemoveDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.ResumeDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.SetPriorityDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.SkipDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.StartDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.StopDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.SuspendDocument;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class ActionUtils {
    private static final String CONTENT_TEXT_PLAIN = "text/plain";
    private static final String CONTENT_TEXT_HTML = "text/html";
    private static final String DEFAULT_PRIORITY = "3";

    public static void handleAction(HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler, XMLParameters interactionParams, ServiceLogger logger) throws PipelineException {
        if (ParamUtils.hasParam(interactionParams, "action")) {
            String action = ParamUtils.validate(interactionParams, "action", logger);
            String[] taskIDs = null;
            if (!action.equals("createGenericTask") && !action.equals("createNotificationTask")) {
                taskIDs = ActionUtils.getTaskIds(interactionParams, logger);
            }
            if (action.equals("activate")) {
                ActionUtils.activateAction(taskIDs, humanTaskPort, responseHandler);
            } else if (action.equals("archive")) {
                ActionUtils.archiveAction(taskIDs, humanTaskPort, responseHandler, action);
            } else if (action.equals("unarchive")) {
                ActionUtils.archiveAction(taskIDs, humanTaskPort, responseHandler, action);
            } else if (action.equals("claim")) {
                ActionUtils.claimAction(taskIDs, humanTaskPort, responseHandler);
            } else if (action.equals("delete")) {
                ActionUtils.archiveAction(taskIDs, humanTaskPort, responseHandler, action);
            } else if (action.equals("assign")) {
                String entity = ParamUtils.validate(interactionParams, "entity", logger);
                ActionUtils.assignAction(taskIDs, entity, humanTaskPort, responseHandler);
            } else if (action.equals("delegate")) {
                String users = ParamUtils.validate(interactionParams, "users", logger);
                ActionUtils.delegateAction(taskIDs, users, humanTaskPort, responseHandler);
            } else if (action.equals("release")) {
                ActionUtils.releaseAction(taskIDs, humanTaskPort, responseHandler);
            } else if (action.equals("setPriority")) {
                String priority = ParamUtils.validate(interactionParams, "value", logger);
                ActionUtils.setPriorityAction(taskIDs, priority, humanTaskPort, responseHandler);
            } else if (action.equals("start")) {
                ActionUtils.startAction(taskIDs, humanTaskPort, responseHandler);
            } else if (action.equals("stop")) {
                ActionUtils.stopAction(taskIDs, humanTaskPort, responseHandler);
            } else if (action.equals("suspend")) {
                ActionUtils.suspendAction(taskIDs, humanTaskPort, responseHandler);
            } else if (action.equals("resume")) {
                ActionUtils.resumeAction(taskIDs, humanTaskPort, responseHandler);
            } else if (action.equals("remove")) {
                ActionUtils.removeAction(taskIDs, humanTaskPort, responseHandler);
            } else if (action.equals("skipTask")) {
                ActionUtils.skipAction(taskIDs, humanTaskPort, responseHandler);
            } else if (action.equals("complete")) {
                ActionUtils.completeAction(humanTaskPort, taskIDs[0], interactionParams, logger);
            } else if (action.equals("completeNotification")) {
                ActionUtils.completeNotificationAction(humanTaskPort, taskIDs[0], interactionParams, logger);
            } else if (action.equals("changeSubscription")) {
                ActionUtils.changeSubscriptionAction(humanTaskPort, taskIDs, interactionParams, logger, responseHandler);
            } else if (action.equals("updateTask")) {
                ActionUtils.updateTaskAction(humanTaskPort, taskIDs, interactionParams);
            } else if (action.equals("createGenericTask")) {
                ActionUtils.createGenericTaskAction(humanTaskPort, interactionParams, logger, responseHandler);
            } else if (action.equals("createNotificationTask")) {
                ActionUtils.createNotificationTaskAction(humanTaskPort, interactionParams, logger, responseHandler);
            }
        }
    }

    private static void createNotificationTaskAction(HumanTaskServicePort humanTaskPort, XMLParameters interactionsParams, ServiceLogger logger, IXMLHandler responseHandler) throws PipelineException {
        String notReadByDate = interactionsParams.getValue("dueDate");
        String recipientsList = interactionsParams.getValue("recipientList");
        String stakeHolders = interactionsParams.getValue("stakeholderList");
        String subject = interactionsParams.getValue("subject");
        String messageText = interactionsParams.getValue("message_text");
        String messageHTML = interactionsParams.getValue("message_HTML");
        String recordReadReceipt = String.valueOf(interactionsParams.getValue("recordReadReceipt"));
        String reportLinks = interactionsParams.getValue("reportLinks");
        String reportLinksDisplay = interactionsParams.getValue("reportLinksDisplay");
        try {
            CogBeplNotification cogBeplNotification = CogBeplNotification.Factory.newInstance();
            cogBeplNotification.setPriority(new BigInteger("1"));
            TPeopleAssignments recipients = cogBeplNotification.addNewPeopleAssignments();
            TGenericHumanRole recipientHumanRole = TGenericHumanRole.Factory.newInstance();
            recipientHumanRole.setFrom(ActionUtils.createOrganizationalEntity(recipientsList));
            recipients.setRecipientsArray(new TGenericHumanRole[]{recipientHumanRole});
            TGenericHumanRole ccStakeHoldersHumanRole = TGenericHumanRole.Factory.newInstance();
            ccStakeHoldersHumanRole.setFrom(ActionUtils.createOrganizationalEntity(stakeHolders));
            recipients.setTaskStakeholdersArray(new TGenericHumanRole[]{ccStakeHoldersHumanRole});
            ActionUtils.addBusinessAdministratorGroup(recipients);
            ManualTask manualTask = ManualTask.Factory.newInstance();
            manualTask.setSubject(subject);
            ActionUtils.setDescriptionOfTask(messageText, messageHTML, manualTask);
            if (notReadByDate != null && notReadByDate.length() > 0) {
                Calendar cal = TimeUtils.getCalendar((String)notReadByDate);
                TimeUtils.resetHours((Calendar)cal);
                manualTask.setStartUntil(cal);
            }
            LinksListType linksList = ActionUtils.getLinksList(reportLinks, reportLinksDisplay);
            manualTask.setLinksList(linksList);
            manualTask.setRecordReadReceipt(Boolean.valueOf(recordReadReceipt).booleanValue());
            ManualTaskDocument manualDocument = ManualTaskDocument.Factory.newInstance();
            manualDocument.setManualTask(manualTask);
            BeplNotificationDocument beplNotificationDocument = BeplNotificationDocument.Factory.newInstance();
            beplNotificationDocument.setBeplNotification(cogBeplNotification);
            XmlAnySimpleType createGenericTask = HTSSDKUtils.createNotificationTask((BeplNotificationDocument)beplNotificationDocument, (ManualTaskDocument)manualDocument);
            humanTaskPort.createGenericTask((XmlObject)createGenericTask, responseHandler);
        }
        catch (HumanTaskServiceException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PipelineException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static void setDescriptionOfTask(String message, String messageHTML, ManualTask manualTask) {
        ManualTaskDescription desc = manualTask.addNewDescription();
        XmlCursor cursor = desc.newCursor();
        cursor.toFirstContentToken();
        cursor.insertChars(message);
        cursor.dispose();
        desc.setContentType(CONTENT_TEXT_PLAIN);
        ManualTaskDescription descHTML = manualTask.addNewDescription();
        XmlCursor cursorh = descHTML.newCursor();
        cursorh.toFirstContentToken();
        cursorh.insertChars(messageHTML);
        cursorh.dispose();
        descHTML.setContentType(CONTENT_TEXT_HTML);
        manualTask.setDescriptionArray(new ManualTaskDescription[]{desc, descHTML});
    }

    private static void createGenericTaskAction(HumanTaskServicePort humanTaskPort, XMLParameters interactionsParams, ServiceLogger logger, IXMLHandler responseHandler) throws PipelineException {
        String dueDate = interactionsParams.getValue("dueDate");
        String startBy = interactionsParams.getValue("startBy");
        String potentialOwners = interactionsParams.getValue("potentialOwnerList");
        String reportLinks = interactionsParams.getValue("reportLinks");
        String reportLinksDisplay = interactionsParams.getValue("reportLinksDisplay");
        String stakeHolders = interactionsParams.getValue("stakeholderList");
        String priority = interactionsParams.getValue("priority");
        String subject = interactionsParams.getValue("subject");
        String messageText = interactionsParams.getValue("message_text");
        String messageHTML = interactionsParams.getValue("message_HTML");
        try {
            CogBeplTask cogBeplTask = CogBeplTask.Factory.newInstance();
            cogBeplTask.setPriority(new BigInteger(priority));
            TPeopleAssignments peopleAssignments = cogBeplTask.addNewPeopleAssignments();
            TGenericHumanRole potentialOwnersGenericHumanRole = TGenericHumanRole.Factory.newInstance();
            potentialOwnersGenericHumanRole.setFrom(ActionUtils.createOrganizationalEntity(potentialOwners));
            peopleAssignments.setPotentialOwnersArray(new TGenericHumanRole[]{potentialOwnersGenericHumanRole});
            TGenericHumanRole stakeHoldersGenericHumanRole = TGenericHumanRole.Factory.newInstance();
            stakeHoldersGenericHumanRole.setFrom(ActionUtils.createOrganizationalEntity(stakeHolders));
            peopleAssignments.setTaskStakeholdersArray(new TGenericHumanRole[]{stakeHoldersGenericHumanRole});
            ActionUtils.addBusinessAdministratorGroup(peopleAssignments);
            ManualTask manualTask = ManualTask.Factory.newInstance();
            manualTask.setSubject(subject);
            ActionUtils.setDescriptionOfTask(messageText, messageHTML, manualTask);
            if (startBy != null && startBy.length() > 0) {
                Calendar cal = TimeUtils.getCalendar((String)startBy);
                TimeUtils.resetHours((Calendar)cal);
                manualTask.setStartUntil(cal);
            }
            LinksListType linksList = ActionUtils.getLinksList(reportLinks, reportLinksDisplay);
            manualTask.setLinksList(linksList);
            if (dueDate != null && dueDate.length() > 0) {
                Calendar cal = TimeUtils.getCalendar((String)dueDate);
                TimeUtils.resetHours((Calendar)cal);
                manualTask.setCompleteUntil(TimeUtils.getCalendar((String)dueDate));
            }
            ActionUtils.setSubscriptions(interactionsParams, logger, manualTask);
            ManualTaskDocument manualDocument = ManualTaskDocument.Factory.newInstance();
            manualDocument.setManualTask(manualTask);
            BeplTaskDocument beplTaskDocument = BeplTaskDocument.Factory.newInstance();
            beplTaskDocument.setBeplTask(cogBeplTask);
            XmlAnySimpleType createGenericTask = HTSSDKUtils.createTask((String)"createGenericManualTask", (BeplTaskDocument)beplTaskDocument, (ManualTaskDocument)manualDocument);
            humanTaskPort.createGenericTask((XmlObject)createGenericTask, responseHandler);
        }
        catch (HumanTaskServiceException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PipelineException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static void addBusinessAdministratorGroup(TPeopleAssignments peopleAssignments) throws IOException, PipelineException {
        TGenericHumanRole businessAdministratorsGenericHumanRole = TGenericHumanRole.Factory.newInstance();
        TFrom tFrom = ActionUtils.createOrganizationalEntity("{\"logicalPeopleGroup\":\"CAM\",\"organizationalEntities\":[{\"token\":\"CAMID(\\\":Server Administrators\\\")\",\"isGroup\":\"true\"}]}");
        businessAdministratorsGenericHumanRole.setFrom(tFrom);
        peopleAssignments.setBusinessAdministratorsArray(new TGenericHumanRole[]{businessAdministratorsGenericHumanRole});
    }

    private static void archiveAction(String[] taskIDs, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler, String action) throws PipelineException {
        AssignFolderToTasksDocument archiveRequest = AssignFolderToTasksDocument.Factory.newInstance();
        AssignFolderToTasksDocument.AssignFolderToTasks assignFolderDoc = archiveRequest.addNewAssignFolderToTasks();
        TaskIdList list = TaskIdList.Factory.newInstance();
        for (int i = 0; i < taskIDs.length; ++i) {
            list.addNewTaskId().setStringValue(taskIDs[i]);
        }
        assignFolderDoc.setTaskIds(list);
        FolderAction addAction = assignFolderDoc.addNewFolderAction();
        addAction.setAction(FolderUpdateAction.ADD);
        PrivateFolder addFolder = addAction.addNewPrivateFolder();
        FolderAction removeAction = assignFolderDoc.addNewFolderAction();
        removeAction.setAction(FolderUpdateAction.REMOVE);
        PrivateFolder removeFolder = removeAction.addNewPrivateFolder();
        if (action.equals("unarchive")) {
            removeFolder.setName(HTSFolder.UI_FOLDERS.ARCHIVE.name());
            addFolder.setName(HTSFolder.UI_FOLDERS.INBOX.name());
        } else if (action.equals("archive")) {
            removeFolder.setName(HTSFolder.UI_FOLDERS.INBOX.name());
            addFolder.setName(HTSFolder.UI_FOLDERS.ARCHIVE.name());
        } else if (action.equals("delete")) {
            removeFolder.setName(HTSFolder.UI_FOLDERS.ARCHIVE.name());
            addFolder.setName(HTSFolder.UI_FOLDERS.DELETED.name());
        }
        humanTaskPort.archive(archiveRequest, responseHandler);
    }

    private static void activateAction(String[] taskIDs, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            ActivateDocument activateRequest = ActivateDocument.Factory.newInstance();
            activateRequest.addNewActivate().setIdentifier(taskIDs[i]);
            humanTaskPort.activate(activateRequest, responseHandler);
        }
    }

    private static void claimAction(String[] taskIDs, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            ClaimDocument claimRequest = ClaimDocument.Factory.newInstance();
            claimRequest.addNewClaim().setIdentifier(taskIDs[i]);
            humanTaskPort.claim(claimRequest, responseHandler);
        }
    }

    private static void assignAction(String[] taskIDs, String entity, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            DelegateDocument delegateRequest = DelegateDocument.Factory.newInstance();
            delegateRequest.addNewDelegate().setIdentifier(taskIDs[i]);
            humanTaskPort.delegate(delegateRequest, responseHandler);
        }
    }

    private static void delegateAction(String[] taskIDs, String userToken, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            DelegateDocument delegateRequest = DelegateDocument.Factory.newInstance();
            delegateRequest.addNewDelegate().setIdentifier(taskIDs[i]);
            OrganizationalEntityDocument orgEntDoc = OrganizationalEntityDocument.Factory.newInstance();
            TOrganizationalEntity orgEnt = orgEntDoc.addNewOrganizationalEntity();
            TUserlist userList = orgEnt.addNewUsers();
            if (userToken != null && !"".equals(userToken)) {
                TUser user = userList.addNewUser();
                user.setStringValue(userToken);
                orgEnt.setUsersArray(0, userList);
            }
            delegateRequest.getDelegate().setOrganizationalEntity(orgEnt);
            humanTaskPort.delegate(delegateRequest, responseHandler);
        }
    }

    private static void changeSubscriptionAction(HumanTaskServicePort humanTaskPort, String[] taskIDs, XMLParameters interactionParams, ServiceLogger logger, IXMLHandler responseHandler) throws PipelineException {
        String userToken = ParamUtils.validate(interactionParams, "user_id", logger);
        String events = ParamUtils.validate(interactionParams, "events", logger);
        ChangeSubscriptionDocument changeSubscriptionDoc = ChangeSubscriptionDocument.Factory.newInstance();
        ChangeSubscriptionDocument.ChangeSubscription changeSubscription = changeSubscriptionDoc.addNewChangeSubscription();
        try {
            if (userToken != null && events != null) {
                JSONObject jsonObj = JSONObject.parse((String)events);
                Iterator eventKeys = jsonObj.keySet().iterator();
                while (eventKeys.hasNext()) {
                    Subscription subscription = changeSubscription.addNewSubscription();
                    String event = (String)eventKeys.next();
                    String subscribState = String.valueOf(jsonObj.get((Object)event));
                    subscription.setEvent(SubscriptionEventType.Enum.forString((String)event));
                    subscription.setSubscriptionState(SubscriptionEventState.Enum.forString((String)subscribState));
                }
            }
        }
        catch (IOException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        for (int i = 0; i < taskIDs.length; ++i) {
            changeSubscription.setTaskID(taskIDs[i]);
            changeSubscription.setUserID(userToken);
            humanTaskPort.changeSubscription(changeSubscriptionDoc, responseHandler);
        }
    }

    private static void releaseAction(String[] taskIDs, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            ReleaseDocument releaseRequest = ReleaseDocument.Factory.newInstance();
            releaseRequest.addNewRelease().setIdentifier(taskIDs[i]);
            humanTaskPort.release(releaseRequest, responseHandler);
        }
    }

    private static void setPriorityAction(String[] taskIDs, String priority, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        if (priority == null) {
            priority = DEFAULT_PRIORITY;
        }
        for (int i = 0; i < taskIDs.length; ++i) {
            SetPriorityDocument setPriorityRequest = SetPriorityDocument.Factory.newInstance();
            setPriorityRequest.addNewSetPriority().setIdentifier(taskIDs[i]);
            BigInteger priorityBigInt = new BigInteger(priority);
            setPriorityRequest.getSetPriority().setPriority(priorityBigInt);
            humanTaskPort.setPriority(setPriorityRequest, responseHandler);
        }
    }

    private static void startAction(String[] taskIDs, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            StartDocument startRequest = StartDocument.Factory.newInstance();
            startRequest.addNewStart().setIdentifier(taskIDs[i]);
            humanTaskPort.start(startRequest, responseHandler);
        }
    }

    private static void stopAction(String[] taskIDs, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            StopDocument stopRequest = StopDocument.Factory.newInstance();
            stopRequest.addNewStop().setIdentifier(taskIDs[i]);
            humanTaskPort.stop(stopRequest, responseHandler);
        }
    }

    private static void suspendAction(String[] taskIDs, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            SuspendDocument suspendRequest = SuspendDocument.Factory.newInstance();
            suspendRequest.addNewSuspend().setIdentifier(taskIDs[i]);
            humanTaskPort.suspend(suspendRequest, responseHandler);
        }
    }

    private static void resumeAction(String[] taskIDs, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            ResumeDocument resumeRequest = ResumeDocument.Factory.newInstance();
            resumeRequest.addNewResume().setIdentifier(taskIDs[i]);
            humanTaskPort.resume(resumeRequest, responseHandler);
        }
    }

    private static void removeAction(String[] taskIDs, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            RemoveDocument removeDoc = RemoveDocument.Factory.newInstance();
            removeDoc.addNewRemove();
            removeDoc.getRemove().setIdentifier(taskIDs[i]);
            humanTaskPort.remove(removeDoc, responseHandler);
        }
    }

    private static void skipAction(String[] taskIDs, HumanTaskServicePort humanTaskPort, IXMLHandler responseHandler) throws PipelineException {
        for (int i = 0; i < taskIDs.length; ++i) {
            SkipDocument skipDocument = SkipDocument.Factory.newInstance();
            skipDocument.addNewSkip().setIdentifier(taskIDs[i]);
            humanTaskPort.skip(skipDocument, responseHandler);
        }
    }

    private static void completeAction(HumanTaskServicePort humanTaskPort, String id, XMLParameters interactionParams, ServiceLogger logger) throws PipelineException {
        String output = ParamUtils.validate(interactionParams, "output", logger);
        CompleteDocument cd = CompleteDocument.Factory.newInstance();
        cd.addNewComplete();
        cd.getComplete().setIdentifier(id);
        if (output == null || "".equals(output)) {
            output = "<completed/>";
        }
        try {
            XmlObject outputXML = XmlObject.Factory.parse((String)output);
            cd.getComplete().setTaskData(outputXML);
            ServiceResponse handler = new ServiceResponse();
            humanTaskPort.complete(cd, handler);
        }
        catch (XmlException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static void completeNotificationAction(HumanTaskServicePort humanTaskPort, String id, XMLParameters interactionParams, ServiceLogger logger) throws PipelineException {
        CompleteNotificationDocument cn = CompleteNotificationDocument.Factory.newInstance();
        cn.addNewCompleteNotification();
        cn.getCompleteNotification().setIdentifier(id);
        ServiceResponse handler = new ServiceResponse();
        humanTaskPort.completeNotification(cn, handler);
    }

    private static void updateTaskAction(HumanTaskServicePort humanTaskPort, String[] taskIDs, XMLParameters interactionsParams) throws PipelineException {
        try {
            String dueDate = interactionsParams.getValue("dueDate");
            String statusOperation = interactionsParams.getValue("hts_status");
            String startBy = interactionsParams.getValue("startBy");
            String potentialOwners = interactionsParams.getValue("potentialOwnerList");
            String stakeHolders = interactionsParams.getValue("stakeholderList");
            String priority = interactionsParams.getValue("priority");
            for (int i = 0; i < taskIDs.length; ++i) {
                String id = taskIDs[i];
                UpdateTaskDetailsDocument updateDoc = UpdateTaskDetailsDocument.Factory.newInstance();
                UpdateTaskDetailsDocument.UpdateTaskDetails taskDetails = updateDoc.addNewUpdateTaskDetails();
                DeadlineInstanceList deadlines = taskDetails.addNewDeadlines();
                taskDetails.setIdentifier(id);
                ActionUtils.setDate(startBy, deadlines, DeadlineType.START);
                ActionUtils.setDate(dueDate, deadlines, DeadlineType.COMPLETE);
                updateDoc.getUpdateTaskDetails().setStatusOperation(StatusOperations.Enum.forString((String)statusOperation));
                TGenericHumanRole stakeHoldersGenericHumanRole = taskDetails.addNewTaskStakeholders();
                TFrom from = ActionUtils.createOrganizationalEntity(stakeHolders);
                stakeHoldersGenericHumanRole.setFrom(from);
                taskDetails.setTaskStakeholders(stakeHoldersGenericHumanRole);
                TGenericHumanRole potentialOwnersGenericHumanRole = taskDetails.addNewPotentialOwners();
                TFrom posFrom = ActionUtils.createOrganizationalEntity(potentialOwners);
                potentialOwnersGenericHumanRole.setFrom(posFrom);
                taskDetails.setPotentialOwners(potentialOwnersGenericHumanRole);
                taskDetails.setPriority(new BigInteger(priority));
                String actualOwner = interactionsParams.getValue("actualOwner");
                taskDetails.setActualOwner(actualOwner);
                ServiceResponse humanTaskServiceResponse = new ServiceResponse();
                humanTaskPort.updateTask(updateDoc, humanTaskServiceResponse);
            }
        }
        catch (IOException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static String[] getTaskIds(XMLParameters interactionParams, ServiceLogger logger) throws PipelineException {
        String[] taskIDs;
        block3: {
            taskIDs = new String[]{};
            String prefix = "taskid_";
            try {
                taskIDs = ParamUtils.validateMultiple(interactionParams, prefix, logger);
            }
            catch (PipelineException ex) {
                if (taskIDs.length != 0) break block3;
                String taskID = ParamUtils.validate(interactionParams, "taskid", logger);
                if (taskID != null) {
                    taskIDs = new String[]{taskID};
                }
                throw ex;
            }
        }
        return taskIDs;
    }

    private static void setDate(String dateStr, DeadlineInstanceList deadlines, DeadlineType.Enum type) throws PipelineException {
        if (dateStr != null && dateStr.length() > 0) {
            DeadlineInstance deadline = deadlines.addNewDeadlineInstance();
            try {
                Calendar cal = TimeUtils.getCalendar((String)dateStr);
                if (!type.equals(DeadlineType.START)) {
                    TimeUtils.resetHours((Calendar)cal);
                }
                deadline.setDate(cal);
                deadline.setType(type);
                deadline.setNotify(true);
            }
            catch (HumanTaskServiceException e) {
                throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private static TFrom createOrganizationalEntity(String entities) throws IOException, PipelineException {
        OrganizationalEntityDocument orgEntDoc = OrganizationalEntityDocument.Factory.newInstance();
        TGenericHumanRole tgenhumanrole = TGenericHumanRole.Factory.newInstance();
        TOrganizationalEntity orgEnt = orgEntDoc.addNewOrganizationalEntity();
        String lpgName = "CAM";
        if (!"".equals(entities) && JSONObject.isValidObject((Object)entities)) {
            JSONObject jsonObj = JSONObject.parse((String)entities);
            for (String key : jsonObj.keySet()) {
                if ("organizationalEntities".equals(key)) {
                    JSONArray tokensArray = (JSONArray)jsonObj.get((Object)key);
                    if (tokensArray.size() <= 0) continue;
                    TGrouplist groupList = orgEnt.addNewGroups();
                    TUserlist userList = orgEnt.addNewUsers();
                    ListIterator tokensItr = tokensArray.listIterator();
                    while (tokensItr.hasNext()) {
                        JSONObject tokenObj = (JSONObject)tokensItr.next();
                        String token = (String)tokenObj.get((Object)"token");
                        String isGroup = (String)tokenObj.get((Object)"isGroup");
                        if (isGroup != null && isGroup.equals("true")) {
                            TGroup group = groupList.addNewGroup();
                            group.setStringValue(token);
                            continue;
                        }
                        TUser user = userList.addNewUser();
                        user.setStringValue(token);
                    }
                    orgEnt.setGroupsArray(0, groupList);
                    orgEnt.setUsersArray(0, userList);
                    continue;
                }
                if (!"logicalPeopleGroup".equals(key) || (lpgName = (String)jsonObj.get((Object)key)) != null && lpgName.length() != 0) continue;
                throw new PipelineException("No logical people group defined.");
            }
        }
        TFrom from = tgenhumanrole.addNewFrom();
        from.setLogicalPeopleGroup(new QName(lpgName));
        from.addNewLiteral().set((XmlObject)orgEntDoc);
        return from;
    }

    private static LinksListType getLinksList(String reportLinks, String reportLinksDisplay) throws IOException {
        LinksListType linksList = LinksListType.Factory.newInstance();
        if (reportLinks == null || reportLinksDisplay == null) {
            return linksList;
        }
        StringTokenizer reportLinkDispTokens = new StringTokenizer(reportLinksDisplay, ",");
        JSONArray reportLinksColl = JSONArray.parse((String)("[" + reportLinks + "]"));
        if (reportLinkDispTokens.countTokens() == reportLinksColl.size()) {
            for (JSONObject jsonObject : reportLinksColl) {
                String id = jsonObject.get((Object)"id").toString();
                String objectClass = jsonObject.get((Object)"objectClass").toString();
                LinkType linkItem = linksList.addNewLink();
                linkItem.setId(id);
                linkItem.setDisplay(reportLinkDispTokens.nextToken());
                linkItem.setObjectClass(objectClass);
            }
        }
        return linksList;
    }

    private static void setSubscriptions(XMLParameters interactionsParams, ServiceLogger logger, ManualTask manualTask) throws PipelineException {
        String events = ParamUtils.validate(interactionsParams, "events", logger);
        try {
            if (events != null) {
                JSONObject jsonObj = JSONObject.parse((String)events);
                Iterator eventKeys = jsonObj.keySet().iterator();
                while (eventKeys.hasNext()) {
                    String event = ((String)eventKeys.next()).toString();
                    String state = String.valueOf(jsonObj.get((Object)event));
                    SubscriptionEventState.Enum subscribed = SubscriptionEventState.Enum.forString((String)state);
                    SubscriptionEventType.Enum subscriptionEventType = SubscriptionEventType.Enum.forString((String)event);
                    if (subscriptionEventType == null) continue;
                    if (subscriptionEventType.equals(SubscriptionEventType.COMPLETE_DEADLINE)) {
                        manualTask.setNotifyNotCompleted(subscribed);
                        continue;
                    }
                    if (subscriptionEventType.equals(SubscriptionEventType.NOTIFY_ON_CREATION)) {
                        manualTask.setNotifyOnCreation(subscribed);
                        continue;
                    }
                    if (subscriptionEventType.equals(SubscriptionEventType.START_DEADLINE)) {
                        manualTask.setNotifyNotStarted(subscribed);
                        continue;
                    }
                    if (subscriptionEventType.equals(SubscriptionEventType.STATE_CHANGE_COMPLETED)) {
                        manualTask.setStateChangeCompleted(subscribed);
                        continue;
                    }
                    if (subscriptionEventType.equals(SubscriptionEventType.STATE_CHANGE_CANCELLED)) {
                        manualTask.setStateChangeCancelled(subscribed);
                        continue;
                    }
                    if (subscriptionEventType.equals(SubscriptionEventType.STATE_CHANGE_FAILED)) {
                        manualTask.setStateChangeFailed(subscribed);
                        continue;
                    }
                    if (subscriptionEventType.equals(SubscriptionEventType.STATE_CHANGE_ON_HOLD)) {
                        manualTask.setStateChangeSuspended(subscribed);
                        continue;
                    }
                    if (subscriptionEventType.equals(SubscriptionEventType.STATE_CHANGE_OWNER_CHANGED)) {
                        manualTask.setStateChangeOwner(subscribed);
                        continue;
                    }
                    if (subscriptionEventType.equals(SubscriptionEventType.STATE_CHANGE_STARTED)) {
                        manualTask.setStateChangeStarted(subscribed);
                        continue;
                    }
                    if (!subscriptionEventType.equals(SubscriptionEventType.COMMENTS)) continue;
                    manualTask.setComments(subscribed);
                }
            }
        }
        catch (IOException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void main(String[] argv) {
        ManualTaskDescription desc = ManualTaskDescription.Factory.newInstance();
        XmlCursor cursor = desc.newCursor();
        cursor.toFirstContentToken();
        cursor.insertChars("this is the message");
        cursor.dispose();
        desc.setContentType(CONTENT_TEXT_PLAIN);
        String wibble = desc.toString();
        System.out.println(wibble);
    }
}

