/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.utils;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.meta.Cookie;
import com.cognos.portal.fragment.meta.NamedList;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class MenuState {
    private static final boolean USE_COOKIES = true;
    private String sortBy;
    private String dateStyle;
    private String owner;
    private String myTasks;
    private String priority;
    private String taskType;
    private String status;
    private String dueDate;
    private String createDate;
    private String folderName;
    private String customFolders;
    private JSONObject menuStateCookie;
    private StageContext context;
    public static final String MENU_STATE_COOKIE = "hts_menu_state";

    public MenuState(StageContext context, ServiceLogger logger) throws PipelineException {
        this.context = context;
        try {
            this.getMenuStateCookie();
            this.sortBy = this.getParameterValue(context, "sort");
            this.dateStyle = this.getJSONParameterValue("dateStyle", logger);
            this.owner = this.getJSONParameterValue("Task.ActualOwner", logger);
            this.myTasks = this.getJSONParameterValue("MY_TASKS", logger);
            this.priority = this.getJSONParameterValue("Task.Priority", logger);
            this.taskType = this.getJSONParameterValue("Task.Type", logger);
            this.status = this.getJSONParameterValue("Task.Status", logger);
            this.dueDate = this.getJSONParameterValue("Task.DueDate", logger);
            this.createDate = this.getJSONParameterValue("Task.CreateDate", logger);
            this.folderName = context.getCustomsParams().getValue("folderName");
            this.customFolders = this.getJSONParameterValue("Task.Application", logger);
        }
        catch (Exception e) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("Process 'menu state' failed to execute", (Throwable)e);
            }
            throw new PipelineException("could not read inputs", (Throwable)e);
        }
    }

    private void getMenuStateCookie() throws IOException {
        String menuStateCookieString = null;
        NamedList cookies = this.context.getRequestCookies();
        for (int i = 0; cookies != null && i < cookies.size(); ++i) {
            Cookie cookie = (Cookie)cookies.get(i);
            if (!MENU_STATE_COOKIE.equals(cookie.getName())) continue;
            menuStateCookieString = cookie.getValue();
            break;
        }
        if (menuStateCookieString != null) {
            menuStateCookieString = URLDecoder.decode(menuStateCookieString, "UTF-8");
            this.menuStateCookie = JSONObject.parse((String)menuStateCookieString);
        }
    }

    private String getJSONParameterValue(String transientParamName, ServiceLogger logger) throws PipelineException {
        String paramValue = null;
        try {
            String transientParamValue = this.getParameterValue(this.context, transientParamName);
            paramValue = this.getJSONParameterValue(transientParamValue);
        }
        catch (IOException ex) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("Process 'query' failed to execute", (Throwable)ex);
            }
            throw new PipelineException("could not read inputs", (Throwable)ex);
        }
        return paramValue;
    }

    private String getJSONParameterValue(String transientParamValue) throws IOException {
        String paramValue = null;
        if (transientParamValue != null && transientParamValue.length() > 0) {
            JSONObject json = JSONObject.parse((String)transientParamValue);
            Object val = json.get((Object)"value");
            paramValue = val == null ? null : val.toString();
        }
        return paramValue;
    }

    public String getParameterValue(StageContext context, String param) throws IOException {
        String value = context.getInteractionParams().getValue(param);
        if (!param.endsWith("[]") && (value == null || value != null && value.length() == 0)) {
            value = context.getInteractionParams().getValue(param + "[]");
        }
        if (value == null) {
            value = this.getCookieValue(param);
        }
        return value;
    }

    private String getCookieValue(String key) throws IOException {
        if (this.menuStateCookie == null) {
            return null;
        }
        String response = null;
        Object val = this.menuStateCookie.get((Object)key);
        if (val != null) {
            response = val.toString();
        }
        return response;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getDateStyle() {
        return this.dateStyle;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getMyTasks() {
        return this.myTasks;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public List<String> getCustomFolders() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.customFolders == null) {
            return list;
        }
        try {
            JSONArray jsonArr = JSONArray.parse((String)("[" + this.customFolders + "]"));
            JSONArray jsonArr2 = (JSONArray)jsonArr.get(0);
            for (JSONObject folder : jsonArr2) {
                String id = folder.get((Object)"id").toString();
                list.add(id);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }
}

