/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.utils;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameter;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.schemas.fragments.Param;
import com.cognos.portal.schemas.fragments.Params;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.ibm.cognos.internal.hts.fragment.context.UsvPipelineContext;
import java.util.ArrayList;

public class ParamUtils {
    public static Params addParameter(Params params, String name, String value) {
        Param param = new Param();
        param.setName(name);
        param.setValue(value);
        params.addParam(param);
        return params;
    }

    public static boolean hasParam(XMLParameters params, String param) {
        return params.getValue(param) != null && params.getValue(param).length() > 0;
    }

    public static boolean hasParam(UsvPipelineContext context, String param) {
        return context.getParameterValue(param) != null && context.getParameterValue(param).length() > 0;
    }

    public static boolean paramExists(XMLParameters params, String param) {
        return params.getValue(param) != null;
    }

    public static String[] validateMultiple(XMLParameters interactionParams, String paramPrefix, ServiceLogger logger) throws PipelineException {
        ArrayList<String> values = new ArrayList<String>();
        for (XMLParameter xmlParam : interactionParams) {
            if (!xmlParam.getName().startsWith(paramPrefix)) continue;
            values.add(xmlParam.getValue());
        }
        if (values.isEmpty()) {
            logger.error("Invalid parameter for " + paramPrefix);
            throw new PipelineException("pf.pipeline.process.error");
        }
        return values.toArray(new String[values.size()]);
    }

    public static String validate(XMLParameters interactionParams, String param, ServiceLogger logger) throws PipelineException {
        String value = interactionParams.getValue(param);
        if (param == null || param != null && param.length() == 0) {
            logger.error("Invalid parameter for " + param + "value:" + value);
            throw new PipelineException("pf.pipeline.process.error");
        }
        if (!param.endsWith("[]") && (value == null || value != null && value.length() == 0)) {
            value = interactionParams.getValue(param + "[]");
        }
        return value;
    }

    public static boolean isValid(String value) {
        return value != null && value.length() > 0 && !value.equals("null");
    }
}

