/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.fragment.utils;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.fragment.service.ServiceEnvironment;
import com.ibm.cognos.internal.hts.fragment.utils.IUtils;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskReadBy;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.status.StateManagement;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.xmlbeans.XmlDateTime;
import org.apache.xmlbeans.XmlException;
import org.dom4j.Element;
import org.dom4j.Node;

public class Utils
implements IUtils {
    private static IUtils m_instance = new Utils();

    public static IUtils instance() {
        return m_instance;
    }

    public static void setInstance(IUtils utils) {
        m_instance = utils;
    }

    @Override
    public String getUserName(String camId, Locale locale, StageContext context) throws HumanTaskServiceException {
        String strUserName = null;
        if (camId == null || camId.trim().equals("")) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_CAM_ID);
        }
        strUserName = context.getEnv().getUserName();
        if (strUserName == "") {
            strUserName = I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_USV_UNKNOWN_OWNER, (Locale)locale);
        }
        return strUserName;
    }

    @Override
    public String getFormattedDate(Node dateNode, StageContext context, ServiceLogger logger) {
        String dateText = "";
        if (dateNode != null) {
            dateText = dateNode.getText();
        }
        return this.getFormattedDate(dateText, context, logger);
    }

    @Override
    public String getFormattedDate(String dateText, StageContext context, ServiceLogger logger) {
        String strFormattedValue = "";
        DateFormat dateFormatter = null;
        Locale productLocale = null;
        TimeZone userTimeZone = null;
        Calendar cal = null;
        try {
            if (dateText != null && !dateText.trim().equals("")) {
                cal = this.getCalendarValueFromDateString(dateText);
                productLocale = this.getProductLocale(context);
                dateFormatter = DateFormat.getDateTimeInstance(2, 2, productLocale);
                userTimeZone = this.getUserTimeZone(context);
                dateFormatter.setTimeZone(userTimeZone);
                strFormattedValue = dateFormatter.format(cal.getTime());
            }
        }
        catch (Exception ex) {
            strFormattedValue = this.handleDateFormatException(dateText, logger, ex);
        }
        return strFormattedValue;
    }

    @Override
    public String getFormattedDateForDatePicker(Node dateNode, StageContext context, ServiceLogger logger) {
        String dateText = "";
        if (dateNode != null) {
            dateText = dateNode.getText();
        }
        return this.getFormattedDateForDatePicker(dateText, context, logger);
    }

    @Override
    public String getFormattedDateForDatePicker(String dateText, StageContext context, ServiceLogger logger) {
        String strFormattedValue = "";
        SimpleDateFormat simpleDateFormatter = null;
        TimeZone userTimeZone = null;
        Calendar cal = null;
        try {
            if (dateText != null && !dateText.trim().equals("")) {
                cal = this.getCalendarValueFromDateString(dateText);
                userTimeZone = this.getUserTimeZone(context);
                simpleDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                simpleDateFormatter.setTimeZone(userTimeZone);
                strFormattedValue = simpleDateFormatter.format(cal.getTime());
            }
        }
        catch (Exception ex) {
            strFormattedValue = this.handleDateFormatException(dateText, logger, ex);
        }
        return strFormattedValue;
    }

    private Calendar getCalendarValueFromDateString(String dateText) throws XmlException {
        XmlDateTime xmlDateTime = null;
        Calendar cal = null;
        dateText = "<xml-fragment>" + dateText + "</xml-fragment>";
        xmlDateTime = XmlDateTime.Factory.parse((String)dateText);
        cal = xmlDateTime.getCalendarValue();
        return cal;
    }

    public TimeZone getUserTimeZone(StageContext context) {
        String strUserTimeZone = null;
        TimeZone userTimeZone = null;
        try {
            strUserTimeZone = this.getUserPreferenceValue(context, "timeZoneID");
            userTimeZone = strUserTimeZone != null && !strUserTimeZone.trim().equals("") ? TimeZone.getTimeZone(strUserTimeZone) : TimeZone.getDefault();
        }
        catch (Exception ex) {
            userTimeZone = TimeZone.getDefault();
        }
        return userTimeZone;
    }

    public String getUserPreferenceValue(StageContext context, String userPreferencePropertyName) throws Exception {
        String strPropertyValue = null;
        Environment env = null;
        ServiceEnvironment serviceEnvironment = null;
        BIBusEnvelope biBusEnvelope = null;
        if (context != null && userPreferencePropertyName != null && !userPreferencePropertyName.trim().equals("") && (env = context.getEnv()) instanceof ServiceEnvironment && (biBusEnvelope = (serviceEnvironment = (ServiceEnvironment)env).getEnvelope()) != null) {
            strPropertyValue = biBusEnvelope.getUserPreferenceValue(userPreferencePropertyName);
        }
        return strPropertyValue;
    }

    public Locale getProductLocale(StageContext context) {
        Locale productLocale;
        block2: {
            String strProductLocale = null;
            productLocale = null;
            Environment env = null;
            try {
                env = context.getEnv();
                strProductLocale = env.getProductLocale();
                productLocale = strProductLocale != null && !strProductLocale.trim().equals("") ? new Locale(strProductLocale) : Locale.getDefault();
            }
            catch (Exception ex) {
                if (productLocale != null) break block2;
                productLocale = Locale.getDefault();
            }
        }
        return productLocale;
    }

    @Override
    public int countUsersInRole(Element roleElement, StageContext context, ServiceLogger logger, String stageName) {
        int count;
        try {
            if (roleElement != null) {
                Iterator iterator = roleElement.elementIterator("users");
                for (count = 0; iterator != null && iterator.hasNext() && count < 3; ++count) {
                }
                iterator = roleElement.elementIterator("groups");
                while (iterator != null && iterator.hasNext() && count < 3) {
                    ++count;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    @Override
    public void appendMethodCapabilities(Element taskAbstract, StageContext context, List<HTSRole.Roles> roles, TStatus.Enum status, HTSTask.TYPE type, String[] allowedMethods) throws HumanTaskServiceException {
        ArrayList<String> allowedList = new ArrayList<String>(Arrays.asList(allowedMethods));
        HashMap<String, Boolean> methodMap = new HashMap<String, Boolean>();
        Node isSkipableNode = taskAbstract.selectSingleNode("*[local-name()='isSkipable']");
        String skipable = isSkipableNode == null ? "false" : isSkipableNode.getText();
        Node readLevelNode = taskAbstract.selectSingleNode("*[local-name()='taskReadLevelForCurrentUser']");
        HTSTaskReadBy.READ_LEVEL readLevel = readLevelNode == null || readLevelNode != null && readLevelNode.getText().equals("") ? HTSTaskReadBy.READ_LEVEL.LOOKED_AT : HTSTaskReadBy.READ_LEVEL.valueOf((String)readLevelNode.getText());
        boolean methodValid = Boolean.valueOf(skipable);
        this.addToCapabilityMap(true, "delegate", allowedList, methodMap, status, roles, type, readLevel);
        this.addToCapabilityMap(true, "claim", allowedList, methodMap, status, roles, type, readLevel);
        this.addToCapabilityMap(true, "complete", allowedList, methodMap, status, roles, type, readLevel);
        this.addToCapabilityMap(true, "completeNotification", allowedList, methodMap, status, roles, type, readLevel);
        this.addToCapabilityMap(true, "updateTaskDetails", allowedList, methodMap, status, roles, type, readLevel);
        this.addToCapabilityMap(methodValid, "skip", allowedList, methodMap, status, roles, type, readLevel);
        HTSSDKUtils.setValidMethods((Element)taskAbstract, methodMap);
    }

    @Override
    public List<HTSRole.Roles> getRolesForTask(Element taskAbstract, StageContext context) {
        String cam_id = context.getEnv().getUserID();
        if (cam_id.equals("__unknown__")) {
            cam_id = "CAMID(\"::Anonymous\")";
        }
        String xPath = "./*[local-name()='roles']/*[local-name()='role']";
        List nodeList = taskAbstract.selectNodes(xPath);
        ArrayList<HTSRole.Roles> roles = new ArrayList<HTSRole.Roles>();
        for (Node node : nodeList) {
            String text = node.getText();
            HTSRole.Roles role = HTSRole.Roles.findRole((String)text);
            if (HTSRole.Roles.ANY.equals((Object)role)) continue;
            roles.add(role);
        }
        return roles;
    }

    @Override
    public String getTaskProperty(Element taskAbstract, String propName) {
        String text = "";
        Node childNode = taskAbstract.selectSingleNode("./*[local-name()='" + propName + "']");
        if (childNode != null) {
            text = childNode.getText();
        }
        return text;
    }

    private void addToCapabilityMap(boolean valid, String method, List<String> allowedList, Map<String, Boolean> methodMap, TStatus.Enum status, List<HTSRole.Roles> roles, HTSTask.TYPE type, HTSTaskReadBy.READ_LEVEL readLevel) {
        if (allowedList.isEmpty() || allowedList.contains(method)) {
            boolean methodValid = valid && this.validateOperation(method, roles, status, type, readLevel);
            methodMap.put(method, methodValid);
        }
    }

    private boolean validateOperation(String op, List<HTSRole.Roles> roles, TStatus.Enum status, HTSTask.TYPE type, HTSTaskReadBy.READ_LEVEL readLevel) {
        boolean valid = false;
        try {
            new StateManagement(op, roles.toArray(new HTSRole.Roles[0]), status, type, readLevel);
            valid = true;
        }
        catch (HumanTaskServiceException e) {
            e.getMessage();
        }
        return valid;
    }

    private String handleDateFormatException(String text, ServiceLogger logger, Exception ex) {
        if (logger != null && logger.isErrorEnabled()) {
            logger.error("There was an ERROR formatting the date.", (Throwable)ex);
        }
        String strFormattedValue = "";
        if (text != null && !text.trim().equals("")) {
            strFormattedValue = text;
        }
        return strFormattedValue;
    }
}

