/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.common;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.common.ValidatorExceptionImpl;
import com.cognos.validator.common.VerifyExceptionImpl;

public class ExceptionHelper {
    private static void throwValidatorCauseOnly(Throwable cause) throws ValidatorExceptionImpl {
        throw new ValidatorExceptionImpl(cause);
    }

    public static void throwValidator(Message message) throws ValidatorException {
        ExceptionHelper.throwValidator(null, new Messages(message));
    }

    public static void throwValidator(Messages messages) throws ValidatorException {
        ExceptionHelper.throwValidator(null, messages);
    }

    public static void throwValidator(Throwable cause) throws ValidatorException {
        ExceptionHelper.throwValidatorCauseOnly(cause);
    }

    public static void throwValidator(Throwable cause, Message message) throws ValidatorException {
        ExceptionHelper.throwValidator(cause, new Messages(message));
    }

    public static void throwValidator(Throwable cause, Messages messages) throws ValidatorException {
        if (cause == null) {
            if (messages == null) {
                throw new ValidatorExceptionImpl();
            }
            throw new ValidatorExceptionImpl(messages.toString());
        }
        if (messages != null) {
            throw new ValidatorExceptionImpl(messages.toString(), cause);
        }
        ExceptionHelper.throwValidatorCauseOnly(cause);
    }

    public static void throwVerify(Throwable cause, Message message) throws VerifyException {
        ExceptionHelper.throwVerify(cause, new Messages(message));
    }

    public static void throwVerify(Messages messages) throws VerifyException {
        throw new VerifyExceptionImpl(messages == null ? null : messages.toString(), null);
    }

    public static void throwVerify(Throwable cause, Messages messages) throws VerifyException {
        throw new VerifyExceptionImpl(cause, messages == null ? null : messages.toString(), null);
    }

    public static void throwVerify(Messages failureDetails, Messages validatorDetails) throws VerifyException {
        throw new VerifyExceptionImpl(failureDetails == null ? null : failureDetails.toString(), validatorDetails == null ? null : validatorDetails.toString());
    }
}

