/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.common;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.validator.api.Document;
import com.cognos.validator.api.IImportResolver;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.ValidatorFactory;
import com.cognos.validator.api.VerifySession;
import com.cognos.validator.common.ExceptionHelper;
import com.cognos.validator.common.IFactoryAgent;
import com.cognos.validator.common.Log;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.VerifySessionImpl;
import com.cognos.validator.document.DocumentImpl;
import com.cognos.validator.document.DocumentObject;
import com.cognos.validator.document.Parameter;
import com.cognos.validator.document.Rule;
import com.cognos.validator.document.Sign;
import com.cognos.validator.document.Type;
import com.cognos.validator.util.SchemaValidator;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FactoryImpl
extends ValidatorFactory
implements IFactoryAgent {
    private static boolean m_initialized = false;
    private static final String CAM_INIT_PARAM = "<initializeDocument><serviceID>validator</serviceID></initializeDocument>";
    private boolean m_mandatoryRules = false;
    private boolean m_cacheTargetIds = false;
    private boolean m_documentSchemaChecking = false;
    private List m_importResolvers = Collections.synchronizedList(new LinkedList());
    private Set m_targetIds = Collections.synchronizedSet(new HashSet());

    @Override
    public void put(int property, boolean value) throws ValidatorException {
        if (property < 0 || property > 2) {
            ExceptionHelper.throwValidator(new Message("invalid property", "property", String.valueOf(property)));
        }
        switch (property) {
            case 0: {
                this.m_mandatoryRules = value;
                break;
            }
            case 1: {
                this.m_cacheTargetIds = value;
                break;
            }
            case 2: {
                this.m_documentSchemaChecking = value;
            }
        }
    }

    public static synchronized void initializeStatics() throws ValidatorException {
        if (!m_initialized) {
            Log.initialize();
            CAMFactory camFactory = new CAMFactory();
            try {
                camFactory.initialize(CAM_INIT_PARAM.getBytes("UTF-8"));
            }
            catch (Exception e) {
                ExceptionHelper.throwValidator((Throwable)e, new Message("CAM factory initialize failed"));
            }
            DocumentImpl.initialize(camFactory);
            DocumentObject.initialize();
            Type.initialize();
            Parameter.initialize();
            Rule.initialize();
            Sign.initialize(camFactory);
            SchemaValidator.initialize();
            m_initialized = true;
        }
    }

    public FactoryImpl() throws ValidatorException {
        FactoryImpl.initializeStatics();
    }

    @Override
    public Document createDocument() throws ValidatorException {
        return new DocumentImpl(this);
    }

    @Override
    public void addImportResolver(IImportResolver ir) throws ValidatorException {
        if (ir == null) {
            ExceptionHelper.throwValidator(new Message("null import resolver not allowed"));
        }
        this.m_importResolvers.add(ir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader xmlDocument(String namespace) {
        Reader result = null;
        boolean done = false;
        IImportResolver ir = null;
        List list = this.m_importResolvers;
        synchronized (list) {
            Iterator i = this.m_importResolvers.iterator();
            while (!done && i.hasNext()) {
                ir = (IImportResolver)i.next();
                result = ir.xmlDocument(namespace);
                if (result == null) continue;
                done = true;
            }
        }
        return result;
    }

    @Override
    public boolean mandatoryRules() {
        return this.m_mandatoryRules;
    }

    @Override
    public boolean cacheTargetIds() {
        return this.m_cacheTargetIds;
    }

    @Override
    public Set targetIds() {
        return this.m_targetIds;
    }

    @Override
    public VerifySession createVerifySession(Document doc) throws ValidatorException {
        return new VerifySessionImpl(doc);
    }

    @Override
    public boolean documentSchemaChecking() {
        return this.m_documentSchemaChecking;
    }
}

