/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.common;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Log {
    public static final int TOP = 50000;
    public static final int INFO = 30000;
    public static final int DEBUG = 10000;
    private static final int WARNING_LEVEL = 40000;
    private static final String VALIDATOR = "validator";
    public static final String TYPE_GENERAL = "general";
    public static final String TYPE_PARSER = "parser";
    public static final String TYPE_VERIFY = "verify";
    public static boolean traceEnabled = false;
    private static LogTypedLogger m_auditLogger = null;
    private static Map m_traceLoggers = new HashMap();

    public static void initialize() {
        m_traceLoggers.put(TYPE_GENERAL, LogTypedLogger.getInstance((String)"Trace.validator.general", LogTraceIndication.class));
        m_traceLoggers.put(TYPE_PARSER, LogTypedLogger.getInstance((String)"Trace.validator.parser", LogTraceIndication.class));
        m_traceLoggers.put(TYPE_VERIFY, LogTypedLogger.getInstance((String)"Trace.validator.verify", LogTraceIndication.class));
        m_auditLogger = LogTypedLogger.getInstance((String)"Audit.validator", LogAuditIndication.class);
        Collection c = m_traceLoggers.values();
        LogTypedLogger logger = null;
        Iterator i = c.iterator();
        while (i.hasNext() && !traceEnabled) {
            logger = (LogTypedLogger)i.next();
            traceEnabled = logger.isEnabled(50000);
        }
    }

    private static void logToIPFAudit(int indicationLevel, String status, Message message) {
        if (m_auditLogger.isEnabled(indicationLevel)) {
            LogAuditIndication indication = null;
            if (indicationLevel == 20000 || indicationLevel == 10000) {
                indication = new LogAuditIndication(VALIDATOR, 0);
            } else {
                LogAuditAccessIndication accessIndication = new LogAuditAccessIndication(VALIDATOR, 0);
                accessIndication.setStatus(status);
                indication = accessIndication;
            }
            indication.setLevel(indicationLevel);
            indication.setOperation("Request");
            indication.setLogData(message.toString());
            m_auditLogger.log((Object)indication);
        }
    }

    private static void logToIPFTrace(int indicationLevel, String loggerType, Message message) {
        LogTypedLogger traceLogger = (LogTypedLogger)m_traceLoggers.get(loggerType);
        if (traceLogger.isEnabled(indicationLevel)) {
            LogTraceIndication indication = new LogTraceIndication(VALIDATOR, 0);
            indication.setLevel(indicationLevel);
            indication.setObject(VALIDATOR);
            indication.setAction((byte)11);
            indication.setMessage(message.toString());
            traceLogger.log((Object)indication);
        }
    }

    public static void warn(Message message) {
        Log.logToIPFAudit(40000, "Warning", message);
    }

    public static void trace(Messages messages, int indicationLevel, String loggerType) {
        Log.trace(new Message(messages.toString()), indicationLevel, loggerType);
    }

    public static void trace(Message message, int indicationLevel) {
        Log.trace(message, indicationLevel, null);
    }

    public static void trace(Message message, int indicationLevel, String loggerType) {
        if (traceEnabled) {
            if (loggerType == null) {
                loggerType = TYPE_GENERAL;
            }
            Log.logToIPFTrace(indicationLevel, loggerType, message);
        }
    }
}

