/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class ValidDomainManager {
    private final HashMap<String, HashSet<String>> m_validExactDomains = new HashMap();
    private final HashMap<String, HashSet<String>> m_validHighLevelDomains = new HashMap();
    public static final String IBM_COGNOS_GLOBAL_DOMAIN = "ibm.cognos.global";

    public boolean addDomain(String value) {
        return this.addDomain(IBM_COGNOS_GLOBAL_DOMAIN, value);
    }

    public boolean addDomain(String clientName, String value) {
        if (value.startsWith(".")) {
            this.updateDomains(this.m_validExactDomains, clientName, value);
            return true;
        }
        if (value.startsWith("*.")) {
            this.updateDomains(this.m_validHighLevelDomains, clientName, value.substring(1));
            return true;
        }
        return false;
    }

    private void updateDomains(HashMap<String, HashSet<String>> mapToUpdate, String clientName, String value) {
        HashSet<String> valSet = mapToUpdate.get(clientName);
        if (valSet == null) {
            valSet = new HashSet();
        }
        valSet.add(value);
        mapToUpdate.put(clientName, valSet);
    }

    public void resetDomains(String clientName) {
        this.resetDomains(this.m_validExactDomains, clientName);
        this.resetDomains(this.m_validHighLevelDomains, clientName);
    }

    private void resetDomains(HashMap<String, HashSet<String>> mapToUpdate, String clientName) {
        if (mapToUpdate.containsKey(clientName)) {
            mapToUpdate.remove(clientName);
        }
    }

    public void clear() {
        this.m_validExactDomains.clear();
        this.m_validHighLevelDomains.clear();
    }

    public HashSet<String> getValidDomains() {
        HashSet<String> combinedSet = new HashSet<String>();
        combinedSet.addAll(this.getValidDomains(this.m_validExactDomains, IBM_COGNOS_GLOBAL_DOMAIN));
        combinedSet.addAll(this.getValidDomains(this.m_validHighLevelDomains, IBM_COGNOS_GLOBAL_DOMAIN));
        return combinedSet;
    }

    public HashSet<String> getValidDomains(String clientName) {
        HashSet<String> combinedSet = new HashSet<String>();
        combinedSet.addAll(this.getValidDomains());
        combinedSet.addAll(this.getValidDomains(this.m_validExactDomains, clientName));
        combinedSet.addAll(this.getValidDomains(this.m_validHighLevelDomains, clientName));
        return combinedSet;
    }

    private HashSet<String> getValidDomains(HashMap<String, HashSet<String>> mapToProcess, String clientName) {
        HashSet<String> combinedSet = new HashSet<String>();
        try {
            combinedSet.addAll((Collection<String>)mapToProcess.get(clientName));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return combinedSet;
    }

    private HashSet<String> getExactValidDomains() {
        return this.getValidDomains(this.m_validExactDomains, IBM_COGNOS_GLOBAL_DOMAIN);
    }

    public HashSet<String> getExactValidDomains(String clientName) {
        HashSet<String> combinedSet = new HashSet<String>();
        combinedSet.addAll(this.getValidDomains(this.m_validExactDomains, IBM_COGNOS_GLOBAL_DOMAIN));
        if (!clientName.equalsIgnoreCase(IBM_COGNOS_GLOBAL_DOMAIN)) {
            combinedSet.addAll(this.getValidDomains(this.m_validExactDomains, clientName));
        }
        return combinedSet;
    }

    private HashSet<String> getHighLevelValidDomains() {
        return this.getValidDomains(this.m_validHighLevelDomains, IBM_COGNOS_GLOBAL_DOMAIN);
    }

    public HashSet<String> getHighLevelValidDomains(String clientName) {
        HashSet<String> combinedSet = new HashSet<String>();
        combinedSet.addAll(this.getValidDomains(this.m_validHighLevelDomains, IBM_COGNOS_GLOBAL_DOMAIN));
        if (!clientName.equalsIgnoreCase(IBM_COGNOS_GLOBAL_DOMAIN)) {
            combinedSet.addAll(this.getValidDomains(this.m_validHighLevelDomains, clientName));
        }
        return combinedSet;
    }

    public boolean isValid(String domain) {
        boolean ret = false;
        if (this.getExactValidDomains().contains(domain)) {
            ret = true;
        } else {
            for (String validHighLevelDomain : this.getHighLevelValidDomains()) {
                if (!domain.endsWith(validHighLevelDomain)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public boolean isValid(String clientName, String domain) {
        boolean ret = false;
        if (this.getExactValidDomains(clientName).contains(domain)) {
            ret = true;
        } else {
            for (String validHighLevelDomain : this.getHighLevelValidDomains(clientName)) {
                if (!domain.endsWith(validHighLevelDomain)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("validExactDomains=");
        sb.append(this.m_validExactDomains.values().toString());
        sb.append(" validHighLevelDomains=");
        sb.append(this.m_validHighLevelDomains.values().toString());
        return sb.toString();
    }
}

