/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.common;

import com.cognos.validator.api.Document;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.api.VerifySession;
import com.cognos.validator.common.ExceptionHelper;
import com.cognos.validator.common.IVerifyAgent;
import com.cognos.validator.common.Message;
import com.cognos.validator.document.DocumentImpl;

public class VerifySessionImpl
extends VerifySession
implements IVerifyAgent {
    private boolean m_ignoreUnknownParameters = false;
    private DocumentImpl m_documentImpl = null;

    VerifySessionImpl(Document doc) throws ValidatorException {
        if (doc == null) {
            ExceptionHelper.throwValidator(new Message("invalid null document"));
        }
        if (!(doc instanceof DocumentImpl)) {
            ExceptionHelper.throwValidator(new Message("invalid document class"));
        }
        this.m_documentImpl = (DocumentImpl)doc;
    }

    @Override
    public void put(int property, boolean value) throws ValidatorException {
        if (property < 0 || property > 0) {
            ExceptionHelper.throwValidator(new Message("invalid property", "property", String.valueOf(property)));
        }
        switch (property) {
            case 0: {
                this.m_ignoreUnknownParameters = value;
            }
        }
    }

    @Override
    public void prepare(IParameterUpdater parameterReader) throws ValidatorException {
        this.m_documentImpl.prepare(parameterReader);
    }

    @Override
    public void verify(IParameterUpdater parameterReader) throws VerifyException, ValidatorException {
        this.m_documentImpl.verify(parameterReader, this);
    }

    @Override
    public boolean ignoreUnknownParameters() {
        return this.m_ignoreUnknownParameters;
    }
}

