/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.IFactoryAgent;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.RefId;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamReader;

public abstract class Definition
implements IVerifier,
Serializable {
    protected RefId m_refId = null;
    protected IVerifier m_verifier = null;
    protected String m_type = null;
    private static final String ATTRIBUTE_ID = "id";

    protected Definition(XMLStreamReader sr, String docNamespace, IFactoryAgent factoryAgent, String type) throws ParserException {
        String id = sr.getAttributeValue(null, ATTRIBUTE_ID);
        if (id == null) {
            throw new ParserException(new Message("invalid null definition id"));
        }
        this.m_refId = new RefId(id, sr, docNamespace);
        this.m_type = type;
    }

    public RefId refId() {
        return this.m_refId;
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        return this.m_verifier.verify(value, messages, docAgent, nestingLevel + 1, null);
    }

    @Override
    public Messages description() {
        Messages m = new Messages(new Message(this.m_type + " definition", ATTRIBUTE_ID, this.m_refId.toString()));
        m.addChild(this.m_verifier.description());
        return m;
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List definitions, IDocAgent docAgent) throws ValidatorException {
        this.m_verifier.asJavaScript(jsDoc, definitions, docAgent);
    }
}

