/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.TimeoutSync;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.GenericHMACSession;
import com.cognos.validator.api.Document;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.common.ExceptionHelper;
import com.cognos.validator.common.IFactoryAgent;
import com.cognos.validator.common.IVerifyAgent;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.DocumentObject;
import com.cognos.validator.document.Parameter;
import com.cognos.validator.util.SchemaValidator;
import com.cognos.validator.util.Stream;
import com.cognos.validator.util.Web64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class DocumentImpl
extends Document {
    private static final int ESTIMATED_XML_SIZE = 16384;
    private static final char HMAC_SEPARATOR = '|';
    public static boolean m_compress = true;
    private static CAMFactory m_camFactory = null;
    private static XMLInputFactory m_inputFactory = null;
    private static WriterPreferenceReadWriteLock m_readWriteLock = new WriterPreferenceReadWriteLock();
    private static Sync m_readLock = new TimeoutSync(m_readWriteLock.readLock(), 8000L);
    private static Sync m_writeLock = new TimeoutSync(m_readWriteLock.writeLock(), 8000L);
    private transient DocumentObject m_documentObject = null;
    private IFactoryAgent m_factoryAgent = null;
    private transient Map m_userProperties = null;

    public static void initialize(CAMFactory camFactory) {
        m_inputFactory = XMLInputFactory.newInstance();
        m_camFactory = camFactory;
    }

    public static DocumentObject documentObjectFromXML(Reader xml, IFactoryAgent factoryAgent) throws ValidatorException {
        return DocumentImpl.documentObjectFromXML(xml, factoryAgent, "ibm.cognos.global");
    }

    public static DocumentObject documentObjectFromXML(Reader xml, IFactoryAgent factoryAgent, String clientName) throws ValidatorException {
        try {
            XMLStreamReader sr = m_inputFactory.createXMLStreamReader(xml);
            DocumentObject document = DocumentObject.loadFromCacheOrXML(sr, factoryAgent, clientName);
            return document;
        }
        catch (Exception e) {
            ExceptionHelper.throwValidator(e);
            return null;
        }
    }

    public DocumentImpl(IFactoryAgent factoryAgent) {
        this.m_factoryAgent = factoryAgent;
    }

    @Override
    public void setUserProperty(String name, String value) throws ValidatorException {
        if (name == null || name.length() == 0) {
            ExceptionHelper.throwValidator(new Message("invalid user property name"));
        }
        try {
            m_writeLock.acquire();
            try {
                if (this.m_userProperties == null) {
                    this.m_userProperties = new HashMap(1);
                }
                this.m_userProperties.put(name, value);
            }
            finally {
                m_writeLock.release();
            }
        }
        catch (InterruptedException e) {
            ExceptionHelper.throwValidator(e);
        }
    }

    @Override
    public String getUserProperty(String name) throws ValidatorException {
        String res = null;
        if (name == null || name.length() == 0) {
            ExceptionHelper.throwValidator(new Message("invalid user property name"));
        }
        try {
            m_readLock.acquire();
            try {
                if (this.m_userProperties != null) {
                    res = (String)this.m_userProperties.get(name);
                }
            }
            finally {
                m_readLock.release();
            }
        }
        catch (InterruptedException e) {
            ExceptionHelper.throwValidator(e);
        }
        return res;
    }

    @Override
    public void loadFromXML(Reader xml) throws ValidatorException {
        this.loadFromXML("ibm.cognos.global", xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromXML(String forClient, Reader xml) throws ValidatorException {
        DocumentObject documentObject = null;
        if (this.m_factoryAgent.documentSchemaChecking()) {
            StringBuffer sb = new StringBuffer(16384);
            Stream.readerToString(xml, sb);
            String strXML = sb.toString();
            new SchemaValidator().validate(new StringReader(strXML));
            documentObject = DocumentImpl.documentObjectFromXML(new StringReader(strXML), this.m_factoryAgent, forClient);
        } else {
            documentObject = DocumentImpl.documentObjectFromXML(xml, this.m_factoryAgent, forClient);
        }
        try {
            m_writeLock.acquire();
            try {
                this.m_documentObject = documentObject;
            }
            finally {
                m_writeLock.release();
            }
            this.m_documentObject.runImports();
        }
        catch (InterruptedException e) {
            ExceptionHelper.throwValidator(e);
        }
    }

    @Override
    public boolean loadFromNamespace(String namespace) throws ValidatorException {
        return this.loadFromNamespace("ibm.cognos.global", namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromNamespace(String forClient, String namespace) throws ValidatorException {
        boolean res = false;
        DocumentObject documentObject = DocumentObject.loadFromCache(namespace, forClient);
        if (documentObject != null) {
            block10: {
                boolean update = false;
                try {
                    m_readLock.acquire();
                    try {
                        update = this.m_documentObject != documentObject;
                    }
                    finally {
                        m_readLock.release();
                    }
                    if (!update) break block10;
                    m_writeLock.acquire();
                    try {
                        this.m_documentObject = documentObject;
                    }
                    finally {
                        m_writeLock.release();
                    }
                }
                catch (InterruptedException e) {
                    ExceptionHelper.throwValidator(e);
                }
            }
            res = true;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String compile(String targetId) throws ValidatorException {
        if (targetId == null || targetId.length() == 0) {
            ExceptionHelper.throwValidator(new Message("invalid target identifier"));
        }
        String res = null;
        byte[] web64Output = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = null;
        ObjectOutputStream oos = null;
        try {
            if (m_compress) {
                zos = new ZipOutputStream(baos);
                zos.putNextEntry(new ZipEntry("v"));
                oos = new ObjectOutputStream(zos);
            } else {
                oos = new ObjectOutputStream(baos);
            }
            m_readLock.acquire();
            try {
                oos.writeObject(this.m_documentObject);
                oos.writeObject(this.m_userProperties);
            }
            finally {
                m_readLock.release();
            }
            oos.close();
            byte[] bytes = baos.toByteArray();
            web64Output = Web64.encode(bytes);
            GenericHMACSession ghs = m_camFactory.createGenericHMACSession(targetId.getBytes("UTF-8"));
            byte[] hmac = ghs.protectData(bytes);
            byte[] web64HMAC = Web64.encode(hmac);
            StringBuffer buf = new StringBuffer(web64Output.length + web64HMAC.length + 2);
            buf.append(new String(web64HMAC, "UTF-8"));
            buf.append('|');
            buf.append(new String(web64Output, "UTF-8"));
            res = buf.toString();
            if (this.m_factoryAgent.cacheTargetIds()) {
                this.m_factoryAgent.targetIds().add(targetId);
            }
        }
        catch (Exception e) {
            ExceptionHelper.throwValidator(e);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromCompile(String compiledDoc, String targetId) throws ValidatorException, VerifyException {
        if (targetId == null || targetId.length() == 0) {
            ExceptionHelper.throwValidator(new Message("invalid target identifier"));
        }
        try {
            String hmac;
            int hmacPos = compiledDoc.indexOf(124);
            if (hmacPos == -1) {
                ExceptionHelper.throwValidator(new Message("HMAC separator not found", "expected HMAC separator", String.valueOf('|')));
            }
            if ((hmac = compiledDoc.substring(0, hmacPos)).length() == 0) {
                ExceptionHelper.throwValidator(new Message("invalid empty HMAC"));
            }
            byte[] byteHMAC = hmac.getBytes("UTF-8");
            byte[] web64DecodedHMAC = null;
            try {
                web64DecodedHMAC = Web64.decode(byteHMAC);
            }
            catch (ValidatorException e) {
                ExceptionHelper.throwVerify((Throwable)e, new Message("load from compile failed because of invalid web64 encoded HMAC", "HMAC", hmac));
            }
            String input = compiledDoc.substring(hmacPos + 1);
            if (input.length() == 0) {
                ExceptionHelper.throwValidator(new Message("invalid empty input"));
            }
            byte[] byteInput = input.getBytes("UTF-8");
            byte[] web64DecodedInput = null;
            try {
                web64DecodedInput = Web64.decode(byteInput);
            }
            catch (ValidatorException e) {
                ExceptionHelper.throwVerify((Throwable)e, new Message("load from compile failed because of invalid web64 encoded input", "input", input));
            }
            GenericHMACSession ghs = m_camFactory.createGenericHMACSession(targetId.getBytes("UTF-8"));
            if (!ghs.verifyData(web64DecodedHMAC, web64DecodedInput)) {
                Messages messages = new Messages(new Message("compiled document HMAC verify failed", "HMAC", hmac, "input", input));
                if (this.m_factoryAgent.cacheTargetIds() && this.m_factoryAgent.targetIds().size() > 1) {
                    messages.add(new Message("alternate target id verification for debugging purpose"));
                    Messages messages2 = new Messages();
                    Iterator i = this.m_factoryAgent.targetIds().iterator();
                    String t = null;
                    while (i.hasNext()) {
                        t = (String)i.next();
                        if (t.equals(targetId)) continue;
                        ghs.setPassword(t.getBytes("UTF-8"));
                        if (ghs.verifyData(web64DecodedHMAC, web64DecodedInput)) {
                            messages2.add(new Message("successfully verified", "target id", t));
                            continue;
                        }
                        messages2.add(new Message("failed to verified", "target id", t));
                    }
                    messages.addChild(messages2);
                }
                ExceptionHelper.throwVerify(messages);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(web64DecodedInput);
            ZipInputStream zis = null;
            ObjectInputStream ois = null;
            if (m_compress) {
                zis = new ZipInputStream(bais);
                zis.getNextEntry();
                ois = new ObjectInputStream(zis);
            } else {
                ois = new ObjectInputStream(bais);
            }
            m_writeLock.acquire();
            try {
                this.m_documentObject = (DocumentObject)ois.readObject();
                this.m_userProperties = (Map)ois.readObject();
                ois.close();
                if (this.m_documentObject != null) {
                    this.m_documentObject.setFactoryAgent(this.m_factoryAgent);
                    this.m_documentObject.runImports();
                }
            }
            finally {
                m_writeLock.release();
            }
        }
        catch (VerifyException e) {
            throw e;
        }
        catch (Exception e) {
            ExceptionHelper.throwValidator(e);
        }
    }

    public void prepare(IParameterUpdater paramUpdater) throws ValidatorException {
        try {
            m_readLock.acquire();
            try {
                this.m_documentObject.prepare(paramUpdater);
            }
            finally {
                m_readLock.release();
            }
        }
        catch (InterruptedException e) {
            ExceptionHelper.throwValidator(e);
        }
    }

    public void verify(IParameterUpdater paramUpdater, IVerifyAgent verifyAgent) throws VerifyException, ValidatorException {
        try {
            m_readLock.acquire();
            try {
                this.m_documentObject.verify(paramUpdater, verifyAgent);
            }
            finally {
                m_readLock.release();
            }
        }
        catch (InterruptedException e) {
            ExceptionHelper.throwValidator(e);
        }
    }

    @Override
    public String asJavaScript() throws ValidatorException {
        String res = null;
        try {
            m_readLock.acquire();
            try {
                res = this.m_documentObject.asJavaScript();
            }
            finally {
                m_readLock.release();
            }
        }
        catch (Exception e) {
            ExceptionHelper.throwValidator(e);
        }
        return res;
    }

    @Override
    public boolean isParameter(String parameterName) throws ValidatorException {
        if (parameterName == null || parameterName.length() == 0) {
            ExceptionHelper.throwValidator(new Message("invalid user property name"));
        }
        if (this.m_documentObject == null) {
            ExceptionHelper.throwValidator(new Message("documentObject undefined"));
        }
        Parameter res = null;
        try {
            m_readLock.acquire();
            try {
                res = this.m_documentObject.getParameterFromName(parameterName);
            }
            finally {
                m_readLock.release();
            }
        }
        catch (Exception e) {
            ExceptionHelper.throwValidator(e);
        }
        return res != null;
    }
}

