/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.api.IParameter;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.common.ExceptionHelper;
import com.cognos.validator.common.IFactoryAgent;
import com.cognos.validator.common.IVerifyAgent;
import com.cognos.validator.common.Log;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.Definition;
import com.cognos.validator.document.DocumentImpl;
import com.cognos.validator.document.Global;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.Import;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.Parameter;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.PatternDef;
import com.cognos.validator.document.RefId;
import com.cognos.validator.document.RuleDef;
import com.cognos.validator.document.StreamReaderHelper;
import com.cognos.validator.document.VerifierDoubleMap;
import com.cognos.validator.util.BooleanHolder;
import com.cognos.validator.util.Miscellaneous;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DocumentObject
implements IDocAgent,
Serializable {
    private static final long serialVersionUID = 731799801480284773L;
    public static final String RULE_TRUE = "true";
    public static final String RULE_FALSE = "false";
    private static final String ATTRIBUTE_NAMESPACE = "namespace";
    private static final String ELEMENT_VALIDATOR = "validator";
    private static final String ELEMENT_IMPORT = "import";
    private static final byte ELEMENT_ID_IMPORT = 0;
    private static final String ELEMENT_PATTERN_DEF = "patternDef";
    private static final byte ELEMENT_ID_PATTERN_DEF = 1;
    private static final String ELEMENT_RULE_DEF = "ruleDef";
    private static final byte ELEMENT_ID_RULE_DEF = 2;
    private static final String ELEMENT_GLOBAL = "global";
    private static final byte ELEMENT_ID_GLOBAL = 3;
    private static final String ELEMENT_PARAMETER = "parameter";
    private static final byte ELEMENT_ID_PARAMETER = 4;
    private static Map m_elementToId = new HashMap();
    private static VerifierDoubleMap m_staticVerifiers = new VerifierDoubleMap();
    private static Map m_documentMap = Collections.synchronizedMap(new HashMap());
    private Map m_nameParameters = null;
    private List m_namePatternParameters = null;
    private Map m_definitions = null;
    private List m_globals = null;
    private List m_imports = null;
    private String m_namespace = null;
    public transient boolean m_mandatoryRules = false;
    private transient boolean m_skipValidation = false;
    private transient List m_importedParamDocs = Collections.synchronizedList(new LinkedList());
    private transient IFactoryAgent m_factoryAgent = null;
    private transient Map m_parameterFromNameCache = Collections.synchronizedMap(new HashMap());
    private transient int m_jsParamNameFunctionIndex = 0;
    private transient int m_jsGlobalFunctionIndex = 0;
    private transient String m_asJavaScript = new String();

    public static void initialize() {
        m_elementToId.put(ELEMENT_IMPORT, new Byte(0));
        m_elementToId.put(ELEMENT_PATTERN_DEF, new Byte(1));
        m_elementToId.put(ELEMENT_RULE_DEF, new Byte(2));
        m_elementToId.put(ELEMENT_GLOBAL, new Byte(3));
        m_elementToId.put(ELEMENT_PARAMETER, new Byte(4));
        DocumentObject document = new DocumentObject("urn:cognos:validator:document:anyparameter");
        document.m_skipValidation = true;
        m_documentMap.put(document.m_namespace, document);
    }

    public static IVerifier verifier(RefId refId, IDocAgent docAgent) throws ValidatorException {
        IVerifier verifier = null;
        if (refId.namespace() == null) {
            verifier = docAgent.definition(refId);
        } else {
            BooleanHolder namespaceFound = new BooleanHolder();
            verifier = m_staticVerifiers.get(refId, namespaceFound);
            if (verifier == null && !namespaceFound.value) {
                DocumentObject.importNamespace(refId.namespace(), docAgent, false);
                verifier = m_staticVerifiers.get(refId);
            }
        }
        if (verifier == null) {
            Messages messages = new Messages(new Message("reference cannot be resolved"));
            messages.addChild(refId.description());
            ExceptionHelper.throwValidator(messages);
        }
        return verifier;
    }

    public static DocumentObject loadFromCacheOrXML(XMLStreamReader sr, IFactoryAgent factoryAgent, String clientName) throws XMLStreamException, ParserException, ValidatorException {
        DocumentObject document = null;
        if (!StreamReaderHelper.moveToNextSibling(sr, ELEMENT_VALIDATOR)) {
            throw new ParserException(new Message("no root validator element found"));
        }
        String namespace = sr.getAttributeValue(null, ATTRIBUTE_NAMESPACE);
        document = DocumentObject.loadFromCache(namespace, clientName);
        if (document == null) {
            document = new DocumentObject(sr, namespace, factoryAgent, clientName);
        }
        return document;
    }

    private DocumentObject(XMLStreamReader sr, String namespace, IFactoryAgent factoryAgent, String clientName) throws ParserException, XMLStreamException, ValidatorException {
        this.m_namespace = namespace;
        while (StreamReaderHelper.moveToNextSibling(sr)) {
            String elementName = sr.getLocalName();
            Byte b = (Byte)m_elementToId.get(elementName);
            if (b == null) {
                throw new ParserException(new Message("invalid validator document child", "name", elementName));
            }
            switch (b) {
                case 0: {
                    this.readImport(sr);
                    break;
                }
                case 1: {
                    this.readPatternDef(sr);
                    break;
                }
                case 2: {
                    this.readRuleDef(sr, clientName);
                    break;
                }
                case 3: {
                    this.readGlobal(sr);
                    break;
                }
                case 4: {
                    this.readParameter(sr, clientName);
                }
            }
        }
        this.setFactoryAgent(factoryAgent);
        if (this.m_namespace != null) {
            m_documentMap.put(this.m_namespace, this);
        }
    }

    public DocumentObject(String namespace) {
        this.m_namespace = namespace;
    }

    public static DocumentObject loadFromCache(String namespace, String clientName) {
        DocumentObject document = null;
        if (namespace != null && namespace.length() > 0) {
            document = (DocumentObject)m_documentMap.get(namespace);
        }
        return document;
    }

    public void setFactoryAgent(IFactoryAgent factoryAgent) {
        this.m_factoryAgent = factoryAgent;
        this.m_mandatoryRules = factoryAgent.mandatoryRules();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        if (this.m_namespace != null) {
            Map m = m_staticVerifiers.childMap(this.m_namespace);
            oos.writeObject(m);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, ValidatorException {
        ois.defaultReadObject();
        if (this.m_namespace != null) {
            Map m = (Map)ois.readObject();
            if (m != null) {
                m_staticVerifiers.putAll(this.m_namespace, m);
            }
            if (this.m_namespace.endsWith("urn:cognos:validator:document:anyparameter") && this.m_namespace.length() == "urn:cognos:validator:document:anyparameter".length()) {
                this.m_skipValidation = true;
            }
        }
        this.m_mandatoryRules = false;
        this.m_skipValidation = false;
        this.m_importedParamDocs = Collections.synchronizedList(new LinkedList());
        this.m_factoryAgent = null;
        this.m_parameterFromNameCache = Collections.synchronizedMap(new HashMap());
        this.m_asJavaScript = new String();
    }

    void readImport(XMLStreamReader sr) throws XMLStreamException, ParserException, ValidatorException {
        Import imprt = new Import(sr);
        if (this.m_imports == null) {
            this.m_imports = new LinkedList();
        }
        this.m_imports.add(imprt);
    }

    private void addDefinition(RefId refId, Definition definition) {
        if (this.m_definitions == null) {
            this.m_definitions = new HashMap();
        }
        if (this.m_namespace == null) {
            this.m_definitions.put(refId, definition);
        } else {
            m_staticVerifiers.put(refId, definition);
        }
    }

    void readPatternDef(XMLStreamReader sr) throws XMLStreamException, ParserException, ValidatorException {
        PatternDef pd = new PatternDef(sr, this.m_namespace, this.m_factoryAgent);
        RefId refId = pd.refId();
        this.addDefinition(refId, pd);
    }

    RuleDef readRuleDef(XMLStreamReader sr, String clientName) throws XMLStreamException, ParserException, ValidatorException {
        RuleDef rd = new RuleDef(sr, this.m_namespace, this.m_factoryAgent, clientName);
        RefId refId = rd.refId();
        this.addDefinition(refId, rd);
        return rd;
    }

    void readGlobal(XMLStreamReader sr) throws XMLStreamException, ParserException, ValidatorException {
        if (this.m_globals == null) {
            this.m_globals = new LinkedList();
        }
        Global g = new Global(sr, this.m_namespace);
        this.m_globals.add(g);
    }

    void readParameter(XMLStreamReader sr, String clientName) throws XMLStreamException, ParserException, ValidatorException {
        Parameter p = new Parameter(sr, this.m_namespace, clientName);
        if (p.usesNamePattern()) {
            if (this.m_namePatternParameters == null) {
                this.m_namePatternParameters = new LinkedList();
            }
            this.m_namePatternParameters.add(p);
        } else {
            String name;
            if (this.m_nameParameters == null) {
                this.m_nameParameters = new HashMap();
            }
            if (this.m_nameParameters.get(name = p.name()) != null) {
                throw new ParserException(new Message("parameter name is not unique", "name", name));
            }
            this.m_nameParameters.put(name, p);
        }
    }

    private static DocumentObject importNamespace(String namespace, IDocAgent docAgent, boolean parameter) throws ValidatorException {
        DocumentObject document = (DocumentObject)m_documentMap.get(namespace);
        if (document == null) {
            Reader r = docAgent.factoryAgent().xmlDocument(namespace);
            if (r == null) {
                ExceptionHelper.throwValidator(new Message("import namespace failed - null reader from import resolvers", ATTRIBUTE_NAMESPACE, namespace));
            }
            document = DocumentImpl.documentObjectFromXML(r, docAgent.factoryAgent());
            m_documentMap.put(namespace, document);
            if (parameter) {
                document.runImports();
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runImports() throws ValidatorException {
        if (this.m_imports != null) {
            Iterator i = this.m_imports.iterator();
            Import imprt = null;
            boolean parameter = true;
            String namespace = null;
            DocumentObject document = null;
            while (i.hasNext()) {
                imprt = (Import)i.next();
                parameter = imprt.parameter();
                namespace = imprt.namespace();
                document = DocumentObject.importNamespace(namespace, this, parameter);
                if (!parameter) continue;
                List list = this.m_importedParamDocs;
                synchronized (list) {
                    this.m_importedParamDocs.add(document);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyGlobals(String value, Messages messages, List failureVerifier) throws ValidatorException {
        boolean valid = true;
        if (this.m_globals != null) {
            Iterator globalsIterator = null;
            globalsIterator = this.m_globals.iterator();
            Global g = null;
            while (valid && globalsIterator.hasNext()) {
                g = (Global)globalsIterator.next();
                if (g.verify(value, messages, this, 0, null)) continue;
                List list = failureVerifier;
                synchronized (list) {
                    failureVerifier.add(g);
                }
                valid = false;
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyGlobalsInDocs(List documents, String value, Messages messages, List failureVerifier, Set visited) throws ValidatorException {
        Set set = visited;
        synchronized (set) {
            visited.add(documents);
        }
        boolean valid = true;
        Iterator i = documents.iterator();
        DocumentObject document = null;
        while (valid && i.hasNext()) {
            document = (DocumentObject)i.next();
            valid = document.verifyGlobals(value, messages, failureVerifier);
            if (!valid) continue;
            DocumentObject.copyLists(documents, document.m_importedParamDocs);
            if (documents == null || visited.contains(documents)) continue;
            valid = DocumentObject.verifyGlobalsInDocs(documents, value, messages, failureVerifier, visited);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyLists(List dest, List source) {
        List list = dest;
        synchronized (list) {
            dest = source;
        }
    }

    private Parameter matchParamName(String paramName) {
        Parameter parameter = null;
        if (this.m_nameParameters != null) {
            parameter = (Parameter)this.m_nameParameters.get(paramName);
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Parameter matchParamNameInDocs(List documents, String paramName, Set visited) throws ValidatorException {
        Set set = visited;
        synchronized (set) {
            visited.add(documents);
        }
        Parameter parameter = null;
        Iterator i = documents.iterator();
        DocumentObject document = null;
        while (parameter == null && i.hasNext()) {
            document = (DocumentObject)i.next();
            parameter = document.matchParamName(paramName);
            if (parameter != null) continue;
            DocumentObject.copyLists(documents, document.m_importedParamDocs);
            if (documents == null || visited.contains(documents)) continue;
            parameter = DocumentObject.matchParamNameInDocs(documents, paramName, visited);
        }
        return parameter;
    }

    private Parameter matchParamNamePattern(String paramName) throws ValidatorException {
        Parameter result = null;
        Parameter p = null;
        if (this.m_namePatternParameters != null) {
            Iterator i = this.m_namePatternParameters.iterator();
            while (result == null && i.hasNext()) {
                p = (Parameter)i.next();
                if (!p.checkForName(paramName, this)) continue;
                result = p;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Parameter matchParamNamePatternInDocs(List documents, String paramName, Set visited) throws ValidatorException {
        Set set = visited;
        synchronized (set) {
            visited.add(documents);
        }
        Parameter parameter = null;
        Iterator i = documents.iterator();
        i = documents.iterator();
        DocumentObject document = null;
        while (parameter == null && i.hasNext()) {
            document = (DocumentObject)i.next();
            parameter = document.matchParamNamePattern(paramName);
            if (parameter != null) continue;
            DocumentObject.copyLists(documents, document.m_importedParamDocs);
            if (documents == null || visited.contains(documents)) continue;
            parameter = DocumentObject.matchParamNamePatternInDocs(documents, paramName, visited);
        }
        return parameter;
    }

    protected Parameter getParameterFromName(String name) throws ValidatorException {
        Parameter parameterObject;
        if (name == null) {
            ExceptionHelper.throwValidator(new Message("invalid null parameter name"));
        }
        if ((parameterObject = (Parameter)this.m_parameterFromNameCache.get(name)) == null) {
            parameterObject = this.matchParamName(name);
            if (parameterObject == null) {
                if (this.m_importedParamDocs != null) {
                    parameterObject = DocumentObject.matchParamNameInDocs(this.m_importedParamDocs, name, Collections.synchronizedSet(new HashSet()));
                }
                if (parameterObject == null && (parameterObject = this.matchParamNamePattern(name)) == null && this.m_importedParamDocs != null) {
                    parameterObject = DocumentObject.matchParamNamePatternInDocs(this.m_importedParamDocs, name, Collections.synchronizedSet(new HashSet()));
                }
            }
            if (parameterObject != null) {
                this.m_parameterFromNameCache.put(name, parameterObject);
            }
        }
        return parameterObject;
    }

    protected void prepare(IParameterUpdater paramUpdater) throws ValidatorException {
        IParameter parameter = null;
        String paramName = null;
        String[] values = null;
        while (paramUpdater.hasNext()) {
            String[] modifiedValues;
            parameter = paramUpdater.next();
            paramName = parameter.name();
            Parameter paramObject = this.getParameterFromName(paramName);
            if (paramObject == null) continue;
            values = parameter.values();
            if (values == null) {
                ExceptionHelper.throwValidator(new Message("invalid null values in prepare"));
            }
            if ((modifiedValues = paramObject.sign(values)) == null) continue;
            parameter.setValues(modifiedValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verify(IParameterUpdater paramUpdater, IVerifyAgent verifyAgent) throws VerifyException, ValidatorException {
        if (!this.m_skipValidation) {
            boolean valid = true;
            Messages failureDetails = new Messages();
            IParameter parameter = null;
            String paramName = null;
            boolean unknownParameterFailure = false;
            List<Parameter> failureVerifier = Collections.synchronizedList(new ArrayList());
            while (paramUpdater.hasNext()) {
                unknownParameterFailure = false;
                parameter = paramUpdater.next();
                paramName = parameter.name();
                if (paramName == null || paramName.length() == 0) {
                    ExceptionHelper.throwValidator(new Message("null or empty parameter name is not valid"));
                }
                Parameter paramObject = this.getParameterFromName(paramName);
                boolean skipParam = false;
                if (paramObject == null) {
                    if (verifyAgent.ignoreUnknownParameters()) {
                        skipParam = true;
                    } else if (this.m_mandatoryRules) {
                        valid = false;
                        failureDetails.add(new Message("mandatory rules enable - parameter without a rule"));
                        unknownParameterFailure = true;
                    } else {
                        skipParam = true;
                        Log.warn(new Message("unknown parameter", "parameter name", paramName, "values", Miscellaneous.arrayToString(parameter.values())));
                    }
                }
                boolean skipGlobal = paramObject != null && paramObject.skipGlobal();
                String[] values = parameter.values();
                if (!skipParam && valid) {
                    if (values == null || values.length == 0) {
                        ExceptionHelper.throwValidator(new Message("null or empty value array received for parameter name", "parameter name", paramName));
                    }
                    String value = null;
                    StringBuffer modifiedValue = null;
                    for (int i = 0; i < values.length && valid; ++i) {
                        boolean signed;
                        value = values[i];
                        if (values == null) {
                            value = "";
                        }
                        if (signed = paramObject.signed()) {
                            if (modifiedValue == null) {
                                modifiedValue = new StringBuffer(value.length());
                            } else {
                                modifiedValue.setLength(0);
                            }
                        } else {
                            modifiedValue = null;
                        }
                        valid = paramObject.verify(value, failureDetails, this, 0, modifiedValue);
                        if (!valid) {
                            List<Parameter> list = failureVerifier;
                            synchronized (list) {
                                failureVerifier.add(paramObject);
                            }
                        }
                        if (valid && signed) {
                            String[] strArray = new String[]{modifiedValue.toString()};
                            parameter.setValues(strArray);
                        }
                        if (valid && !skipGlobal) {
                            if (this.verifyGlobals(value, failureDetails, failureVerifier)) {
                                if (this.m_importedParamDocs != null && !DocumentObject.verifyGlobalsInDocs(this.m_importedParamDocs, value, failureDetails, failureVerifier, Collections.synchronizedSet(new HashSet()))) {
                                    valid = false;
                                    failureDetails.add(new Message("global rule from imported document verify failed"));
                                }
                            } else {
                                valid = false;
                                failureDetails.add(new Message("global rule verify failed"));
                            }
                        }
                        if (valid) continue;
                        failureDetails.add(new Message("parameter value verify failed", "parameter value", value));
                    }
                }
                if (valid) continue;
                Message message = new Message("document verify failed", "parameter name", paramName);
                if (unknownParameterFailure || Log.traceEnabled) {
                    message.addDetail("values", Miscellaneous.arrayToString(values));
                }
                failureDetails.add(message);
                ExceptionHelper.throwVerify(failureDetails, failureVerifier.isEmpty() ? null : ((IVerifier)failureVerifier.get(0)).description());
            }
        }
    }

    @Override
    public IFactoryAgent factoryAgent() {
        return this.m_factoryAgent;
    }

    @Override
    public Definition definition(RefId refId) {
        Definition res = null;
        if (this.m_definitions != null) {
            res = (Definition)this.m_definitions.get(refId);
        }
        return res;
    }

    private static void definitionAsJavaScript(JavaScriptDocument jsDoc, Definition definition, List requiredDef, IDocAgent docAgent) throws ValidatorException {
        RefId refId = definition.refId();
        jsDoc.startFunction(refId.javaScriptId());
        jsDoc.addLine("var res = 0");
        definition.asJavaScript(jsDoc, requiredDef, docAgent);
        jsDoc.addLine("return res");
        jsDoc.endFunction();
    }

    private static void parametersAsJavaScript(JavaScriptDocument jsDoc, Map parameters, List namePatternParameters, List requiredDefinitions, IDocAgent docAgent) throws ValidatorException {
        Parameter parameter2 = null;
        Iterator<Object> i = null;
        if (parameters != null) {
            for (Parameter parameter2 : parameters.values()) {
                parameter2.asJavaScript(jsDoc, requiredDefinitions, docAgent);
            }
        }
        if (namePatternParameters != null) {
            for (Parameter parameter2 : namePatternParameters) {
                parameter2.asJavaScript(jsDoc, requiredDefinitions, docAgent);
            }
        }
    }

    private static void globalsAsJavaScript(JavaScriptDocument jsDoc, List globals, List requiredDefinitions, IDocAgent docAgent) throws ValidatorException {
        if (globals != null) {
            Iterator globalsIterator = null;
            globalsIterator = globals.iterator();
            Global g = null;
            while (globalsIterator.hasNext()) {
                g = (Global)globalsIterator.next();
                g.asJavaScript(jsDoc, requiredDefinitions, docAgent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importedParamGlobalAsJavaScriptInDocs(List documents, JavaScriptDocument jsDoc, Set visited, List requiredDef, IDocAgent docAgent) throws ValidatorException {
        Set set = visited;
        synchronized (set) {
            visited.add(documents);
        }
        Iterator i = documents.iterator();
        DocumentObject document = null;
        while (i.hasNext()) {
            document = (DocumentObject)i.next();
            DocumentObject.parametersAsJavaScript(jsDoc, document.m_nameParameters, document.m_namePatternParameters, requiredDef, docAgent);
            DocumentObject.globalsAsJavaScript(jsDoc, document.m_globals, requiredDef, docAgent);
            DocumentObject.copyLists(documents, document.m_importedParamDocs);
            if (documents == null || visited.contains(documents)) continue;
            DocumentObject.importedParamGlobalAsJavaScriptInDocs(documents, jsDoc, visited, requiredDef, docAgent);
        }
    }

    private void mandatoryRulesAsJavaScript(JavaScriptDocument jsDoc) {
        jsDoc.startFunction("_mandatoryRules");
        if (this.m_mandatoryRules) {
            jsDoc.addLine("return true");
        } else {
            jsDoc.addLine("return false");
        }
        jsDoc.endFunction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asJavaScript() throws ValidatorException {
        String string = this.m_asJavaScript;
        synchronized (string) {
            if (this.m_asJavaScript.length() == 0) {
                JavaScriptDocument jsDoc = new JavaScriptDocument();
                if (!this.m_skipValidation) {
                    List requiredDef;
                    this.mandatoryRulesAsJavaScript(jsDoc);
                    List list = requiredDef = Collections.synchronizedList(new ArrayList());
                    synchronized (list) {
                        DocumentObject.parametersAsJavaScript(jsDoc, this.m_nameParameters, this.m_namePatternParameters, requiredDef, this);
                        DocumentObject.globalsAsJavaScript(jsDoc, this.m_globals, requiredDef, this);
                        DocumentObject.importedParamGlobalAsJavaScriptInDocs(this.m_importedParamDocs, jsDoc, Collections.synchronizedSet(new HashSet()), requiredDef, this);
                        Set<Definition> addedDefinitions = Collections.synchronizedSet(new HashSet());
                        Definition definition = null;
                        while (!requiredDef.isEmpty()) {
                            definition = (Definition)requiredDef.remove(0);
                            if (addedDefinitions.contains(definition)) continue;
                            DocumentObject.definitionAsJavaScript(jsDoc, definition, requiredDef, this);
                            Set<Definition> set = addedDefinitions;
                            synchronized (set) {
                                addedDefinitions.add(definition);
                            }
                        }
                    }
                }
                this.m_asJavaScript = jsDoc.close();
                if (Log.traceEnabled) {
                    Log.trace(new Message("document as JavaScript", "JavaScript", this.m_asJavaScript), 10000);
                }
            }
        }
        return this.m_asJavaScript;
    }

    @Override
    public int nextJSParamNameFunctionIndex() {
        return this.m_jsParamNameFunctionIndex++;
    }

    @Override
    public int nextJSGlobalFunctionIndex() {
        return this.m_jsGlobalFunctionIndex++;
    }
}

